/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.gatekeeper.shared.objects;

import java.net.InetAddress;
import xyz.lychee.gatekeeper.shared.manager.AccountLimitManager;
import xyz.lychee.gatekeeper.shared.manager.ChecksManager;
import xyz.lychee.gatekeeper.shared.manager.DataManager;
import xyz.lychee.gatekeeper.shared.manager.RateLimitManager;
import xyz.lychee.gatekeeper.shared.objects.AbstractCheck;
import xyz.lychee.gatekeeper.shared.objects.EnumAccess;
import xyz.lychee.gatekeeper.shared.objects.StoredPlayer;
import xyz.lychee.gatekeeper.shared.util.AddressUtils;

public class ListenerHandler {
    public void handleDisconnect(InetAddress address) {
        int addressData = AddressUtils.addressToInteger(address);
        AccountLimitManager.INSTANCE.decrement(addressData);
    }

    public void handlePostLogin(InetAddress address) {
        int addressData = AddressUtils.addressToInteger(address);
        AccountLimitManager.INSTANCE.increment(addressData);
        RateLimitManager.INSTANCE.update(addressData);
    }

    public Object handlePreLogin(InetAddress address, String name) {
        DataManager data = DataManager.INSTANCE;
        int addressData = AddressUtils.addressToInteger(address);
        if (data.hasAccess(addressData, EnumAccess.WHITELIST) || data.hasAccess(name, EnumAccess.WHITELIST)) {
            return null;
        }
        AbstractCheck check = ChecksManager.INSTANCE.checkPlayer(address, name);
        if (check != null && check.getKickMessage() != null) {
            check.printCheck(address, name);
            return check.getKickMessage();
        }
        StoredPlayer player = new StoredPlayer(name, addressData);
        if (!data.getPlayers().contains(player)) {
            data.updatePlayer(player);
        }
        return null;
    }
}

