/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.deser;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonIncludeProperties;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicReference;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.BeanDescription;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.DatabindContext;
import tools.jackson.databind.DeserializationConfig;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.EnumNamingStrategy;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.KeyDeserializer;
import tools.jackson.databind.MapperFeature;
import tools.jackson.databind.PropertyMetadata;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.cfg.ConfigOverride;
import tools.jackson.databind.cfg.ConstructorDetector;
import tools.jackson.databind.cfg.DeserializerFactoryConfig;
import tools.jackson.databind.cfg.HandlerInstantiator;
import tools.jackson.databind.cfg.MapperConfig;
import tools.jackson.databind.deser.AbstractDeserializer;
import tools.jackson.databind.deser.CreatorProperty;
import tools.jackson.databind.deser.DeserializerFactory;
import tools.jackson.databind.deser.Deserializers;
import tools.jackson.databind.deser.KeyDeserializers;
import tools.jackson.databind.deser.SettableBeanProperty;
import tools.jackson.databind.deser.ValueDeserializerModifier;
import tools.jackson.databind.deser.ValueInstantiator;
import tools.jackson.databind.deser.ValueInstantiators;
import tools.jackson.databind.deser.bean.CreatorCandidate;
import tools.jackson.databind.deser.bean.CreatorCollector;
import tools.jackson.databind.deser.impl.UnwrappedPropertyHandler;
import tools.jackson.databind.deser.jackson.JsonNodeDeserializer;
import tools.jackson.databind.deser.jackson.TokenBufferDeserializer;
import tools.jackson.databind.deser.jdk.ArrayBlockingQueueDeserializer;
import tools.jackson.databind.deser.jdk.AtomicReferenceDeserializer;
import tools.jackson.databind.deser.jdk.CollectionDeserializer;
import tools.jackson.databind.deser.jdk.EnumDeserializer;
import tools.jackson.databind.deser.jdk.EnumMapDeserializer;
import tools.jackson.databind.deser.jdk.EnumSetDeserializer;
import tools.jackson.databind.deser.jdk.JDKDateDeserializers;
import tools.jackson.databind.deser.jdk.JDKKeyDeserializers;
import tools.jackson.databind.deser.jdk.JDKMiscDeserializers;
import tools.jackson.databind.deser.jdk.JDKValueInstantiators;
import tools.jackson.databind.deser.jdk.JavaUtilCollectionsDeserializers;
import tools.jackson.databind.deser.jdk.MapDeserializer;
import tools.jackson.databind.deser.jdk.MapEntryDeserializer;
import tools.jackson.databind.deser.jdk.NumberDeserializers;
import tools.jackson.databind.deser.jdk.ObjectArrayDeserializer;
import tools.jackson.databind.deser.jdk.PrimitiveArrayDeserializers;
import tools.jackson.databind.deser.jdk.StringArrayDeserializer;
import tools.jackson.databind.deser.jdk.StringCollectionDeserializer;
import tools.jackson.databind.deser.jdk.StringDeserializer;
import tools.jackson.databind.deser.jdk.UntypedObjectDeserializer;
import tools.jackson.databind.ext.OptionalHandlerFactory;
import tools.jackson.databind.ext.jdk8.Jdk8OptionalDeserializer;
import tools.jackson.databind.ext.jdk8.OptionalDoubleDeserializer;
import tools.jackson.databind.ext.jdk8.OptionalIntDeserializer;
import tools.jackson.databind.ext.jdk8.OptionalLongDeserializer;
import tools.jackson.databind.introspect.Annotated;
import tools.jackson.databind.introspect.AnnotatedClass;
import tools.jackson.databind.introspect.AnnotatedConstructor;
import tools.jackson.databind.introspect.AnnotatedMember;
import tools.jackson.databind.introspect.AnnotatedMethod;
import tools.jackson.databind.introspect.AnnotatedParameter;
import tools.jackson.databind.introspect.AnnotatedWithParams;
import tools.jackson.databind.introspect.EnumNamingStrategyFactory;
import tools.jackson.databind.introspect.PotentialCreator;
import tools.jackson.databind.introspect.PotentialCreators;
import tools.jackson.databind.introspect.VisibilityChecker;
import tools.jackson.databind.jsontype.TypeDeserializer;
import tools.jackson.databind.type.ArrayType;
import tools.jackson.databind.type.CollectionLikeType;
import tools.jackson.databind.type.CollectionType;
import tools.jackson.databind.type.MapLikeType;
import tools.jackson.databind.type.MapType;
import tools.jackson.databind.type.ReferenceType;
import tools.jackson.databind.type.TypeFactory;
import tools.jackson.databind.util.ClassUtil;
import tools.jackson.databind.util.EnumResolver;
import tools.jackson.databind.util.NameTransformer;
import tools.jackson.databind.util.TokenBuffer;

public abstract class BasicDeserializerFactory
extends DeserializerFactory
implements Serializable {
    private static final Class<?> CLASS_OBJECT = Object.class;
    private static final Class<?> CLASS_STRING = String.class;
    private static final Class<?> CLASS_CHAR_SEQUENCE = CharSequence.class;
    private static final Class<?> CLASS_ITERABLE = Iterable.class;
    private static final Class<?> CLASS_MAP_ENTRY = Map.Entry.class;
    private static final Class<?> CLASS_SERIALIZABLE = Serializable.class;
    protected final DeserializerFactoryConfig _factoryConfig;

    protected BasicDeserializerFactory(DeserializerFactoryConfig config) {
        this._factoryConfig = config;
    }

    public DeserializerFactoryConfig getFactoryConfig() {
        return this._factoryConfig;
    }

    protected abstract DeserializerFactory withConfig(DeserializerFactoryConfig var1);

    @Override
    public final DeserializerFactory withAdditionalDeserializers(Deserializers additional) {
        return this.withConfig(this._factoryConfig.withAdditionalDeserializers(additional));
    }

    @Override
    public final DeserializerFactory withAdditionalKeyDeserializers(KeyDeserializers additional) {
        return this.withConfig(this._factoryConfig.withAdditionalKeyDeserializers(additional));
    }

    @Override
    public final DeserializerFactory withDeserializerModifier(ValueDeserializerModifier modifier) {
        return this.withConfig(this._factoryConfig.withDeserializerModifier(modifier));
    }

    @Override
    public final DeserializerFactory withValueInstantiators(ValueInstantiators instantiators) {
        return this.withConfig(this._factoryConfig.withValueInstantiators(instantiators));
    }

    @Override
    public ValueInstantiator findValueInstantiator(DeserializationContext ctxt, BeanDescription.Supplier beanDescRef) {
        DeserializationConfig config = ctxt.getConfig();
        boolean hasCustom = this._factoryConfig.hasValueInstantiators();
        ValueInstantiator instantiator = null;
        AnnotatedClass ac = beanDescRef.getClassInfo();
        Object instDef = config.getAnnotationIntrospector().findValueInstantiator(ctxt.getConfig(), ac);
        if (instDef != null) {
            instantiator = this._valueInstantiatorInstance(config, ac, instDef);
        }
        if (instantiator == null && (instantiator = JDKValueInstantiators.findStdValueInstantiator(config, beanDescRef.getBeanClass())) == null) {
            if (hasCustom) {
                ValueInstantiators insts;
                Iterator<ValueInstantiators> iterator = this._factoryConfig.valueInstantiators().iterator();
                while (iterator.hasNext() && (instantiator = (insts = iterator.next()).findValueInstantiator(config, beanDescRef)) == null) {
                }
            }
            if (instantiator == null) {
                instantiator = this._constructDefaultValueInstantiator(ctxt, beanDescRef);
            }
        }
        if (hasCustom) {
            for (ValueInstantiators insts : this._factoryConfig.valueInstantiators()) {
                instantiator = insts.modifyValueInstantiator(config, beanDescRef, instantiator);
                if (instantiator != null) continue;
                ctxt.reportBadTypeDefinition(beanDescRef, "Broken registered ValueInstantiators (of type %s): returned null ValueInstantiator", insts.getClass().getName());
            }
        }
        if (instantiator != null) {
            instantiator = instantiator.createContextual(ctxt, beanDescRef);
        }
        return instantiator;
    }

    protected ValueInstantiator _constructDefaultValueInstantiator(DeserializationContext ctxt, BeanDescription.Supplier beanDescRef) {
        boolean isNonStaticInnerClass;
        DeserializationConfig config = ctxt.getConfig();
        PotentialCreators potentialCreators = beanDescRef.get().getPotentialCreators();
        ConstructorDetector ctorDetector = config.getConstructorDetector();
        VisibilityChecker vchecker = ((MapperConfig)config).getDefaultVisibilityChecker(beanDescRef.getBeanClass(), beanDescRef.getClassInfo());
        CreatorCollector creators = new CreatorCollector(config, beanDescRef.getType());
        if (potentialCreators.hasPropertiesBased()) {
            PotentialCreator primaryPropsBased = potentialCreators.propertiesBased;
            if (primaryPropsBased.paramCount() == 0) {
                creators.setDefaultCreator(primaryPropsBased.creator());
            } else {
                this._addSelectedPropertiesBasedCreator(ctxt, beanDescRef, creators, CreatorCandidate.construct(config, primaryPropsBased.creator(), primaryPropsBased.propertyDefs()));
            }
        }
        boolean hasExplicitDelegating = this._addExplicitDelegatingCreators(ctxt, beanDescRef, creators, potentialCreators.getExplicitDelegating());
        if (beanDescRef.getType().isConcrete() && !(isNonStaticInnerClass = beanDescRef.get().isNonStaticInnerClass())) {
            boolean findImplicit;
            AnnotatedConstructor defaultCtor;
            if (!creators.hasDefaultCreator() && (defaultCtor = beanDescRef.get().findDefaultConstructor()) != null) {
                creators.setDefaultCreator(defaultCtor);
            }
            if (findImplicit = ctorDetector.shouldIntrospectImplicitConstructors(beanDescRef.getBeanClass())) {
                this._addImplicitDelegatingConstructors(ctxt, beanDescRef, vchecker, creators, potentialCreators.getImplicitDelegatingConstructors());
            }
        }
        if (!hasExplicitDelegating) {
            this._addImplicitDelegatingFactories(ctxt, vchecker, creators, potentialCreators.getImplicitDelegatingFactories());
        }
        return creators.constructValueInstantiator(ctxt);
    }

    public ValueInstantiator _valueInstantiatorInstance(DeserializationConfig config, Annotated annotated, Object instDef) {
        ValueInstantiator inst;
        if (instDef == null) {
            return null;
        }
        if (instDef instanceof ValueInstantiator) {
            return (ValueInstantiator)instDef;
        }
        if (!(instDef instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector returned key deserializer definition of type " + instDef.getClass().getName() + "; expected type KeyDeserializer or Class<KeyDeserializer> instead");
        }
        Class instClass = (Class)instDef;
        if (ClassUtil.isBogusClass(instClass)) {
            return null;
        }
        if (!ValueInstantiator.class.isAssignableFrom(instClass)) {
            throw new IllegalStateException("AnnotationIntrospector returned Class " + instClass.getName() + "; expected Class<ValueInstantiator>");
        }
        HandlerInstantiator hi = config.getHandlerInstantiator();
        if (hi != null && (inst = hi.valueInstantiatorInstance(config, annotated, instClass)) != null) {
            return inst;
        }
        return (ValueInstantiator)ClassUtil.createInstance(instClass, config.canOverrideAccessModifiers());
    }

    private boolean _addExplicitDelegatingCreators(DeserializationContext ctxt, BeanDescription.Supplier beanDescRef, CreatorCollector creators, List<PotentialCreator> potentials) {
        DeserializationConfig config = ctxt.getConfig();
        boolean added = false;
        for (PotentialCreator ctor : potentials) {
            added |= this._addExplicitDelegatingCreator(ctxt, beanDescRef, creators, CreatorCandidate.construct(config, ctor.creator(), null));
        }
        return added;
    }

    private void _addImplicitDelegatingConstructors(DeserializationContext ctxt, BeanDescription.Supplier beanDescRef, VisibilityChecker vchecker, CreatorCollector creators, List<PotentialCreator> potentials) {
        DeserializationConfig config = ctxt.getConfig();
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        for (PotentialCreator candidate : potentials) {
            int argCount = candidate.paramCount();
            AnnotatedWithParams ctor = candidate.creator();
            if (argCount == 1) {
                this._handleSingleArgumentCreator(creators, ctor, false, true);
                continue;
            }
            SettableBeanProperty[] properties = new SettableBeanProperty[argCount];
            int injectCount = 0;
            for (int i = 0; i < argCount; ++i) {
                AnnotatedParameter param = ctor.getParameter(i);
                JacksonInject.Value injectable = intr.findInjectableValue(config, param);
                if (injectable != null) {
                    ++injectCount;
                    properties[i] = this.constructCreatorProperty(ctxt, beanDescRef, null, i, param, injectable);
                    continue;
                }
                NameTransformer unwrapper = intr.findUnwrappingNameTransformer(config, param);
                if (unwrapper == null) continue;
                properties[i] = this.constructCreatorProperty(ctxt, beanDescRef, UnwrappedPropertyHandler.creatorParamName(i), i, param, null);
            }
            if (injectCount + 1 != argCount) continue;
            creators.addDelegatingCreator(ctor, false, properties, 0);
        }
    }

    private void _addImplicitDelegatingFactories(DeserializationContext ctxt, VisibilityChecker vchecker, CreatorCollector creators, List<PotentialCreator> potentials) {
        for (PotentialCreator candidate : potentials) {
            int argCount = candidate.paramCount();
            AnnotatedWithParams factory = candidate.creator();
            if (argCount != 1) continue;
            this._handleSingleArgumentCreator(creators, factory, false, vchecker.isCreatorVisible(factory));
        }
    }

    private boolean _addExplicitDelegatingCreator(DeserializationContext ctxt, BeanDescription.Supplier beanDescRef, CreatorCollector creators, CreatorCandidate candidate) {
        int ix = -1;
        int argCount = candidate.paramCount();
        SettableBeanProperty[] properties = new SettableBeanProperty[argCount];
        if (argCount == 0) {
            creators.addPropertyCreator(candidate.creator(), true, properties);
            return true;
        }
        for (int i = 0; i < argCount; ++i) {
            AnnotatedParameter param = candidate.parameter(i);
            JacksonInject.Value injectId = candidate.injection(i);
            if (injectId != null) {
                properties[i] = this.constructCreatorProperty(ctxt, beanDescRef, null, i, param, injectId);
                continue;
            }
            if (ix < 0) {
                ix = i;
                continue;
            }
            ctxt.reportBadTypeDefinition(beanDescRef, "More than one argument (#%d and #%d) left as delegating for Creator %s: only one allowed", ix, i, candidate);
        }
        if (ix < 0) {
            ctxt.reportBadTypeDefinition(beanDescRef, "No argument left as delegating for Creator %s: exactly one required", candidate);
        }
        if (argCount == 1) {
            return this._handleSingleArgumentCreator(creators, candidate.creator(), true, true);
        }
        creators.addDelegatingCreator(candidate.creator(), true, properties, ix);
        return true;
    }

    private void _addSelectedPropertiesBasedCreator(DeserializationContext ctxt, BeanDescription.Supplier beanDescRef, CreatorCollector creators, CreatorCandidate candidate) {
        DeserializationConfig config = ctxt.getConfig();
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        int paramCount = candidate.paramCount();
        SettableBeanProperty[] properties = new SettableBeanProperty[paramCount];
        int anySetterIx = -1;
        for (int i = 0; i < paramCount; ++i) {
            JacksonInject.Value injectId = candidate.injection(i);
            AnnotatedParameter param = candidate.parameter(i);
            PropertyName name = candidate.paramName(i);
            boolean isAnySetter = Boolean.TRUE.equals(ctxt.getAnnotationIntrospector().hasAnySetter(config, param));
            if (isAnySetter) {
                if (anySetterIx >= 0) {
                    ctxt.reportBadTypeDefinition(beanDescRef, "More than one 'any-setter' specified (parameter #%d vs #%d)", anySetterIx, i);
                } else {
                    anySetterIx = i;
                }
            } else if (name == null) {
                NameTransformer unwrapper = intr.findUnwrappingNameTransformer(config, param);
                if (unwrapper != null) {
                    properties[i] = this.constructCreatorProperty(ctxt, beanDescRef, UnwrappedPropertyHandler.creatorParamName(i), i, param, null);
                }
                if (name == null && injectId == null) {
                    ctxt.reportBadTypeDefinition(beanDescRef, "Argument #%d of Creator %s has no property name (and is not Injectable): cannot use as property-based Creator", i, candidate);
                }
            }
            properties[i] = this.constructCreatorProperty(ctxt, beanDescRef, name, i, param, injectId);
        }
        creators.addPropertyCreator(candidate.creator(), true, properties);
    }

    private boolean _handleSingleArgumentCreator(CreatorCollector creators, AnnotatedWithParams ctor, boolean isCreator, boolean isVisible) {
        Class<?> type = ctor.getRawParameterType(0);
        if (type == String.class || type == CLASS_CHAR_SEQUENCE) {
            if (isCreator || isVisible) {
                creators.addStringCreator(ctor, isCreator);
            }
            return true;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            if (isCreator || isVisible) {
                creators.addIntCreator(ctor, isCreator);
            }
            return true;
        }
        if (type == Long.TYPE || type == Long.class) {
            if (isCreator || isVisible) {
                creators.addLongCreator(ctor, isCreator);
            }
            return true;
        }
        if (type == Double.TYPE || type == Double.class) {
            if (isCreator || isVisible) {
                creators.addDoubleCreator(ctor, isCreator);
            }
            return true;
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            if (isCreator || isVisible) {
                creators.addBooleanCreator(ctor, isCreator);
            }
            return true;
        }
        if (type == BigInteger.class && (isCreator || isVisible)) {
            creators.addBigIntegerCreator(ctor, isCreator);
        }
        if (type == BigDecimal.class && (isCreator || isVisible)) {
            creators.addBigDecimalCreator(ctor, isCreator);
        }
        if (isCreator) {
            creators.addDelegatingCreator(ctor, isCreator, null, 0);
            return true;
        }
        return false;
    }

    protected SettableBeanProperty constructCreatorProperty(DeserializationContext ctxt, BeanDescription.Supplier beanDescRef, PropertyName name, int index, AnnotatedParameter param, JacksonInject.Value injectable) {
        PropertyName wrapperName;
        PropertyMetadata metadata;
        DeserializationConfig config = ctxt.getConfig();
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        if (intr == null) {
            metadata = PropertyMetadata.STD_REQUIRED_OR_OPTIONAL;
            wrapperName = null;
        } else {
            Boolean b = intr.hasRequiredMarker(config, param);
            String desc = intr.findPropertyDescription(config, param);
            Integer idx = intr.findPropertyIndex(config, param);
            String def = intr.findPropertyDefaultValue(config, param);
            metadata = PropertyMetadata.construct(b, desc, idx, def);
            wrapperName = intr.findWrapperName(config, param);
        }
        JavaType type = this.resolveMemberAndTypeAnnotations(ctxt, param, param.getType());
        BeanProperty.Std property = new BeanProperty.Std(name, type, wrapperName, param, metadata);
        TypeDeserializer typeDeser = (TypeDeserializer)type.getTypeHandler();
        if (typeDeser == null) {
            typeDeser = ctxt.findTypeDeserializer(type);
        }
        metadata = this._getSetterInfo(config, property, metadata);
        SettableBeanProperty prop = CreatorProperty.construct(name, type, property.getWrapperName(), typeDeser, beanDescRef.getClassAnnotations(), param, index, injectable, metadata);
        ValueDeserializer<?> deser = this.findDeserializerFromAnnotation(ctxt, param);
        if (deser == null) {
            deser = (ValueDeserializer<?>)type.getValueHandler();
        }
        if (deser != null) {
            deser = ctxt.handlePrimaryContextualization(deser, prop, type);
            prop = ((SettableBeanProperty)prop).withValueDeserializer(deser);
        }
        return prop;
    }

    private PropertyMetadata _getSetterInfo(MapperConfig<?> config, BeanProperty prop, PropertyMetadata metadata) {
        JsonSetter.Value setterInfo;
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        boolean needMerge = true;
        Nulls valueNulls = null;
        Nulls contentNulls = null;
        AnnotatedMember prim = prop.getMember();
        if (prim != null) {
            ConfigOverride co;
            JsonSetter.Value setterInfo2;
            if (intr != null && (setterInfo = intr.findSetterInfo(config, prim)) != null) {
                valueNulls = setterInfo.nonDefaultValueNulls();
                contentNulls = setterInfo.nonDefaultContentNulls();
            }
            if ((needMerge || valueNulls == null || contentNulls == null) && (setterInfo2 = (co = config.getConfigOverride(prop.getType().getRawClass())).getNullHandling()) != null) {
                if (valueNulls == null) {
                    valueNulls = setterInfo2.nonDefaultValueNulls();
                }
                if (contentNulls == null) {
                    contentNulls = setterInfo2.nonDefaultContentNulls();
                }
            }
        }
        if (needMerge || valueNulls == null || contentNulls == null) {
            setterInfo = config.getDefaultNullHandling();
            if (valueNulls == null) {
                valueNulls = setterInfo.nonDefaultValueNulls();
            }
            if (contentNulls == null) {
                contentNulls = setterInfo.nonDefaultContentNulls();
            }
        }
        if (valueNulls != null || contentNulls != null) {
            metadata = metadata.withNulls(valueNulls, contentNulls);
        }
        return metadata;
    }

    @Override
    public ValueDeserializer<?> createArrayDeserializer(DeserializationContext ctxt, ArrayType type, BeanDescription.Supplier beanDescRef) {
        ValueDeserializer deser;
        DeserializationConfig config = ctxt.getConfig();
        JavaType elemType = type.getContentType();
        ValueDeserializer contentDeser = (ValueDeserializer)elemType.getValueHandler();
        TypeDeserializer elemTypeDeser = (TypeDeserializer)elemType.getTypeHandler();
        if (elemTypeDeser == null) {
            elemTypeDeser = ctxt.findTypeDeserializer(elemType);
        }
        if ((deser = this._findCustomArrayDeserializer(type, config, beanDescRef, elemTypeDeser, contentDeser)) == null) {
            if (contentDeser == null) {
                if (elemType.isPrimitive()) {
                    deser = PrimitiveArrayDeserializers.forType(elemType.getRawClass());
                } else if (elemType.hasRawClass(String.class)) {
                    deser = StringArrayDeserializer.instance;
                }
            }
            if (deser == null) {
                deser = new ObjectArrayDeserializer((JavaType)type, contentDeser, elemTypeDeser);
            }
        }
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (ValueDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                deser = mod.modifyArrayDeserializer(config, type, beanDescRef, deser);
            }
        }
        return deser;
    }

    @Override
    public ValueDeserializer<?> createCollectionDeserializer(DeserializationContext ctxt, CollectionType type, BeanDescription.Supplier beanDescRef) {
        ValueDeserializer deser;
        JavaType contentType = type.getContentType();
        ValueDeserializer contentDeser = (ValueDeserializer)contentType.getValueHandler();
        DeserializationConfig config = ctxt.getConfig();
        TypeDeserializer contentTypeDeser = (TypeDeserializer)contentType.getTypeHandler();
        if (contentTypeDeser == null) {
            contentTypeDeser = ctxt.findTypeDeserializer(contentType);
        }
        if ((deser = this._findCustomCollectionDeserializer(type, config, beanDescRef, contentTypeDeser, contentDeser)) == null) {
            Class<Object> collectionClass = type.getRawClass();
            if (contentDeser == null) {
                if (contentType.isEnumType() && collectionClass == Set.class) {
                    collectionClass = EnumSet.class;
                    type = (CollectionType)config.getTypeFactory().constructSpecializedType(type, collectionClass);
                }
                if (EnumSet.class.isAssignableFrom(collectionClass)) {
                    deser = new EnumSetDeserializer(contentType, null);
                }
            }
        }
        if (deser == null) {
            CollectionType implType;
            if ((type.isInterface() || type.isAbstract()) && (implType = this._mapAbstractCollectionType(type, config)) != null) {
                type = implType;
                beanDescRef = ctxt.lazyIntrospectBeanDescriptionForCreation(type);
            }
            if (deser == null) {
                ValueInstantiator inst = this.findValueInstantiator(ctxt, beanDescRef);
                if (!inst.canCreateUsingDefault()) {
                    if (type.hasRawClass(ArrayBlockingQueue.class)) {
                        return new ArrayBlockingQueueDeserializer(type, contentDeser, contentTypeDeser, inst);
                    }
                    deser = JavaUtilCollectionsDeserializers.findForCollection(ctxt, type);
                    if (deser != null) {
                        return deser;
                    }
                }
                deser = contentType.hasRawClass(String.class) ? new StringCollectionDeserializer((JavaType)type, contentDeser, inst) : new CollectionDeserializer(type, contentDeser, contentTypeDeser, inst);
            }
        }
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (ValueDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                deser = mod.modifyCollectionDeserializer(config, type, beanDescRef, deser);
            }
        }
        return deser;
    }

    protected CollectionType _mapAbstractCollectionType(JavaType type, DeserializationConfig config) {
        Class<?> collectionClass = ContainerDefaultMappings.findCollectionFallback(type);
        if (collectionClass != null) {
            return (CollectionType)config.getTypeFactory().constructSpecializedType(type, collectionClass, true);
        }
        return null;
    }

    @Override
    public ValueDeserializer<?> createCollectionLikeDeserializer(DeserializationContext ctxt, CollectionLikeType type, BeanDescription.Supplier beanDescRef) {
        ValueDeserializer<?> deser;
        JavaType contentType = type.getContentType();
        ValueDeserializer contentDeser = (ValueDeserializer)contentType.getValueHandler();
        DeserializationConfig config = ctxt.getConfig();
        TypeDeserializer contentTypeDeser = (TypeDeserializer)contentType.getTypeHandler();
        if (contentTypeDeser == null) {
            contentTypeDeser = ctxt.findTypeDeserializer(contentType);
        }
        if ((deser = this._findCustomCollectionLikeDeserializer(type, config, beanDescRef, contentTypeDeser, contentDeser)) != null && this._factoryConfig.hasDeserializerModifiers()) {
            for (ValueDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                deser = mod.modifyCollectionLikeDeserializer(config, type, beanDescRef, deser);
            }
        }
        return deser;
    }

    @Override
    public ValueDeserializer<?> createMapDeserializer(DeserializationContext ctxt, MapType type, BeanDescription.Supplier beanDescRef) {
        ValueDeserializer deser;
        DeserializationConfig config = ctxt.getConfig();
        JavaType keyType = type.getKeyType();
        JavaType contentType = type.getContentType();
        ValueDeserializer contentDeser = (ValueDeserializer)contentType.getValueHandler();
        KeyDeserializer keyDes = (KeyDeserializer)keyType.getValueHandler();
        TypeDeserializer contentTypeDeser = (TypeDeserializer)contentType.getTypeHandler();
        if (contentTypeDeser == null) {
            contentTypeDeser = ctxt.findTypeDeserializer(contentType);
        }
        if ((deser = this._findCustomMapDeserializer(type, config, beanDescRef, keyDes, contentTypeDeser, contentDeser)) == null) {
            ValueInstantiator inst;
            Class<Object> mapClass = type.getRawClass();
            if (mapClass == Map.class && keyType.isEnumType()) {
                mapClass = EnumMap.class;
                type = (MapType)config.getTypeFactory().constructSpecializedType(type, mapClass);
            }
            if (EnumMap.class.isAssignableFrom(mapClass)) {
                inst = mapClass == EnumMap.class ? null : this.findValueInstantiator(ctxt, beanDescRef);
                if (!keyType.isEnumImplType()) {
                    throw new IllegalArgumentException("Cannot construct EnumMap; generic (key) type not available");
                }
                deser = new EnumMapDeserializer(type, inst, null, contentDeser, contentTypeDeser, null);
            }
            if (deser == null) {
                if (type.isInterface() || type.isAbstract()) {
                    MapType implType = this._mapAbstractMapType(type, config);
                    if (implType != null) {
                        type = implType;
                        mapClass = type.getRawClass();
                        beanDescRef = ctxt.lazyIntrospectBeanDescriptionForCreation(type);
                    }
                } else {
                    deser = JavaUtilCollectionsDeserializers.findForMap(ctxt, type);
                    if (deser != null) {
                        return deser;
                    }
                }
                if (deser == null) {
                    inst = this.findValueInstantiator(ctxt, beanDescRef);
                    MapDeserializer md = new MapDeserializer(type, inst, keyDes, contentDeser, contentTypeDeser);
                    JsonIgnoreProperties.Value ignorals = config.getDefaultPropertyIgnorals(Map.class, beanDescRef.getClassInfo());
                    Set<String> ignored = ignorals == null ? null : ignorals.findIgnoredForDeserialization();
                    md.setIgnorableProperties(ignored);
                    JsonIncludeProperties.Value inclusions = config.getDefaultPropertyInclusions(Map.class, beanDescRef.getClassInfo());
                    Set<String> included = inclusions == null ? null : inclusions.getIncluded();
                    md.setIncludableProperties(included);
                    deser = md;
                }
            }
        }
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (ValueDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                deser = mod.modifyMapDeserializer(config, type, beanDescRef, deser);
            }
        }
        return deser;
    }

    protected MapType _mapAbstractMapType(JavaType type, DeserializationConfig config) {
        Class<?> mapClass = ContainerDefaultMappings.findMapFallback(type);
        if (mapClass != null) {
            return (MapType)config.getTypeFactory().constructSpecializedType(type, mapClass, true);
        }
        return null;
    }

    @Override
    public ValueDeserializer<?> createMapLikeDeserializer(DeserializationContext ctxt, MapLikeType type, BeanDescription.Supplier beanDescRef) {
        ValueDeserializer<?> deser;
        JavaType keyType = type.getKeyType();
        JavaType contentType = type.getContentType();
        DeserializationConfig config = ctxt.getConfig();
        ValueDeserializer contentDeser = (ValueDeserializer)contentType.getValueHandler();
        KeyDeserializer keyDes = (KeyDeserializer)keyType.getValueHandler();
        TypeDeserializer contentTypeDeser = (TypeDeserializer)contentType.getTypeHandler();
        if (contentTypeDeser == null) {
            contentTypeDeser = ctxt.findTypeDeserializer(contentType);
        }
        if ((deser = this._findCustomMapLikeDeserializer(type, config, beanDescRef, keyDes, contentTypeDeser, contentDeser)) != null && this._factoryConfig.hasDeserializerModifiers()) {
            for (ValueDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                deser = mod.modifyMapLikeDeserializer(config, type, beanDescRef, deser);
            }
        }
        return deser;
    }

    @Override
    public ValueDeserializer<?> createEnumDeserializer(DeserializationContext ctxt, JavaType type, BeanDescription.Supplier beanDescRef) {
        DeserializationConfig config = ctxt.getConfig();
        ValueDeserializer deser = this._findCustomEnumDeserializer(type, config, beanDescRef);
        if (deser == null) {
            if (type.hasRawClass(Enum.class)) {
                return AbstractDeserializer.constructForNonPOJO(beanDescRef);
            }
            Class<?> enumClass = type.getRawClass();
            ValueInstantiator valueInstantiator = this._constructDefaultValueInstantiator(ctxt, beanDescRef);
            SettableBeanProperty[] creatorProps = valueInstantiator == null ? null : valueInstantiator.getFromObjectArguments(config);
            for (AnnotatedMethod factory : beanDescRef.get().getFactoryMethods()) {
                if (!this._hasCreatorAnnotation(config, factory)) continue;
                if (factory.getParameterCount() == 0) {
                    deser = EnumDeserializer.deserializerForNoArgsCreator(config, enumClass, factory);
                    break;
                }
                Class<?> returnType = factory.getRawReturnType();
                if (!returnType.isAssignableFrom(enumClass)) {
                    ctxt.reportBadDefinition(type, String.format("Invalid `@JsonCreator` annotated Enum factory method [%s]: needs to return compatible type", factory.toString()));
                }
                deser = EnumDeserializer.deserializerForCreator(config, enumClass, factory, valueInstantiator, creatorProps, this.constructEnumResolver(ctxt, enumClass, beanDescRef));
                break;
            }
            if (deser == null) {
                deser = new EnumDeserializer(this.constructEnumResolver(ctxt, enumClass, beanDescRef), config.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS), this.constructEnumNamingStrategyResolver(config, beanDescRef.getClassInfo()), EnumResolver.constructUsingToString(config, beanDescRef.getClassInfo()));
            }
        }
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (ValueDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                deser = mod.modifyEnumDeserializer(config, type, beanDescRef, deser);
            }
        }
        return deser;
    }

    @Override
    public ValueDeserializer<?> createTreeDeserializer(DeserializationConfig config, JavaType nodeType, BeanDescription.Supplier beanDescRef) {
        ValueDeserializer<?> custom = this._findCustomTreeNodeDeserializer(nodeType, config, beanDescRef);
        if (custom != null) {
            return custom;
        }
        if (nodeType.isTypeOrSubTypeOf(JsonNode.class)) {
            return JsonNodeDeserializer.getDeserializer(nodeType.getRawClass());
        }
        return null;
    }

    @Override
    public ValueDeserializer<?> createReferenceDeserializer(DeserializationContext ctxt, ReferenceType type, BeanDescription.Supplier beanDescRef) {
        ValueDeserializer<?> deser;
        JavaType contentType = type.getContentType();
        ValueDeserializer contentDeser = (ValueDeserializer)contentType.getValueHandler();
        DeserializationConfig config = ctxt.getConfig();
        TypeDeserializer contentTypeDeser = (TypeDeserializer)contentType.getTypeHandler();
        if (contentTypeDeser == null) {
            contentTypeDeser = ctxt.findTypeDeserializer(contentType);
        }
        if ((deser = this._findCustomReferenceDeserializer(type, config, beanDescRef, contentTypeDeser, contentDeser)) == null) {
            if (type.isTypeOrSubTypeOf(Optional.class)) {
                ValueInstantiator inst = type.hasRawClass(Optional.class) ? null : this.findValueInstantiator(ctxt, beanDescRef);
                return new Jdk8OptionalDeserializer(type, inst, contentTypeDeser, contentDeser);
            }
            if (type.isTypeOrSubTypeOf(AtomicReference.class)) {
                ValueInstantiator inst = type.hasRawClass(AtomicReference.class) ? null : this.findValueInstantiator(ctxt, beanDescRef);
                return new AtomicReferenceDeserializer(type, inst, contentTypeDeser, contentDeser);
            }
            if (type.hasRawClass(OptionalInt.class)) {
                return new OptionalIntDeserializer();
            }
            if (type.hasRawClass(OptionalLong.class)) {
                return new OptionalLongDeserializer();
            }
            if (type.hasRawClass(OptionalDouble.class)) {
                return new OptionalDoubleDeserializer();
            }
        }
        if (deser != null && this._factoryConfig.hasDeserializerModifiers()) {
            for (ValueDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                deser = mod.modifyReferenceDeserializer(config, type, beanDescRef, deser);
            }
        }
        return deser;
    }

    protected ValueDeserializer<?> findOptionalStdDeserializer(DeserializationContext ctxt, JavaType type, BeanDescription.Supplier beanDescRef) {
        return OptionalHandlerFactory.instance.findDeserializer(ctxt.getConfig(), type);
    }

    @Override
    public KeyDeserializer createKeyDeserializer(DeserializationContext ctxt, JavaType type) {
        DeserializationConfig config = ctxt.getConfig();
        BeanDescription.Supplier beanDescRef = ctxt.lazyIntrospectBeanDescription(type);
        KeyDeserializer deser = this.findKeyDeserializerFromAnnotation(ctxt, beanDescRef.getClassInfo());
        if (deser == null && this._factoryConfig.hasKeyDeserializers()) {
            KeyDeserializers d;
            Iterator<Object> iterator = this._factoryConfig.keyDeserializers().iterator();
            while (iterator.hasNext() && (deser = (d = iterator.next()).findKeyDeserializer(type, config, beanDescRef)) == null) {
            }
        }
        if (deser == null) {
            deser = type.isEnumType() ? this._createEnumKeyDeserializer(ctxt, type) : JDKKeyDeserializers.findStringBasedKeyDeserializer(ctxt, type);
        }
        if (deser != null && this._factoryConfig.hasDeserializerModifiers()) {
            for (ValueDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                deser = mod.modifyKeyDeserializer(config, type, deser);
            }
        }
        return deser;
    }

    private KeyDeserializer _createEnumKeyDeserializer(DeserializationContext ctxt, JavaType type) {
        DeserializationConfig config = ctxt.getConfig();
        Class<?> enumClass = type.getRawClass();
        BeanDescription.Supplier beanDescRef = ctxt.lazyIntrospectBeanDescription(type);
        AnnotatedClass classInfo = beanDescRef.getClassInfo();
        KeyDeserializer des = this.findKeyDeserializerFromAnnotation(ctxt, beanDescRef.getClassInfo());
        if (des != null) {
            return des;
        }
        ValueDeserializer<?> custom = this._findCustomEnumDeserializer(type, config, beanDescRef);
        if (custom != null) {
            return JDKKeyDeserializers.constructDelegatingKeyDeserializer(config, type, custom);
        }
        ValueDeserializer<Object> valueDesForKey = this.findDeserializerFromAnnotation(ctxt, classInfo);
        if (valueDesForKey != null) {
            return JDKKeyDeserializers.constructDelegatingKeyDeserializer(config, type, valueDesForKey);
        }
        EnumResolver enumRes = this.constructEnumResolver(ctxt, enumClass, beanDescRef);
        EnumResolver byEnumNamingResolver = this.constructEnumNamingStrategyResolver(config, classInfo);
        EnumResolver byToStringResolver = EnumResolver.constructUsingToString(config, classInfo);
        EnumResolver byIndexResolver = EnumResolver.constructUsingIndex(config, classInfo);
        for (AnnotatedMethod factory : beanDescRef.get().getFactoryMethods()) {
            Class<?> returnType;
            if (!this._hasCreatorAnnotation(config, factory)) continue;
            int argCount = factory.getParameterCount();
            if (argCount == 1 && (returnType = factory.getRawReturnType()).isAssignableFrom(enumClass)) {
                if (factory.getRawParameterType(0) != String.class) continue;
                if (config.canOverrideAccessModifiers()) {
                    ClassUtil.checkAndFixAccess(factory.getMember(), ctxt.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
                }
                return JDKKeyDeserializers.constructEnumKeyDeserializer(enumRes, factory, byEnumNamingResolver, byToStringResolver, byIndexResolver);
            }
            throw new IllegalArgumentException("Unsuitable method (" + String.valueOf(factory) + ") decorated with @JsonCreator (for Enum type " + enumClass.getName() + ")");
        }
        return JDKKeyDeserializers.constructEnumKeyDeserializer(enumRes, byEnumNamingResolver, byToStringResolver, byIndexResolver);
    }

    @Override
    public boolean hasExplicitDeserializerFor(DatabindContext ctxt, Class<?> valueType) {
        if (valueType.isArray()) {
            while ((valueType = valueType.getComponentType()).isArray()) {
            }
            if (valueType == CLASS_OBJECT) {
                return true;
            }
        }
        if (Enum.class.isAssignableFrom(valueType)) {
            return true;
        }
        String clsName = valueType.getName();
        if (clsName.startsWith("java.")) {
            if (Collection.class.isAssignableFrom(valueType)) {
                return true;
            }
            if (Map.class.isAssignableFrom(valueType)) {
                return true;
            }
            if (Number.class.isAssignableFrom(valueType)) {
                return NumberDeserializers.find(valueType) != null;
            }
            if (JDKMiscDeserializers.hasDeserializerFor(valueType) || valueType == CLASS_STRING || valueType == Boolean.class || valueType == EnumMap.class || valueType == AtomicReference.class) {
                return true;
            }
            return JDKDateDeserializers.hasDeserializerFor(valueType);
        }
        if (clsName.startsWith("com.fasterxml.")) {
            return JsonNode.class.isAssignableFrom(valueType) || valueType == TokenBuffer.class;
        }
        return OptionalHandlerFactory.instance.hasDeserializerFor(valueType);
    }

    public ValueDeserializer<?> findDefaultDeserializer(DeserializationContext ctxt, JavaType type, BeanDescription.Supplier beanDescRef) {
        ValueDeserializer<?> deser;
        Class<?> rawType = type.getRawClass();
        if (rawType == CLASS_OBJECT || rawType == CLASS_SERIALIZABLE) {
            JavaType mt;
            JavaType lt;
            DeserializationConfig config = ctxt.getConfig();
            if (ctxt.getConfig().hasAbstractTypeResolvers()) {
                lt = this._findRemappedType(config, List.class);
                mt = this._findRemappedType(config, Map.class);
            } else {
                mt = null;
                lt = null;
            }
            return new UntypedObjectDeserializer(lt, mt);
        }
        if (rawType == CLASS_STRING || rawType == CLASS_CHAR_SEQUENCE) {
            return StringDeserializer.instance;
        }
        if (rawType == CLASS_ITERABLE) {
            TypeFactory tf = ctxt.getTypeFactory();
            JavaType[] tps = tf.findTypeParameters(type, CLASS_ITERABLE);
            JavaType elemType = tps == null || tps.length != 1 ? TypeFactory.unknownType() : tps[0];
            CollectionType ct = tf.constructCollectionType(Collection.class, elemType);
            return this.createCollectionDeserializer(ctxt, ct, beanDescRef);
        }
        if (rawType == CLASS_MAP_ENTRY) {
            JavaType kt = type.containedTypeOrUnknown(0);
            JavaType vt = type.containedTypeOrUnknown(1);
            TypeDeserializer vts = (TypeDeserializer)vt.getTypeHandler();
            if (vts == null) {
                vts = ctxt.findTypeDeserializer(vt);
            }
            ValueDeserializer valueDeser = (ValueDeserializer)vt.getValueHandler();
            KeyDeserializer keyDes = (KeyDeserializer)kt.getValueHandler();
            return new MapEntryDeserializer(type, keyDes, (ValueDeserializer<Object>)valueDeser, vts);
        }
        String clsName = rawType.getName();
        if (rawType.isPrimitive() || clsName.startsWith("java.")) {
            deser = NumberDeserializers.find(rawType);
            if (deser == null) {
                deser = JDKDateDeserializers.find(rawType, clsName);
            }
            if (deser != null) {
                return deser;
            }
        }
        if (rawType == TokenBuffer.class) {
            return new TokenBufferDeserializer();
        }
        deser = this.findOptionalStdDeserializer(ctxt, type, beanDescRef);
        if (deser != null) {
            return deser;
        }
        return JDKMiscDeserializers.find(ctxt, rawType, clsName);
    }

    private JavaType _findRemappedType(DeserializationConfig config, Class<?> rawType) {
        JavaType type = config.mapAbstractType(config.constructType(rawType));
        return type == null || type.hasRawClass(rawType) ? null : type;
    }

    protected ValueDeserializer<?> _findCustomTreeNodeDeserializer(JavaType type, DeserializationConfig config, BeanDescription.Supplier beanDescRef) {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            ValueDeserializer<?> deser = d.findTreeNodeDeserializer(type, config, beanDescRef);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    protected ValueDeserializer<?> _findCustomReferenceDeserializer(ReferenceType type, DeserializationConfig config, BeanDescription.Supplier beanDescRef, TypeDeserializer contentTypeDeserializer, ValueDeserializer<?> contentDeserializer) {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            ValueDeserializer<?> deser = d.findReferenceDeserializer(type, config, beanDescRef, contentTypeDeserializer, contentDeserializer);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    protected ValueDeserializer<Object> _findCustomBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription.Supplier beanDescRef) {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            ValueDeserializer<Object> deser = d.findBeanDeserializer(type, config, beanDescRef);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    protected ValueDeserializer<?> _findCustomArrayDeserializer(ArrayType type, DeserializationConfig config, BeanDescription.Supplier beanDescRef, TypeDeserializer elementTypeDeserializer, ValueDeserializer<?> elementDeserializer) {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            ValueDeserializer<?> deser = d.findArrayDeserializer(type, config, beanDescRef, elementTypeDeserializer, elementDeserializer);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    protected ValueDeserializer<?> _findCustomCollectionDeserializer(CollectionType type, DeserializationConfig config, BeanDescription.Supplier beanDescRef, TypeDeserializer elementTypeDeserializer, ValueDeserializer<?> elementDeserializer) {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            ValueDeserializer<?> deser = d.findCollectionDeserializer(type, config, beanDescRef, elementTypeDeserializer, elementDeserializer);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    protected ValueDeserializer<?> _findCustomCollectionLikeDeserializer(CollectionLikeType type, DeserializationConfig config, BeanDescription.Supplier beanDescRef, TypeDeserializer elementTypeDeserializer, ValueDeserializer<?> elementDeserializer) {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            ValueDeserializer<?> deser = d.findCollectionLikeDeserializer(type, config, beanDescRef, elementTypeDeserializer, elementDeserializer);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    protected ValueDeserializer<?> _findCustomEnumDeserializer(JavaType type, DeserializationConfig config, BeanDescription.Supplier beanDescRef) {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            ValueDeserializer<?> deser = d.findEnumDeserializer(type, config, beanDescRef);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    protected ValueDeserializer<?> _findCustomMapDeserializer(MapType type, DeserializationConfig config, BeanDescription.Supplier beanDescRef, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, ValueDeserializer<?> elementDeserializer) {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            ValueDeserializer<?> deser = d.findMapDeserializer(type, config, beanDescRef, keyDeserializer, elementTypeDeserializer, elementDeserializer);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    protected ValueDeserializer<?> _findCustomMapLikeDeserializer(MapLikeType type, DeserializationConfig config, BeanDescription.Supplier beanDescRef, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, ValueDeserializer<?> elementDeserializer) {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            ValueDeserializer<?> deser = d.findMapLikeDeserializer(type, config, beanDescRef, keyDeserializer, elementTypeDeserializer, elementDeserializer);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    protected ValueDeserializer<Object> findDeserializerFromAnnotation(DeserializationContext ctxt, Annotated ann) {
        Object deserDef;
        AnnotationIntrospector intr = ctxt.getAnnotationIntrospector();
        if (intr != null && (deserDef = intr.findDeserializer(ctxt.getConfig(), ann)) != null) {
            return ctxt.deserializerInstance(ann, deserDef);
        }
        return null;
    }

    protected KeyDeserializer findKeyDeserializerFromAnnotation(DeserializationContext ctxt, Annotated ann) {
        Object deserDef;
        AnnotationIntrospector intr = ctxt.getAnnotationIntrospector();
        if (intr != null && (deserDef = intr.findKeyDeserializer(ctxt.getConfig(), ann)) != null) {
            return ctxt.keyDeserializerInstance(ann, deserDef);
        }
        return null;
    }

    protected ValueDeserializer<Object> findContentDeserializerFromAnnotation(DeserializationContext ctxt, Annotated ann) {
        Object deserDef;
        AnnotationIntrospector intr = ctxt.getAnnotationIntrospector();
        if (intr != null && (deserDef = intr.findContentDeserializer(ctxt.getConfig(), ann)) != null) {
            return ctxt.deserializerInstance(ann, deserDef);
        }
        return null;
    }

    protected JavaType resolveMemberAndTypeAnnotations(DeserializationContext ctxt, AnnotatedMember member, JavaType type) {
        TypeDeserializer valueTypeDeser;
        Object kdDef;
        KeyDeserializer kd;
        JavaType keyType;
        AnnotationIntrospector intr = ctxt.getAnnotationIntrospector();
        if (intr == null) {
            return type;
        }
        if (type.isMapLikeType() && (keyType = type.getKeyType()) != null && (kd = ctxt.keyDeserializerInstance(member, kdDef = intr.findKeyDeserializer(ctxt.getConfig(), member))) != null) {
            type = ((MapLikeType)type).withKeyValueHandler(kd);
            keyType = type.getKeyType();
        }
        if (type.hasContentType()) {
            TypeDeserializer contentTypeDeser;
            Object cdDef = intr.findContentDeserializer(ctxt.getConfig(), member);
            ValueDeserializer<Object> cd = ctxt.deserializerInstance(member, cdDef);
            if (cd != null) {
                type = type.withContentValueHandler(cd);
            }
            if ((contentTypeDeser = ctxt.findPropertyContentTypeDeserializer(type, member)) != null) {
                type = type.withContentTypeHandler(contentTypeDeser);
            }
        }
        if ((valueTypeDeser = ctxt.findPropertyTypeDeserializer(type, member)) != null) {
            type = type.withTypeHandler(valueTypeDeser);
        }
        type = intr.refineDeserializationType(ctxt.getConfig(), member, type);
        return type;
    }

    protected EnumResolver constructEnumResolver(DeserializationContext ctxt, Class<?> enumClass, BeanDescription.Supplier beanDescRef) {
        AnnotatedMember jvAcc = beanDescRef.get().findJsonValueAccessor();
        if (jvAcc != null) {
            if (ctxt.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess(jvAcc.getMember(), ctxt.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
            }
            return EnumResolver.constructUsingMethod(ctxt.getConfig(), beanDescRef.getClassInfo(), jvAcc);
        }
        return EnumResolver.constructFor(ctxt.getConfig(), beanDescRef.getClassInfo());
    }

    protected EnumResolver constructEnumNamingStrategyResolver(DeserializationConfig config, AnnotatedClass enumClass) {
        Object namingDef = config.getAnnotationIntrospector().findEnumNamingStrategy(config, enumClass);
        EnumNamingStrategy enumNamingStrategy = EnumNamingStrategyFactory.createEnumNamingStrategyInstance(namingDef, config.canOverrideAccessModifiers(), config.getEnumNamingStrategy());
        return enumNamingStrategy == null ? null : EnumResolver.constructUsingEnumNamingStrategy(config, enumClass, enumNamingStrategy);
    }

    protected boolean _hasCreatorAnnotation(MapperConfig<?> config, Annotated ann) {
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        if (intr != null) {
            JsonCreator.Mode mode = intr.findCreatorAnnotation(config, ann);
            return mode != null && mode != JsonCreator.Mode.DISABLED;
        }
        return false;
    }

    protected static class ContainerDefaultMappings {
        static final HashMap<String, Class<? extends Collection>> _collectionFallbacks;
        static final HashMap<String, Class<? extends Map>> _mapFallbacks;

        protected ContainerDefaultMappings() {
        }

        public static Class<?> findCollectionFallback(JavaType type) {
            return _collectionFallbacks.get(type.getRawClass().getName());
        }

        public static Class<?> findMapFallback(JavaType type) {
            return _mapFallbacks.get(type.getRawClass().getName());
        }

        static {
            HashMap<String, Class<LinkedHashMap>> fallbacks = new HashMap<String, Class<LinkedHashMap>>();
            Class<ArrayList> DEFAULT_LIST = ArrayList.class;
            Class<HashSet> DEFAULT_SET = HashSet.class;
            fallbacks.put(Collection.class.getName(), DEFAULT_LIST);
            fallbacks.put(List.class.getName(), DEFAULT_LIST);
            fallbacks.put(Set.class.getName(), DEFAULT_SET);
            fallbacks.put(SortedSet.class.getName(), TreeSet.class);
            fallbacks.put(Queue.class.getName(), LinkedList.class);
            fallbacks.put(AbstractList.class.getName(), DEFAULT_LIST);
            fallbacks.put(AbstractSet.class.getName(), DEFAULT_SET);
            fallbacks.put(Deque.class.getName(), LinkedList.class);
            fallbacks.put(NavigableSet.class.getName(), TreeSet.class);
            fallbacks.put("java.util.SequencedCollection", DEFAULT_LIST);
            fallbacks.put("java.util.SequencedSet", LinkedHashSet.class);
            _collectionFallbacks = fallbacks;
            fallbacks = new HashMap();
            Class<LinkedHashMap> DEFAULT_MAP = LinkedHashMap.class;
            fallbacks.put(Map.class.getName(), DEFAULT_MAP);
            fallbacks.put(AbstractMap.class.getName(), DEFAULT_MAP);
            fallbacks.put(ConcurrentMap.class.getName(), ConcurrentHashMap.class);
            fallbacks.put(SortedMap.class.getName(), TreeMap.class);
            fallbacks.put(NavigableMap.class.getName(), TreeMap.class);
            fallbacks.put(ConcurrentNavigableMap.class.getName(), ConcurrentSkipListMap.class);
            fallbacks.put("java.util.SequencedMap", LinkedHashMap.class);
            _mapFallbacks = fallbacks;
        }
    }
}

