/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.introspect;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import java.io.Serializable;
import tools.jackson.databind.introspect.AnnotatedField;
import tools.jackson.databind.introspect.AnnotatedMember;
import tools.jackson.databind.introspect.AnnotatedMethod;

public class VisibilityChecker
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final VisibilityChecker DEFAULT = new VisibilityChecker(JsonAutoDetect.Visibility.PUBLIC_ONLY, JsonAutoDetect.Visibility.PUBLIC_ONLY, JsonAutoDetect.Visibility.PUBLIC_ONLY, JsonAutoDetect.Visibility.ANY, JsonAutoDetect.Visibility.PUBLIC_ONLY, JsonAutoDetect.Visibility.NON_PRIVATE);
    protected static final VisibilityChecker ALL_PUBLIC = new VisibilityChecker(JsonAutoDetect.Visibility.PUBLIC_ONLY, JsonAutoDetect.Visibility.PUBLIC_ONLY, JsonAutoDetect.Visibility.PUBLIC_ONLY, JsonAutoDetect.Visibility.PUBLIC_ONLY, JsonAutoDetect.Visibility.PUBLIC_ONLY, JsonAutoDetect.Visibility.PUBLIC_ONLY);
    protected static final VisibilityChecker ALL_PUBLIC_EXCEPT_CREATORS = new VisibilityChecker(JsonAutoDetect.Visibility.PUBLIC_ONLY, JsonAutoDetect.Visibility.PUBLIC_ONLY, JsonAutoDetect.Visibility.PUBLIC_ONLY, JsonAutoDetect.Visibility.PUBLIC_ONLY, JsonAutoDetect.Visibility.ANY, JsonAutoDetect.Visibility.ANY);
    protected final JsonAutoDetect.Visibility _fieldMinLevel;
    protected final JsonAutoDetect.Visibility _getterMinLevel;
    protected final JsonAutoDetect.Visibility _isGetterMinLevel;
    protected final JsonAutoDetect.Visibility _setterMinLevel;
    protected final JsonAutoDetect.Visibility _creatorMinLevel;
    protected final JsonAutoDetect.Visibility _scalarConstructorMinLevel;

    public VisibilityChecker(JsonAutoDetect ann) {
        this._fieldMinLevel = ann.fieldVisibility();
        this._getterMinLevel = ann.getterVisibility();
        this._isGetterMinLevel = ann.isGetterVisibility();
        this._setterMinLevel = ann.setterVisibility();
        this._creatorMinLevel = ann.creatorVisibility();
        this._scalarConstructorMinLevel = ann.scalarConstructorVisibility();
    }

    public VisibilityChecker(JsonAutoDetect.Visibility field, JsonAutoDetect.Visibility getter, JsonAutoDetect.Visibility isGetter, JsonAutoDetect.Visibility setter, JsonAutoDetect.Visibility creator, JsonAutoDetect.Visibility scalarConstructor) {
        this._getterMinLevel = getter;
        this._isGetterMinLevel = isGetter;
        this._setterMinLevel = setter;
        this._creatorMinLevel = creator;
        this._fieldMinLevel = field;
        this._scalarConstructorMinLevel = scalarConstructor;
    }

    public VisibilityChecker(JsonAutoDetect.Visibility v) {
        if (v == JsonAutoDetect.Visibility.DEFAULT) {
            this._getterMinLevel = VisibilityChecker.DEFAULT._getterMinLevel;
            this._isGetterMinLevel = VisibilityChecker.DEFAULT._isGetterMinLevel;
            this._setterMinLevel = VisibilityChecker.DEFAULT._setterMinLevel;
            this._creatorMinLevel = VisibilityChecker.DEFAULT._creatorMinLevel;
            this._fieldMinLevel = VisibilityChecker.DEFAULT._fieldMinLevel;
            this._scalarConstructorMinLevel = VisibilityChecker.DEFAULT._scalarConstructorMinLevel;
        } else {
            this._getterMinLevel = v;
            this._isGetterMinLevel = v;
            this._setterMinLevel = v;
            this._creatorMinLevel = v;
            this._fieldMinLevel = v;
            this._scalarConstructorMinLevel = v;
        }
    }

    public static VisibilityChecker construct(JsonAutoDetect.Value vis) {
        return DEFAULT.withOverrides(vis);
    }

    public static VisibilityChecker defaultInstance() {
        return DEFAULT;
    }

    public static VisibilityChecker allPublicInstance() {
        return ALL_PUBLIC;
    }

    public static VisibilityChecker allPublicExceptCreatorsInstance() {
        return ALL_PUBLIC_EXCEPT_CREATORS;
    }

    public VisibilityChecker withOverrides(JsonAutoDetect.Value vis) {
        if (vis == null) {
            return this;
        }
        return this._with(this._defaultOrOverride(this._fieldMinLevel, vis.getFieldVisibility()), this._defaultOrOverride(this._getterMinLevel, vis.getGetterVisibility()), this._defaultOrOverride(this._isGetterMinLevel, vis.getIsGetterVisibility()), this._defaultOrOverride(this._setterMinLevel, vis.getSetterVisibility()), this._defaultOrOverride(this._creatorMinLevel, vis.getCreatorVisibility()), this._defaultOrOverride(this._scalarConstructorMinLevel, vis.getScalarConstructorVisibility()));
    }

    private JsonAutoDetect.Visibility _defaultOrOverride(JsonAutoDetect.Visibility defaults, JsonAutoDetect.Visibility override) {
        if (override == JsonAutoDetect.Visibility.DEFAULT) {
            return defaults;
        }
        return override;
    }

    public VisibilityChecker with(JsonAutoDetect.Visibility v) {
        if (v == JsonAutoDetect.Visibility.DEFAULT) {
            return DEFAULT;
        }
        return new VisibilityChecker(v);
    }

    public VisibilityChecker withVisibility(PropertyAccessor method, JsonAutoDetect.Visibility v) {
        switch (method) {
            case GETTER: {
                return this.withGetterVisibility(v);
            }
            case SETTER: {
                return this.withSetterVisibility(v);
            }
            case CREATOR: {
                return this.withCreatorVisibility(v);
            }
            case FIELD: {
                return this.withFieldVisibility(v);
            }
            case IS_GETTER: {
                return this.withIsGetterVisibility(v);
            }
            case ALL: {
                return this.with(v);
            }
        }
        return this;
    }

    public VisibilityChecker withFieldVisibility(JsonAutoDetect.Visibility v) {
        if (v == JsonAutoDetect.Visibility.DEFAULT) {
            v = VisibilityChecker.DEFAULT._fieldMinLevel;
        }
        if (this._fieldMinLevel == v) {
            return this;
        }
        return new VisibilityChecker(v, this._getterMinLevel, this._isGetterMinLevel, this._setterMinLevel, this._creatorMinLevel, this._scalarConstructorMinLevel);
    }

    public VisibilityChecker withGetterVisibility(JsonAutoDetect.Visibility v) {
        if (v == JsonAutoDetect.Visibility.DEFAULT) {
            v = VisibilityChecker.DEFAULT._getterMinLevel;
        }
        if (this._getterMinLevel == v) {
            return this;
        }
        return new VisibilityChecker(this._fieldMinLevel, v, this._isGetterMinLevel, this._setterMinLevel, this._creatorMinLevel, this._scalarConstructorMinLevel);
    }

    public VisibilityChecker withIsGetterVisibility(JsonAutoDetect.Visibility v) {
        if (v == JsonAutoDetect.Visibility.DEFAULT) {
            v = VisibilityChecker.DEFAULT._isGetterMinLevel;
        }
        if (this._isGetterMinLevel == v) {
            return this;
        }
        return new VisibilityChecker(this._fieldMinLevel, this._getterMinLevel, v, this._setterMinLevel, this._creatorMinLevel, this._scalarConstructorMinLevel);
    }

    public VisibilityChecker withSetterVisibility(JsonAutoDetect.Visibility v) {
        if (v == JsonAutoDetect.Visibility.DEFAULT) {
            v = VisibilityChecker.DEFAULT._setterMinLevel;
        }
        if (this._setterMinLevel == v) {
            return this;
        }
        return new VisibilityChecker(this._fieldMinLevel, this._getterMinLevel, this._isGetterMinLevel, v, this._creatorMinLevel, this._scalarConstructorMinLevel);
    }

    public VisibilityChecker withCreatorVisibility(JsonAutoDetect.Visibility v) {
        if (v == JsonAutoDetect.Visibility.DEFAULT) {
            v = VisibilityChecker.DEFAULT._creatorMinLevel;
        }
        if (this._creatorMinLevel == v) {
            return this;
        }
        return new VisibilityChecker(this._fieldMinLevel, this._getterMinLevel, this._isGetterMinLevel, this._setterMinLevel, v, this._scalarConstructorMinLevel);
    }

    public VisibilityChecker withScalarConstructorVisibility(JsonAutoDetect.Visibility v) {
        if (v == JsonAutoDetect.Visibility.DEFAULT) {
            v = VisibilityChecker.DEFAULT._scalarConstructorMinLevel;
        }
        if (this._scalarConstructorMinLevel == v) {
            return this;
        }
        return new VisibilityChecker(this._fieldMinLevel, this._getterMinLevel, this._isGetterMinLevel, this._setterMinLevel, this._creatorMinLevel, v);
    }

    protected VisibilityChecker _with(JsonAutoDetect.Visibility f, JsonAutoDetect.Visibility g, JsonAutoDetect.Visibility isG, JsonAutoDetect.Visibility s, JsonAutoDetect.Visibility cr, JsonAutoDetect.Visibility scalarCr) {
        if (f == this._fieldMinLevel && g == this._getterMinLevel && isG == this._isGetterMinLevel && s == this._setterMinLevel && cr == this._creatorMinLevel && scalarCr == this._scalarConstructorMinLevel) {
            return this;
        }
        return new VisibilityChecker(f, g, isG, s, cr, scalarCr);
    }

    public boolean isFieldVisible(AnnotatedField f) {
        return this._fieldMinLevel.isVisible(f.getAnnotated());
    }

    public boolean isGetterVisible(AnnotatedMethod m) {
        return this._getterMinLevel.isVisible(m.getAnnotated());
    }

    public boolean isIsGetterVisible(AnnotatedMethod m) {
        return this._isGetterMinLevel.isVisible(m.getAnnotated());
    }

    public boolean isSetterVisible(AnnotatedMethod m) {
        return this._setterMinLevel.isVisible(m.getAnnotated());
    }

    public boolean isCreatorVisible(AnnotatedMember m) {
        return this._creatorMinLevel.isVisible(m.getMember());
    }

    public boolean isScalarConstructorVisible(AnnotatedMember m) {
        return this._scalarConstructorMinLevel.isVisible(m.getMember());
    }

    public String toString() {
        return String.format("[Visibility: field=%s,getter=%s,isGetter=%s,setter=%s,creator=%s,scalarConstructor=%s]", new Object[]{this._fieldMinLevel, this._getterMinLevel, this._isGetterMinLevel, this._setterMinLevel, this._creatorMinLevel, this._scalarConstructorMinLevel});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VisibilityChecker)) {
            return false;
        }
        VisibilityChecker other = (VisibilityChecker)o;
        return this._fieldMinLevel == other._fieldMinLevel && this._getterMinLevel == other._getterMinLevel && this._isGetterMinLevel == other._isGetterMinLevel && this._setterMinLevel == other._setterMinLevel && this._creatorMinLevel == other._creatorMinLevel && this._scalarConstructorMinLevel == other._scalarConstructorMinLevel;
    }
}

