/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.json;

import java.io.Serializable;
import tools.jackson.core.Version;
import tools.jackson.core.json.JsonFactory;
import tools.jackson.core.json.JsonReadFeature;
import tools.jackson.core.json.JsonWriteFeature;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.cfg.MapperBuilder;
import tools.jackson.databind.cfg.MapperBuilderState;
import tools.jackson.databind.cfg.PackageVersion;

public class JsonMapper
extends ObjectMapper {
    private static final long serialVersionUID = 1L;

    public JsonMapper() {
        this(new JsonFactory());
    }

    public JsonMapper(JsonFactory f) {
        this(new Builder(f));
    }

    public JsonMapper(Builder b) {
        super(b);
    }

    public static Builder builder() {
        return new Builder(new JsonFactory());
    }

    public static Builder builder(JsonFactory streamFactory) {
        return new Builder(streamFactory);
    }

    public static Builder builderWithJackson2Defaults() {
        return (Builder)JsonMapper.builder(JsonFactory.builderWithJackson2Defaults().build()).configureForJackson2();
    }

    public Builder rebuild() {
        return new Builder((Builder.StateImpl)this._savedBuilderState);
    }

    public static JsonMapper shared() {
        return SharedWrapper.wrapped();
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public JsonFactory tokenStreamFactory() {
        return (JsonFactory)this._streamFactory;
    }

    public boolean isEnabled(JsonReadFeature f) {
        return this._deserializationConfig.hasFormatFeature(f);
    }

    public boolean isEnabled(JsonWriteFeature f) {
        return this._serializationConfig.hasFormatFeature(f);
    }

    public static class Builder
    extends MapperBuilder<JsonMapper, Builder> {
        public Builder(JsonFactory f) {
            super(f);
        }

        public Builder(StateImpl state) {
            super(state);
        }

        @Override
        public JsonMapper build() {
            return new JsonMapper(this);
        }

        @Override
        protected MapperBuilderState _saveState() {
            return new StateImpl(this);
        }

        public Builder enable(JsonReadFeature ... features) {
            for (JsonReadFeature f : features) {
                this._formatReadFeatures |= f.getMask();
            }
            return this;
        }

        public Builder disable(JsonReadFeature ... features) {
            for (JsonReadFeature f : features) {
                this._formatReadFeatures &= ~f.getMask();
            }
            return this;
        }

        public Builder configure(JsonReadFeature feature, boolean state) {
            this._formatReadFeatures = state ? (this._formatReadFeatures |= feature.getMask()) : (this._formatReadFeatures &= ~feature.getMask());
            return this;
        }

        public Builder enable(JsonWriteFeature ... features) {
            for (JsonWriteFeature f : features) {
                this._formatWriteFeatures |= f.getMask();
            }
            return this;
        }

        public Builder disable(JsonWriteFeature ... features) {
            for (JsonWriteFeature f : features) {
                this._formatWriteFeatures &= ~f.getMask();
            }
            return this;
        }

        public Builder configure(JsonWriteFeature feature, boolean state) {
            this._formatWriteFeatures = state ? (this._formatWriteFeatures |= feature.getMask()) : (this._formatWriteFeatures &= ~feature.getMask());
            return this;
        }

        protected static class StateImpl
        extends MapperBuilderState
        implements Serializable {
            private static final long serialVersionUID = 3L;

            public StateImpl(Builder src) {
                super(src);
            }

            @Override
            protected Object readResolve() {
                return new Builder(this).build();
            }
        }
    }

    private static final class SharedWrapper {
        private static final JsonMapper MAPPER = JsonMapper.builder().build();

        private SharedWrapper() {
        }

        public static JsonMapper wrapped() {
            return MAPPER;
        }
    }
}

