/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.node;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Optional;
import java.util.OptionalDouble;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.core.io.NumberOutput;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.node.NumericFPNode;

public class FloatNode
extends NumericFPNode {
    private static final long serialVersionUID = 3L;
    protected final float _value;

    public FloatNode(float v) {
        this._value = v;
    }

    public static FloatNode valueOf(float v) {
        return new FloatNode(v);
    }

    @Override
    public JsonParser.NumberType numberType() {
        return JsonParser.NumberType.FLOAT;
    }

    @Override
    public boolean isFloat() {
        return true;
    }

    @Override
    public boolean isNaN() {
        return NumberOutput.notFinite(this._value);
    }

    @Override
    protected String _asString() {
        return String.valueOf(this._value);
    }

    @Override
    public Number numberValue() {
        return Float.valueOf(this._value);
    }

    @Override
    public float floatValue() {
        return this._value;
    }

    @Override
    public float floatValue(float defaultValue) {
        return this._value;
    }

    @Override
    public Optional<Float> floatValueOpt() {
        return Optional.of(Float.valueOf(this._value));
    }

    @Override
    public float asFloat() {
        return this._value;
    }

    @Override
    public float asFloat(float defaultValue) {
        return this._value;
    }

    @Override
    public Optional<Float> asFloatOpt() {
        return Optional.of(Float.valueOf(this._value));
    }

    @Override
    public double doubleValue() {
        return this._value;
    }

    @Override
    public double doubleValue(double defaultValue) {
        return this._value;
    }

    @Override
    public OptionalDouble doubleValueOpt() {
        return OptionalDouble.of(this._value);
    }

    @Override
    public double asDouble() {
        return this._value;
    }

    @Override
    public double asDouble(double defaultValue) {
        return this._value;
    }

    @Override
    public OptionalDouble asDoubleOpt() {
        return OptionalDouble.of(this._value);
    }

    @Override
    public short _asShortValueUnchecked() {
        return (short)this._value;
    }

    @Override
    public int _asIntValueUnchecked() {
        return (int)this._value;
    }

    @Override
    public long _asLongValueUnchecked() {
        return (long)this._value;
    }

    @Override
    protected BigInteger _asBigIntegerValueUnchecked() {
        return BigDecimal.valueOf(this._value).toBigInteger();
    }

    @Override
    protected BigDecimal _asDecimalValueUnchecked() {
        return BigDecimal.valueOf(this._value);
    }

    @Override
    public boolean hasFractionalPart() {
        return this._value != (float)Math.round(this._value);
    }

    @Override
    public boolean inShortRange() {
        return !this.isNaN() && this._value >= -32768.0f && this._value <= 32767.0f;
    }

    @Override
    public boolean inIntRange() {
        return !this.isNaN() && this._value >= -2.1474836E9f && this._value <= 2.1474836E9f;
    }

    @Override
    public boolean inLongRange() {
        return !this.isNaN() && this._value >= -9.223372E18f && this._value <= 9.223372E18f;
    }

    @Override
    public final void serialize(JsonGenerator g, SerializationContext provider) throws JacksonException {
        g.writeNumber(this._value);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof FloatNode) {
            float otherValue = ((FloatNode)o)._value;
            return Float.compare(this._value, otherValue) == 0;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Float.floatToIntBits(this._value);
    }
}

