/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.node;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import tools.jackson.core.Base64Variant;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.core.StreamReadCapability;
import tools.jackson.core.TokenStreamContext;
import tools.jackson.core.TokenStreamLocation;
import tools.jackson.core.Version;
import tools.jackson.core.base.ParserMinimalBase;
import tools.jackson.core.exc.InputCoercionException;
import tools.jackson.core.util.JacksonFeatureSet;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.cfg.PackageVersion;
import tools.jackson.databind.node.BinaryNode;
import tools.jackson.databind.node.NodeCursor;
import tools.jackson.databind.node.NumericNode;
import tools.jackson.databind.node.POJONode;
import tools.jackson.databind.node.StringNode;

public class TreeTraversingParser
extends ParserMinimalBase {
    protected final JsonNode _source;
    protected NodeCursor _nodeCursor;
    protected boolean _closed;

    public TreeTraversingParser(JsonNode n) {
        this(n, ObjectReadContext.empty());
    }

    public TreeTraversingParser(JsonNode n, ObjectReadContext readContext) {
        super(readContext);
        this._source = n;
        this._nodeCursor = new NodeCursor.RootCursor(n, null);
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public JacksonFeatureSet<StreamReadCapability> streamReadCapabilities() {
        return DEFAULT_READ_CAPABILITIES;
    }

    @Override
    public JsonNode streamReadInputSource() {
        return this._source;
    }

    @Override
    public void close() {
        if (!this._closed) {
            this._closed = true;
            this._nodeCursor = null;
            this._updateTokenToNull();
        }
    }

    @Override
    protected void _closeInput() throws IOException {
    }

    @Override
    protected void _releaseBuffers() {
    }

    @Override
    public JsonToken nextToken() {
        this._nullSafeUpdateToken(this._nodeCursor.nextToken());
        if (this._currToken == null) {
            this._closed = true;
            return null;
        }
        switch (this._currToken) {
            case START_OBJECT: {
                this._nodeCursor = this._nodeCursor.startObject();
                break;
            }
            case START_ARRAY: {
                this._nodeCursor = this._nodeCursor.startArray();
                break;
            }
            case END_OBJECT: 
            case END_ARRAY: {
                this._nodeCursor = this._nodeCursor.getParent();
            }
        }
        return this._currToken;
    }

    @Override
    public JsonParser skipChildren() {
        if (this._currToken == JsonToken.START_OBJECT) {
            this._nodeCursor = this._nodeCursor.getParent();
            this._updateToken(JsonToken.END_OBJECT);
        } else if (this._currToken == JsonToken.START_ARRAY) {
            this._nodeCursor = this._nodeCursor.getParent();
            this._updateToken(JsonToken.END_ARRAY);
        }
        return this;
    }

    @Override
    public boolean isClosed() {
        return this._closed;
    }

    @Override
    public String currentName() {
        NodeCursor crsr = this._nodeCursor;
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            crsr = crsr.getParent();
        }
        return crsr == null ? null : crsr.currentName();
    }

    @Override
    public TokenStreamContext streamReadContext() {
        return this._nodeCursor;
    }

    @Override
    public void assignCurrentValue(Object v) {
        this._nodeCursor.assignCurrentValue(v);
    }

    @Override
    public Object currentValue() {
        return this._nodeCursor.currentValue();
    }

    @Override
    public TokenStreamLocation currentTokenLocation() {
        return TokenStreamLocation.NA;
    }

    @Override
    public TokenStreamLocation currentLocation() {
        return TokenStreamLocation.NA;
    }

    @Override
    public String getString() {
        if (this._currToken == null) {
            return null;
        }
        switch (this._currToken) {
            case PROPERTY_NAME: {
                return this._nodeCursor.currentName();
            }
            case VALUE_STRING: {
                return this.currentNode().stringValue();
            }
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                return String.valueOf(this.currentNode().numberValue());
            }
            case VALUE_EMBEDDED_OBJECT: {
                JsonNode n = this.currentNode();
                if (n == null || !n.isBinary()) break;
                return n.asString();
            }
        }
        return this._currToken.asString();
    }

    @Override
    public char[] getStringCharacters() {
        return this.getString().toCharArray();
    }

    @Override
    public int getStringLength() {
        return this.getString().length();
    }

    @Override
    public int getStringOffset() {
        return 0;
    }

    @Override
    public boolean hasStringCharacters() {
        return false;
    }

    @Override
    public JsonParser.NumberType getNumberType() {
        JsonNode n = this.currentNode();
        if (n instanceof NumericNode) {
            return n.numberType();
        }
        return null;
    }

    @Override
    public JsonParser.NumberTypeFP getNumberTypeFP() {
        JsonParser.NumberType nt = this.getNumberType();
        if (nt == JsonParser.NumberType.BIG_DECIMAL) {
            return JsonParser.NumberTypeFP.BIG_DECIMAL;
        }
        if (nt == JsonParser.NumberType.DOUBLE) {
            return JsonParser.NumberTypeFP.DOUBLE64;
        }
        if (nt == JsonParser.NumberType.FLOAT) {
            return JsonParser.NumberTypeFP.FLOAT32;
        }
        return JsonParser.NumberTypeFP.UNKNOWN;
    }

    @Override
    public BigInteger getBigIntegerValue() throws InputCoercionException {
        return this.currentNumericNode(4).bigIntegerValue();
    }

    @Override
    public BigDecimal getDecimalValue() throws InputCoercionException {
        return this.currentNumericNode(16).decimalValue();
    }

    @Override
    public double getDoubleValue() throws InputCoercionException {
        return this.currentNumericNode(8).doubleValue();
    }

    @Override
    public float getFloatValue() throws InputCoercionException {
        return (float)this.currentNumericNode(32).doubleValue();
    }

    @Override
    public short getShortValue() throws InputCoercionException {
        NumericNode node = (NumericNode)this.currentNumericNode(1);
        if (!node.canConvertToShort()) {
            String desc = this._longIntegerDesc(node.asString());
            if (!node.canConvertToExactIntegral()) {
                throw this._constructInputCoercion(String.format("Numeric value (%s) of `%s` has fractional part; cannot convert to `short`", desc, node.getClass().getSimpleName()), node.asToken(), Integer.TYPE);
            }
            this._reportOverflowShort(desc, this.currentToken());
        }
        return node.shortValue();
    }

    @Override
    public int getIntValue() throws InputCoercionException {
        NumericNode node = (NumericNode)this.currentNumericNode(1);
        if (!node.canConvertToInt()) {
            if (!node.canConvertToExactIntegral()) {
                throw this._constructInputCoercion(String.format("Numeric value (%s) of `%s` has fractional part; cannot convert to `int`", this._longIntegerDesc(node.asString()), node.getClass().getSimpleName()), node.asToken(), Integer.TYPE);
            }
            this._reportOverflowInt();
        }
        return node.intValue();
    }

    @Override
    public int getValueAsInt() {
        NumericNode node = (NumericNode)this.currentNumericNode(1);
        if (node.inIntRange()) {
            return node._asIntValueUnchecked();
        }
        return this.getIntValue();
    }

    @Override
    public int getValueAsInt(int defaultValue) {
        NumericNode node = (NumericNode)this.currentNumericNode(1);
        if (node.inIntRange()) {
            return node._asIntValueUnchecked();
        }
        return defaultValue;
    }

    @Override
    public long getLongValue() throws InputCoercionException {
        NumericNode node = (NumericNode)this.currentNumericNode(2);
        if (!node.canConvertToLong()) {
            if (!node.canConvertToExactIntegral()) {
                throw this._constructInputCoercion(String.format("Numeric value (%s) of `%s` has fractional part; cannot convert to `long`", this._longIntegerDesc(node.asString()), node.getClass().getSimpleName()), node.asToken(), Long.TYPE);
            }
            this._reportOverflowLong();
        }
        return node.longValue();
    }

    @Override
    public long getValueAsLong() {
        NumericNode node = (NumericNode)this.currentNumericNode(1);
        if (node.inLongRange()) {
            return node._asLongValueUnchecked();
        }
        return this.getLongValue();
    }

    @Override
    public long getValueAsLong(long defaultValue) {
        NumericNode node = (NumericNode)this.currentNumericNode(1);
        if (node.inLongRange()) {
            return node._asLongValueUnchecked();
        }
        return defaultValue;
    }

    @Override
    public Number getNumberValue() throws InputCoercionException {
        return this.currentNumericNode(-1).numberValue();
    }

    @Override
    public Object getEmbeddedObject() {
        JsonNode n;
        if (!this._closed && (n = this.currentNode()) != null) {
            if (n.isPojo()) {
                return ((POJONode)n).getPojo();
            }
            if (n.isBinary()) {
                return ((BinaryNode)n).binaryValue();
            }
        }
        return null;
    }

    @Override
    public boolean isNaN() {
        JsonNode n;
        if (!this._closed && (n = this.currentNode()) instanceof NumericNode) {
            return ((NumericNode)n).isNaN();
        }
        return false;
    }

    @Override
    public byte[] getBinaryValue(Base64Variant b64variant) throws JacksonException {
        JsonNode n = this.currentNode();
        if (n != null) {
            if (n instanceof StringNode) {
                return ((StringNode)n).getBinaryValue(b64variant);
            }
            return n.binaryValue();
        }
        return null;
    }

    @Override
    public int readBinaryValue(Base64Variant b64variant, OutputStream out) throws JacksonException {
        byte[] data = this.getBinaryValue(b64variant);
        if (data != null) {
            try {
                out.write(data, 0, data.length);
            }
            catch (IOException e) {
                throw this._wrapIOFailure(e);
            }
            return data.length;
        }
        return 0;
    }

    protected JsonNode currentNode() {
        if (this._closed || this._nodeCursor == null) {
            return null;
        }
        return this._nodeCursor.currentNode();
    }

    protected JsonNode currentNumericNode(int targetNumType) {
        JsonNode n = this.currentNode();
        if (n == null || !n.isNumber()) {
            JsonToken t = n == null ? null : n.asToken();
            throw this._constructNotNumericType(t, -1);
        }
        return n;
    }

    @Override
    protected void _handleEOF() {
        this._throwInternal();
    }
}

