/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser;

import com.fasterxml.jackson.annotation.JsonInclude;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.BeanDescription;
import tools.jackson.databind.DatabindException;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.MapperFeature;
import tools.jackson.databind.SerializationConfig;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.annotation.JsonSerialize;
import tools.jackson.databind.introspect.Annotated;
import tools.jackson.databind.introspect.AnnotatedMember;
import tools.jackson.databind.introspect.BeanPropertyDefinition;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.ser.BeanPropertyWriter;
import tools.jackson.databind.util.Annotations;
import tools.jackson.databind.util.ArrayBuilders;
import tools.jackson.databind.util.BeanUtil;
import tools.jackson.databind.util.ClassUtil;
import tools.jackson.databind.util.NameTransformer;

public class PropertyBuilder {
    private static final Object NO_DEFAULT_MARKER = Boolean.FALSE;
    protected final SerializationConfig _config;
    protected final BeanDescription _beanDesc;
    protected final AnnotationIntrospector _annotationIntrospector;
    protected Object _defaultBean;
    protected final JsonInclude.Value _defaultInclusion;
    protected final boolean _useRealPropertyDefaults;

    public PropertyBuilder(SerializationConfig config, BeanDescription beanDesc) {
        this._config = config;
        this._beanDesc = beanDesc;
        JsonInclude.Value inclPerType = JsonInclude.Value.merge(beanDesc.findPropertyInclusion(JsonInclude.Value.empty()), config.getDefaultPropertyInclusion(beanDesc.getBeanClass(), JsonInclude.Value.empty()));
        this._defaultInclusion = JsonInclude.Value.merge(config.getDefaultPropertyInclusion(), inclPerType);
        this._useRealPropertyDefaults = inclPerType.getValueInclusion() == JsonInclude.Include.NON_DEFAULT;
        this._annotationIntrospector = this._config.getAnnotationIntrospector();
    }

    public Annotations getClassAnnotations() {
        return this._beanDesc.getClassAnnotations();
    }

    protected BeanPropertyWriter buildWriter(SerializationContext ctxt, BeanPropertyDefinition propDef, JavaType declaredType, ValueSerializer<?> ser, TypeSerializer typeSer, TypeSerializer contentTypeSer, AnnotatedMember am, boolean defaultUseStaticTyping) {
        NameTransformer unwrapper;
        Class<?>[] views;
        JavaType serializationType;
        try {
            serializationType = this.findSerializationType(am, defaultUseStaticTyping, declaredType);
        }
        catch (DatabindException e) {
            if (propDef == null) {
                return (BeanPropertyWriter)ctxt.reportBadDefinition(declaredType, ClassUtil.exceptionMessage(e));
            }
            return (BeanPropertyWriter)ctxt.reportBadPropertyDefinition(this._beanDesc, propDef, ClassUtil.exceptionMessage(e), new Object[0]);
        }
        if (contentTypeSer != null) {
            JavaType ct;
            if (serializationType == null) {
                serializationType = declaredType;
            }
            if ((ct = serializationType.getContentType()) == null) {
                ctxt.reportBadPropertyDefinition(this._beanDesc, propDef, "serialization type " + String.valueOf(serializationType) + " has no content", new Object[0]);
            }
            serializationType = serializationType.withContentTypeHandler(contentTypeSer);
            ct = serializationType.getContentType();
        }
        Object valueToSuppress = null;
        boolean suppressNulls = false;
        JavaType actualType = serializationType == null ? declaredType : serializationType;
        AnnotatedMember accessor = propDef.getAccessor();
        if (accessor == null) {
            return (BeanPropertyWriter)ctxt.reportBadPropertyDefinition(this._beanDesc, propDef, "could not determine property type", new Object[0]);
        }
        Class<?> rawPropertyType = accessor.getRawType();
        JsonInclude.Value inclV = this._config.getDefaultInclusion(actualType.getRawClass(), rawPropertyType, this._defaultInclusion);
        JsonInclude.Include inclusion = (inclV = inclV.withOverrides(propDef.findInclusion())).getValueInclusion();
        if (inclusion == JsonInclude.Include.USE_DEFAULTS) {
            inclusion = JsonInclude.Include.ALWAYS;
        }
        switch (inclusion) {
            case NON_DEFAULT: {
                Object defaultBean;
                if (this._useRealPropertyDefaults && (defaultBean = this.getDefaultBean()) != null) {
                    if (ctxt.isEnabled(MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS)) {
                        am.fixAccess(this._config.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
                    }
                    try {
                        valueToSuppress = am.getValue(defaultBean);
                    }
                    catch (Exception e) {
                        this._throwWrapped(e, propDef.getName(), defaultBean);
                    }
                } else {
                    valueToSuppress = BeanUtil.getDefaultValue(actualType);
                    suppressNulls = true;
                }
                if (valueToSuppress == null) {
                    suppressNulls = true;
                    if (this._useRealPropertyDefaults) break;
                    valueToSuppress = BeanPropertyWriter.MARKER_FOR_EMPTY;
                    break;
                }
                if (!valueToSuppress.getClass().isArray()) break;
                valueToSuppress = ArrayBuilders.getArrayComparator(valueToSuppress);
                break;
            }
            case NON_ABSENT: {
                suppressNulls = true;
                if (!actualType.isReferenceType()) break;
                valueToSuppress = BeanPropertyWriter.MARKER_FOR_EMPTY;
                break;
            }
            case NON_EMPTY: {
                suppressNulls = true;
                valueToSuppress = BeanPropertyWriter.MARKER_FOR_EMPTY;
                break;
            }
            case CUSTOM: {
                valueToSuppress = ctxt.includeFilterInstance(propDef, inclV.getValueFilter());
                break;
            }
            case NON_NULL: {
                suppressNulls = true;
            }
            default: {
                SerializationFeature emptyJsonArrays = SerializationFeature.WRITE_EMPTY_JSON_ARRAYS;
                if (!actualType.isContainerType() || this._config.isEnabled(emptyJsonArrays)) break;
                valueToSuppress = BeanPropertyWriter.MARKER_FOR_EMPTY;
            }
        }
        if ((views = propDef.findViews()) == null) {
            views = this._beanDesc.findDefaultViews();
        }
        BeanPropertyWriter bpw = this._constructPropertyWriter(propDef, am, this._beanDesc.getClassAnnotations(), declaredType, ser, typeSer, serializationType, suppressNulls, valueToSuppress, views);
        Object serDef = this._annotationIntrospector.findNullSerializer(this._config, am);
        if (serDef != null) {
            bpw.assignNullSerializer(ctxt.serializerInstance(am, serDef));
        }
        if ((unwrapper = this._annotationIntrospector.findUnwrappingNameTransformer(this._config, am)) != null) {
            bpw = bpw.unwrappingWriter(unwrapper);
        }
        return bpw;
    }

    protected BeanPropertyWriter _constructPropertyWriter(BeanPropertyDefinition propDef, AnnotatedMember member, Annotations contextAnnotations, JavaType declaredType, ValueSerializer<?> ser, TypeSerializer typeSer, JavaType serType, boolean suppressNulls, Object suppressableValue, Class<?>[] includeInViews) {
        return new BeanPropertyWriter(propDef, member, contextAnnotations, declaredType, ser, typeSer, serType, suppressNulls, suppressableValue, includeInViews);
    }

    protected JavaType findSerializationType(Annotated a, boolean useStaticTyping, JavaType declaredType) {
        JsonSerialize.Typing typing;
        JavaType secondary = this._annotationIntrospector.refineSerializationType(this._config, a, declaredType);
        if (secondary != declaredType) {
            Class<?> rawDeclared;
            Class<?> serClass = secondary.getRawClass();
            if (!serClass.isAssignableFrom(rawDeclared = declaredType.getRawClass()) && !rawDeclared.isAssignableFrom(serClass)) {
                throw new IllegalArgumentException("Illegal concrete-type annotation for method '" + a.getName() + "': class " + serClass.getName() + " not a super-type of (declared) class " + rawDeclared.getName());
            }
            useStaticTyping = true;
            declaredType = secondary;
        }
        if ((typing = this._annotationIntrospector.findSerializationTyping(this._config, a)) != null && typing != JsonSerialize.Typing.DEFAULT_TYPING) {
            boolean bl = useStaticTyping = typing == JsonSerialize.Typing.STATIC;
        }
        if (useStaticTyping) {
            return declaredType.withStaticTyping();
        }
        return null;
    }

    protected Object getDefaultBean() {
        Object def = this._defaultBean;
        if (def == null) {
            def = this._beanDesc.instantiateBean(this._config.canOverrideAccessModifiers());
            if (def == null) {
                def = NO_DEFAULT_MARKER;
            }
            this._defaultBean = def;
        }
        return def == NO_DEFAULT_MARKER ? null : this._defaultBean;
    }

    protected Object _throwWrapped(Exception e, String propName, Object defaultBean) {
        Throwable t = e;
        while (t.getCause() != null) {
            t = t.getCause();
        }
        ClassUtil.throwIfError(t);
        ClassUtil.throwIfRTE(t);
        throw new IllegalArgumentException("Failed to get property '" + propName + "' of default " + defaultBean.getClass().getName() + " instance");
    }
}

