/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import tools.jackson.core.util.Snapshottable;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.ser.impl.ReadOnlyClassToSerializerMap;
import tools.jackson.databind.util.LookupCache;
import tools.jackson.databind.util.SimpleLookupCache;
import tools.jackson.databind.util.TypeKey;

public final class SerializerCache
implements Snapshottable<SerializerCache>,
Serializable {
    private static final long serialVersionUID = 3L;
    public static final int DEFAULT_MAX_CACHE_SIZE = 4000;
    private final LookupCache<TypeKey, ValueSerializer<Object>> _sharedMap;
    private final transient AtomicReference<ReadOnlyClassToSerializerMap> _readOnlyMap;

    public SerializerCache() {
        this(4000);
    }

    public SerializerCache(int maxCached) {
        int initial = Math.min(64, maxCached >> 2);
        this._sharedMap = new SimpleLookupCache<TypeKey, ValueSerializer<Object>>(initial, maxCached);
        this._readOnlyMap = new AtomicReference();
    }

    public SerializerCache(LookupCache<TypeKey, ValueSerializer<Object>> cache) {
        this._sharedMap = cache;
        this._readOnlyMap = new AtomicReference();
    }

    protected SerializerCache(SimpleLookupCache<TypeKey, ValueSerializer<Object>> shared) {
        this._sharedMap = shared;
        this._readOnlyMap = new AtomicReference();
    }

    protected Object readResolve() {
        return new SerializerCache(this._sharedMap);
    }

    @Override
    public SerializerCache snapshot() {
        return new SerializerCache((LookupCache)this._sharedMap.snapshot());
    }

    public ReadOnlyClassToSerializerMap getReadOnlyLookupMap() {
        ReadOnlyClassToSerializerMap m = this._readOnlyMap.get();
        if (m != null) {
            return m;
        }
        return this._makeReadOnlyLookupMap();
    }

    private final synchronized ReadOnlyClassToSerializerMap _makeReadOnlyLookupMap() {
        ReadOnlyClassToSerializerMap m = this._readOnlyMap.get();
        if (m == null) {
            m = ReadOnlyClassToSerializerMap.from(this, this._sharedMap);
            this._readOnlyMap.set(m);
        }
        return m;
    }

    public int size() {
        return this._sharedMap.size();
    }

    public ValueSerializer<Object> untypedValueSerializer(Class<?> type) {
        return this._sharedMap.get(new TypeKey(type, false));
    }

    public ValueSerializer<Object> untypedValueSerializer(JavaType type) {
        return this._sharedMap.get(new TypeKey(type, false));
    }

    public ValueSerializer<Object> typedValueSerializer(JavaType type) {
        return this._sharedMap.get(new TypeKey(type, true));
    }

    public ValueSerializer<Object> typedValueSerializer(Class<?> cls) {
        return this._sharedMap.get(new TypeKey(cls, true));
    }

    public void addTypedSerializer(JavaType type, ValueSerializer<Object> ser) {
        if (this._sharedMap.put(new TypeKey(type, true), ser) == null) {
            this._readOnlyMap.set(null);
        }
    }

    public void addTypedSerializer(Class<?> cls, ValueSerializer<Object> ser) {
        if (this._sharedMap.put(new TypeKey(cls, true), ser) == null) {
            this._readOnlyMap.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAndResolveNonTypedSerializer(Class<?> type, ValueSerializer<Object> ser, SerializationContext provider) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            if (this._sharedMap.put(new TypeKey(type, false), ser) == null) {
                this._readOnlyMap.set(null);
            }
            ser.resolve(provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAndResolveNonTypedSerializer(JavaType type, ValueSerializer<Object> ser, SerializationContext provider) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            if (this._sharedMap.put(new TypeKey(type, false), ser) == null) {
                this._readOnlyMap.set(null);
            }
            ser.resolve(provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAndResolveNonTypedSerializer(Class<?> rawType, JavaType fullType, ValueSerializer<Object> ser, SerializationContext provider) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            ValueSerializer<Object> ob1 = this._sharedMap.put(new TypeKey(rawType, false), ser);
            ValueSerializer<Object> ob2 = this._sharedMap.put(new TypeKey(fullType, false), ser);
            if (ob1 == null || ob2 == null) {
                this._readOnlyMap.set(null);
            }
            ser.resolve(provider);
        }
    }

    public synchronized void flush() {
        this._sharedMap.clear();
        this._readOnlyMap.set(null);
    }
}

