/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser.jackson;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.UnaryOperator;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonToken;
import tools.jackson.core.type.WritableTypeId;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.DatabindException;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.MapperFeature;
import tools.jackson.databind.SerializationConfig;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.annotation.JacksonStdImpl;
import tools.jackson.databind.introspect.AnnotatedMember;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tools.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import tools.jackson.databind.jsontype.TypeIdResolver;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.ser.std.StdDynamicSerializer;
import tools.jackson.databind.util.ClassUtil;

@JacksonStdImpl
public class JsonValueSerializer
extends StdDynamicSerializer<Object> {
    protected final AnnotatedMember _accessor;
    protected final JavaType _valueType;
    protected final boolean _staticTyping;
    protected final boolean _forceTypeInformation;
    protected final Set<String> _ignoredProperties;

    protected JsonValueSerializer(JavaType nominalType, JavaType valueType, boolean staticTyping, TypeSerializer vts, ValueSerializer<?> ser, AnnotatedMember accessor, Set<String> ignoredProperties) {
        super(nominalType, null, vts, ser);
        this._valueType = valueType;
        this._staticTyping = staticTyping;
        this._accessor = accessor;
        this._forceTypeInformation = true;
        this._ignoredProperties = ignoredProperties;
    }

    protected JsonValueSerializer(JsonValueSerializer src, BeanProperty property, TypeSerializer vts, ValueSerializer<?> ser, boolean forceTypeInfo) {
        super(src, property, vts, ser);
        this._valueType = src._valueType;
        this._accessor = src._accessor;
        this._staticTyping = src._staticTyping;
        this._forceTypeInformation = forceTypeInfo;
        this._ignoredProperties = src._ignoredProperties;
    }

    public static JsonValueSerializer construct(SerializationConfig config, JavaType nominalType, JavaType valueType, boolean staticTyping, TypeSerializer vts, ValueSerializer<?> ser, AnnotatedMember accessor) {
        JsonIgnoreProperties.Value ignorals = config.getAnnotationIntrospector().findPropertyIgnoralByName(config, accessor);
        Set<String> ignoredProperties = ignorals.findIgnoredForSerialization();
        ser = JsonValueSerializer._withIgnoreProperties(ser, ignoredProperties);
        return new JsonValueSerializer(nominalType, valueType, staticTyping, vts, ser, accessor, ignoredProperties);
    }

    public JsonValueSerializer withResolved(BeanProperty property, TypeSerializer vts, ValueSerializer<?> ser, boolean forceTypeInfo) {
        if (this._property == property && this._valueTypeSerializer == vts && this._valueSerializer == ser && forceTypeInfo == this._forceTypeInformation) {
            return this;
        }
        return new JsonValueSerializer(this, property, vts, ser, forceTypeInfo);
    }

    @Override
    public boolean isEmpty(SerializationContext ctxt, Object bean) {
        Object referenced = this._accessor.getValue(bean);
        if (referenced == null) {
            return true;
        }
        ValueSerializer<Object> ser = this._valueSerializer;
        if (ser == null) {
            ser = this._findSerializer(ctxt, referenced);
        }
        return ser.isEmpty(ctxt, referenced);
    }

    @Override
    public ValueSerializer<?> createContextual(SerializationContext ctxt, BeanProperty property) {
        ValueSerializer<Object> ser;
        TypeSerializer vts = this._valueTypeSerializer;
        if (vts != null) {
            vts = vts.forProperty(ctxt, property);
        }
        if ((ser = this._valueSerializer) == null) {
            if (this._staticTyping || ctxt.isEnabled(MapperFeature.USE_STATIC_TYPING) || this._valueType.isFinal()) {
                ser = ctxt.findPrimaryPropertySerializer(this._valueType, property);
                ser = JsonValueSerializer._withIgnoreProperties(ser, this._ignoredProperties);
                boolean forceTypeInformation = this.isNaturalTypeWithStdHandling(this._valueType.getRawClass(), ser);
                return this.withResolved(property, vts, ser, forceTypeInformation);
            }
            if (property != this._property) {
                return this.withResolved(property, vts, ser, this._forceTypeInformation);
            }
        } else {
            ser = ctxt.handlePrimaryContextualization(ser, property);
            return this.withResolved(property, vts, ser, this._forceTypeInformation);
        }
        return this;
    }

    @Override
    public void serialize(Object bean, JsonGenerator gen, SerializationContext ctxt) throws JacksonException {
        Object value;
        try {
            value = this._accessor.getValue(bean);
        }
        catch (Exception e) {
            this.wrapAndThrow(ctxt, (Throwable)e, bean, this._accessor.getName() + "()");
            return;
        }
        if (value == null) {
            ctxt.defaultSerializeNullValue(gen);
            return;
        }
        ValueSerializer<Object> ser = this._valueSerializer;
        if (ser == null) {
            ser = this._findSerializer(ctxt, value);
        }
        if (this._valueTypeSerializer != null) {
            ser.serializeWithType(value, gen, ctxt, this._valueTypeSerializer);
        } else {
            ser.serialize(value, gen, ctxt);
        }
    }

    protected ValueSerializer<Object> _findSerializer(SerializationContext ctxt, Object value) {
        UnaryOperator serTransformer = valueSer -> JsonValueSerializer._withIgnoreProperties(valueSer, this._ignoredProperties);
        Class<?> cc = value.getClass();
        if (this._valueType.hasGenericTypes()) {
            return this._findAndAddDynamic(ctxt, ctxt.constructSpecializedType(this._valueType, cc), (UnaryOperator<ValueSerializer<Object>>)serTransformer);
        }
        return this._findAndAddDynamic(ctxt, cc, (UnaryOperator<ValueSerializer<Object>>)serTransformer);
    }

    protected static ValueSerializer<Object> _withIgnoreProperties(ValueSerializer<?> ser, Set<String> ignoredProperties) {
        if (ser != null && !ignoredProperties.isEmpty()) {
            ser = ser.withIgnoredProperties(ignoredProperties);
        }
        return ser;
    }

    @Override
    public void serializeWithType(Object bean, JsonGenerator gen, SerializationContext ctxt, TypeSerializer typeSer0) throws JacksonException {
        Object value;
        try {
            value = this._accessor.getValue(bean);
        }
        catch (Exception e) {
            this.wrapAndThrow(ctxt, (Throwable)e, bean, this._accessor.getName() + "()");
            return;
        }
        if (value == null) {
            ctxt.defaultSerializeNullValue(gen);
            return;
        }
        ValueSerializer<Object> ser = this._valueSerializer;
        if (ser == null) {
            Class<?> cc = value.getClass();
            ser = this._valueType.hasGenericTypes() ? this._findAndAddDynamic(ctxt, ctxt.constructSpecializedType(this._valueType, cc)) : this._findAndAddDynamic(ctxt, cc);
        }
        if (this._forceTypeInformation) {
            WritableTypeId typeIdDef = typeSer0.writeTypePrefix(gen, ctxt, typeSer0.typeId(bean, JsonToken.VALUE_STRING));
            ser.serialize(value, gen, ctxt);
            typeSer0.writeTypeSuffix(gen, ctxt, typeIdDef);
            return;
        }
        TypeSerializerRerouter rr = new TypeSerializerRerouter(typeSer0, bean);
        ser.serializeWithType(value, gen, ctxt, rr);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
        JavaType type = this._accessor.getType();
        Class<?> declaring = this._accessor.getDeclaringClass();
        if (declaring != null && ClassUtil.isEnumType(declaring) && this._acceptJsonFormatVisitorForEnum(visitor, typeHint, declaring)) {
            return;
        }
        ValueSerializer<Object> ser = this._valueSerializer;
        if (ser == null && (ser = visitor.getContext().findPrimaryPropertySerializer(type, this._property)) == null) {
            visitor.expectAnyFormat(typeHint);
            return;
        }
        ser.acceptJsonFormatVisitor(visitor, type);
    }

    protected boolean _acceptJsonFormatVisitorForEnum(JsonFormatVisitorWrapper visitor, JavaType typeHint, Class<?> enumType) {
        JsonStringFormatVisitor stringVisitor = visitor.expectStringFormat(typeHint);
        if (stringVisitor != null) {
            LinkedHashSet<String> enums = new LinkedHashSet<String>();
            for (Object en : enumType.getEnumConstants()) {
                try {
                    enums.add(String.valueOf(this._accessor.getValue(en)));
                }
                catch (Exception e) {
                    Throwable t = e;
                    while (t instanceof InvocationTargetException && t.getCause() != null) {
                        t = t.getCause();
                    }
                    ClassUtil.throwIfError(t);
                    throw DatabindException.wrapWithPath(visitor.getContext(), t, new JacksonException.Reference(en, this._accessor.getName() + "()"));
                }
            }
            stringVisitor.enumTypes(enums);
        }
        return true;
    }

    protected boolean isNaturalTypeWithStdHandling(Class<?> rawType, ValueSerializer<?> ser) {
        if (rawType.isPrimitive() ? rawType != Integer.TYPE && rawType != Boolean.TYPE && rawType != Double.TYPE : rawType != String.class && rawType != Integer.class && rawType != Boolean.class && rawType != Double.class) {
            return false;
        }
        return this.isDefaultSerializer(ser);
    }

    static class TypeSerializerRerouter
    extends TypeSerializer {
        protected final TypeSerializer _typeSerializer;
        protected final Object _forObject;

        public TypeSerializerRerouter(TypeSerializer ts, Object ob) {
            this._typeSerializer = ts;
            this._forObject = ob;
        }

        @Override
        public TypeSerializer forProperty(SerializationContext ctxt, BeanProperty prop) {
            throw new UnsupportedOperationException();
        }

        @Override
        public JsonTypeInfo.As getTypeInclusion() {
            return this._typeSerializer.getTypeInclusion();
        }

        @Override
        public String getPropertyName() {
            return this._typeSerializer.getPropertyName();
        }

        @Override
        public TypeIdResolver getTypeIdResolver() {
            return this._typeSerializer.getTypeIdResolver();
        }

        @Override
        public WritableTypeId writeTypePrefix(JsonGenerator g, SerializationContext ctxt, WritableTypeId typeId) throws JacksonException {
            typeId.forValue = this._forObject;
            return this._typeSerializer.writeTypePrefix(g, ctxt, typeId);
        }

        @Override
        public WritableTypeId writeTypeSuffix(JsonGenerator g, SerializationContext ctxt, WritableTypeId typeId) throws JacksonException {
            return this._typeSerializer.writeTypeSuffix(g, ctxt, typeId);
        }
    }
}

