/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser.jdk;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.LinkedHashSet;
import java.util.Objects;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.core.SerializableString;
import tools.jackson.databind.BeanDescription;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.EnumNamingStrategy;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationConfig;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.annotation.JacksonStdImpl;
import tools.jackson.databind.cfg.EnumFeature;
import tools.jackson.databind.introspect.AnnotatedClass;
import tools.jackson.databind.introspect.EnumNamingStrategyFactory;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tools.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import tools.jackson.databind.ser.std.StdScalarSerializer;
import tools.jackson.databind.util.EnumValues;

@JacksonStdImpl
public class EnumSerializer
extends StdScalarSerializer<Enum<?>> {
    protected final EnumValues _values;
    protected final Boolean _serializeAsIndex;
    protected final EnumValues _valuesByEnumNaming;
    protected final EnumValues _valuesByToString;

    public EnumSerializer(EnumValues v, Boolean serializeAsIndex, EnumValues valuesByEnumNaming, EnumValues valuesByToString) {
        super(v.getEnumClass(), false);
        this._values = v;
        this._serializeAsIndex = serializeAsIndex;
        this._valuesByEnumNaming = valuesByEnumNaming;
        this._valuesByToString = valuesByToString;
    }

    public static EnumSerializer construct(Class<?> enumClass, SerializationConfig config, BeanDescription beanDesc, JsonFormat.Value format) {
        EnumValues v = EnumValues.constructFromName(config, beanDesc.getClassInfo());
        EnumValues valuesByEnumNaming = EnumSerializer.constructEnumNamingStrategyValues(config, enumClass, beanDesc.getClassInfo());
        EnumValues valuesByToString = EnumValues.constructFromToString(config, beanDesc.getClassInfo());
        Boolean serializeAsIndex = EnumSerializer._isShapeWrittenUsingIndex(enumClass, format, true, null);
        return new EnumSerializer(v, serializeAsIndex, valuesByEnumNaming, valuesByToString);
    }

    @Override
    public ValueSerializer<?> createContextual(SerializationContext ctxt, BeanProperty property) {
        Class<?> type;
        Boolean serializeAsIndex;
        JsonFormat.Value format = this.findFormatOverrides(ctxt, property, this.handledType());
        if (format != null && !Objects.equals(serializeAsIndex = EnumSerializer._isShapeWrittenUsingIndex(type = this.handledType(), format, false, this._serializeAsIndex), this._serializeAsIndex)) {
            return new EnumSerializer(this._values, serializeAsIndex, this._valuesByEnumNaming, this._valuesByToString);
        }
        return this;
    }

    public EnumValues getEnumValues() {
        return this._values;
    }

    @Override
    public final void serialize(Enum<?> en, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
        if (this._valuesByEnumNaming != null) {
            g.writeString(this._valuesByEnumNaming.serializedValueFor(en));
            return;
        }
        if (this._serializeAsIndex(ctxt)) {
            g.writeNumber(en.ordinal());
            return;
        }
        if (ctxt.isEnabled(EnumFeature.WRITE_ENUMS_USING_TO_STRING)) {
            g.writeString(this._valuesByToString.serializedValueFor(en));
            return;
        }
        g.writeString(this._values.serializedValueFor(en));
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
        SerializationContext serializers = visitor.getContext();
        if (this._serializeAsIndex(serializers)) {
            this.visitIntFormat(visitor, typeHint, JsonParser.NumberType.INT);
            return;
        }
        JsonStringFormatVisitor stringVisitor = visitor.expectStringFormat(typeHint);
        if (stringVisitor != null) {
            LinkedHashSet<String> enums = new LinkedHashSet<String>();
            if (serializers != null && serializers.isEnabled(EnumFeature.WRITE_ENUMS_USING_TO_STRING)) {
                for (SerializableString value : this._valuesByToString.values()) {
                    enums.add(value.getValue());
                }
            } else {
                for (SerializableString value : this._values.values()) {
                    enums.add(value.getValue());
                }
            }
            stringVisitor.enumTypes(enums);
        }
    }

    protected final boolean _serializeAsIndex(SerializationContext ctxt) {
        if (this._serializeAsIndex != null) {
            return this._serializeAsIndex;
        }
        return ctxt.isEnabled(EnumFeature.WRITE_ENUMS_USING_INDEX);
    }

    protected static Boolean _isShapeWrittenUsingIndex(Class<?> enumClass, JsonFormat.Value format, boolean fromClass, Boolean defaultValue) {
        JsonFormat.Shape shape;
        JsonFormat.Shape shape2 = shape = format == null ? null : format.getShape();
        if (shape == null) {
            return defaultValue;
        }
        if (shape == JsonFormat.Shape.ANY || shape == JsonFormat.Shape.SCALAR) {
            return defaultValue;
        }
        if (shape == JsonFormat.Shape.STRING || shape == JsonFormat.Shape.NATURAL) {
            return Boolean.FALSE;
        }
        if (shape.isNumeric() || shape == JsonFormat.Shape.ARRAY) {
            return Boolean.TRUE;
        }
        throw new IllegalArgumentException(String.format("Unsupported serialization shape (%s) for Enum %s, not supported as %s annotation", new Object[]{shape, enumClass.getName(), fromClass ? "class" : "property"}));
    }

    protected static EnumValues constructEnumNamingStrategyValues(SerializationConfig config, Class<Enum<?>> enumClass, AnnotatedClass annotatedClass) {
        Object namingDef = config.getAnnotationIntrospector().findEnumNamingStrategy(config, annotatedClass);
        EnumNamingStrategy enumNamingStrategy = EnumNamingStrategyFactory.createEnumNamingStrategyInstance(namingDef, config.canOverrideAccessModifiers(), config.getEnumNamingStrategy());
        return enumNamingStrategy == null ? null : EnumValues.constructUsingEnumNamingStrategy(config, annotatedClass, enumNamingStrategy);
    }
}

