/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser.jdk;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonToken;
import tools.jackson.core.type.WritableTypeId;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationConfig;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.annotation.JacksonStdImpl;
import tools.jackson.databind.introspect.AnnotatedMember;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tools.jackson.databind.jsonFormatVisitors.JsonMapFormatVisitor;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.ser.PropertyFilter;
import tools.jackson.databind.ser.jdk.MapProperty;
import tools.jackson.databind.ser.std.StdContainerSerializer;
import tools.jackson.databind.type.TypeFactory;
import tools.jackson.databind.util.ArrayBuilders;
import tools.jackson.databind.util.BeanUtil;
import tools.jackson.databind.util.ClassUtil;
import tools.jackson.databind.util.IgnorePropertiesUtil;

@JacksonStdImpl
public class MapSerializer
extends StdContainerSerializer<Map<?, ?>> {
    protected static final JavaType UNSPECIFIED_TYPE = TypeFactory.unknownType();
    public static final Object MARKER_FOR_EMPTY = JsonInclude.Include.NON_EMPTY;
    protected final boolean _valueTypeIsStatic;
    protected final JavaType _keyType;
    protected final JavaType _valueType;
    protected ValueSerializer<Object> _keySerializer;
    protected ValueSerializer<Object> _valueSerializer;
    protected final TypeSerializer _valueTypeSerializer;
    protected final Set<String> _ignoredEntries;
    protected final Set<String> _includedEntries;
    protected final Object _filterId;
    protected final Object _suppressableValue;
    protected final boolean _suppressNulls;
    protected final IgnorePropertiesUtil.Checker _inclusionChecker;
    protected final boolean _sortKeys;

    protected MapSerializer(Set<String> ignoredEntries, Set<String> includedEntries, JavaType keyType, JavaType valueType, boolean valueTypeIsStatic, TypeSerializer vts, ValueSerializer<?> keySerializer, ValueSerializer<?> valueSerializer) {
        super(Map.class);
        this._ignoredEntries = ignoredEntries == null || ignoredEntries.isEmpty() ? null : ignoredEntries;
        this._includedEntries = includedEntries;
        this._keyType = keyType;
        this._valueType = valueType;
        this._valueTypeIsStatic = valueTypeIsStatic;
        this._valueTypeSerializer = vts;
        this._keySerializer = keySerializer;
        this._valueSerializer = valueSerializer;
        this._filterId = null;
        this._sortKeys = false;
        this._suppressableValue = null;
        this._suppressNulls = false;
        this._inclusionChecker = IgnorePropertiesUtil.buildCheckerIfNeeded(this._ignoredEntries, this._includedEntries);
    }

    protected MapSerializer(MapSerializer src, BeanProperty property, ValueSerializer<?> keySerializer, ValueSerializer<?> valueSerializer, Set<String> ignoredEntries, Set<String> includedEntries) {
        super(src, property);
        this._ignoredEntries = ignoredEntries == null || ignoredEntries.isEmpty() ? null : ignoredEntries;
        this._includedEntries = includedEntries;
        this._keyType = src._keyType;
        this._valueType = src._valueType;
        this._valueTypeIsStatic = src._valueTypeIsStatic;
        this._valueTypeSerializer = src._valueTypeSerializer;
        this._keySerializer = keySerializer;
        this._valueSerializer = valueSerializer;
        this._filterId = src._filterId;
        this._sortKeys = src._sortKeys;
        this._suppressableValue = src._suppressableValue;
        this._suppressNulls = src._suppressNulls;
        this._inclusionChecker = IgnorePropertiesUtil.buildCheckerIfNeeded(this._ignoredEntries, this._includedEntries);
    }

    protected MapSerializer(MapSerializer src, TypeSerializer vts, Object suppressableValue, boolean suppressNulls) {
        super(src);
        this._ignoredEntries = src._ignoredEntries;
        this._includedEntries = src._includedEntries;
        this._keyType = src._keyType;
        this._valueType = src._valueType;
        this._valueTypeIsStatic = src._valueTypeIsStatic;
        this._valueTypeSerializer = vts;
        this._keySerializer = src._keySerializer;
        this._valueSerializer = src._valueSerializer;
        this._filterId = src._filterId;
        this._sortKeys = src._sortKeys;
        this._suppressableValue = suppressableValue;
        this._suppressNulls = suppressNulls;
        this._inclusionChecker = src._inclusionChecker;
    }

    protected MapSerializer(MapSerializer src, Object filterId, boolean sortKeys) {
        super(src);
        this._ignoredEntries = src._ignoredEntries;
        this._includedEntries = src._includedEntries;
        this._keyType = src._keyType;
        this._valueType = src._valueType;
        this._valueTypeIsStatic = src._valueTypeIsStatic;
        this._valueTypeSerializer = src._valueTypeSerializer;
        this._keySerializer = src._keySerializer;
        this._valueSerializer = src._valueSerializer;
        this._filterId = filterId;
        this._sortKeys = sortKeys;
        this._suppressableValue = src._suppressableValue;
        this._suppressNulls = src._suppressNulls;
        this._inclusionChecker = src._inclusionChecker;
    }

    protected MapSerializer _withValueTypeSerializer(TypeSerializer vts) {
        if (this._valueTypeSerializer == vts) {
            return this;
        }
        this._ensureOverride("_withValueTypeSerializer");
        return new MapSerializer(this, vts, this._suppressableValue, this._suppressNulls);
    }

    protected MapSerializer withResolved(BeanProperty property, ValueSerializer<?> keySerializer, ValueSerializer<?> valueSerializer, Set<String> ignored, Set<String> included, boolean sortKeys) {
        this._ensureOverride("withResolved");
        MapSerializer ser = new MapSerializer(this, property, keySerializer, valueSerializer, ignored, included);
        if (sortKeys != ser._sortKeys) {
            ser = new MapSerializer(ser, this._filterId, sortKeys);
        }
        return ser;
    }

    public MapSerializer withFilterId(Object filterId) {
        if (this._filterId == filterId) {
            return this;
        }
        this._ensureOverride("withFilterId");
        return new MapSerializer(this, filterId, this._sortKeys);
    }

    public MapSerializer withContentInclusion(Object suppressableValue, boolean suppressNulls) {
        if (suppressableValue == this._suppressableValue && suppressNulls == this._suppressNulls) {
            return this;
        }
        this._ensureOverride("withContentInclusion");
        return new MapSerializer(this, this._valueTypeSerializer, suppressableValue, suppressNulls);
    }

    public static MapSerializer construct(JavaType mapType, boolean staticValueType, TypeSerializer vts, ValueSerializer<Object> keySerializer, ValueSerializer<Object> valueSerializer, Object filterId, Set<String> ignoredEntries, Set<String> includedEntries) {
        JavaType keyType;
        JavaType valueType;
        if (mapType == null) {
            keyType = valueType = UNSPECIFIED_TYPE;
        } else {
            keyType = mapType.getKeyType();
            valueType = mapType.hasRawClass(Properties.class) ? TypeFactory.unknownType() : mapType.getContentType();
        }
        if (!staticValueType) {
            staticValueType = valueType != null && valueType.isFinal();
        } else if (valueType.getRawClass() == Object.class) {
            staticValueType = false;
        }
        MapSerializer ser = new MapSerializer(ignoredEntries, includedEntries, keyType, valueType, staticValueType, vts, keySerializer, valueSerializer);
        if (filterId != null) {
            ser = ser.withFilterId(filterId);
        }
        return ser;
    }

    protected void _ensureOverride(String method) {
        ClassUtil.verifyMustOverride(MapSerializer.class, this, method);
    }

    @Override
    public ValueSerializer<?> createContextual(SerializationContext ctxt, BeanProperty property) {
        JsonInclude.Include incl;
        JsonInclude.Value value;
        Object object;
        Boolean B;
        JsonFormat.Value format;
        AnnotatedMember propertyAcc;
        ValueSerializer<Object> ser = null;
        ValueSerializer<Object> keySer = null;
        AnnotationIntrospector intr = ctxt.getAnnotationIntrospector();
        SerializationConfig config = ctxt.getConfig();
        AnnotatedMember annotatedMember = propertyAcc = property == null ? null : property.getMember();
        if (MapSerializer._neitherNull(propertyAcc, intr)) {
            keySer = ctxt.serializerInstance(propertyAcc, intr.findKeySerializer(config, propertyAcc));
            ser = ctxt.serializerInstance(propertyAcc, intr.findContentSerializer(config, propertyAcc));
        }
        if (ser == null) {
            ser = this._valueSerializer;
        }
        if ((ser = this.findContextualConvertingSerializer(ctxt, property, ser)) == null && this._valueTypeIsStatic && !this._valueType.isJavaLangObject()) {
            ser = ctxt.findContentValueSerializer(this._valueType, property);
        }
        if (keySer == null) {
            keySer = this._keySerializer;
        }
        keySer = keySer == null ? ctxt.findKeySerializer(this._keyType, property) : ctxt.handleSecondaryContextualization(keySer, property);
        Set<String> ignored = this._ignoredEntries;
        Set<String> included = this._includedEntries;
        boolean sortKeys = false;
        if (MapSerializer._neitherNull(propertyAcc, intr)) {
            Set<String> newIncluded;
            Set<String> newIgnored = intr.findPropertyIgnoralByName(config, propertyAcc).findIgnoredForSerialization();
            if (MapSerializer._nonEmpty(newIgnored)) {
                ignored = ignored == null ? new HashSet<String>() : new HashSet<String>(ignored);
                for (String string : newIgnored) {
                    ignored.add(string);
                }
            }
            if ((newIncluded = intr.findPropertyInclusionByName(config, propertyAcc).getIncluded()) != null) {
                included = included == null ? new HashSet<String>() : new HashSet<String>(included);
                for (String str : newIncluded) {
                    included.add(str);
                }
            }
            Boolean bl = intr.findSerializationSortAlphabetically(config, propertyAcc);
            sortKeys = Boolean.TRUE.equals(bl);
        }
        if ((format = this.findFormatOverrides(ctxt, property, Map.class)) != null && (B = format.getFeature(JsonFormat.Feature.WRITE_SORTED_MAP_ENTRIES)) != null) {
            sortKeys = B;
        }
        MapSerializer mser = this.withResolved(property, keySer, ser, ignored, included, sortKeys);
        if (propertyAcc != null && (object = intr.findFilterId(config, propertyAcc)) != null) {
            mser = mser.withFilterId(object);
        }
        if ((value = this.findIncludeOverrides(ctxt, property, Map.class)) != null && (incl = value.getContentInclusion()) != JsonInclude.Include.USE_DEFAULTS) {
            boolean suppressNulls;
            Object valueToSuppress;
            switch (incl) {
                case NON_DEFAULT: {
                    valueToSuppress = BeanUtil.getDefaultValue(this._valueType);
                    suppressNulls = true;
                    if (valueToSuppress == null || !valueToSuppress.getClass().isArray()) break;
                    valueToSuppress = ArrayBuilders.getArrayComparator(valueToSuppress);
                    break;
                }
                case NON_ABSENT: {
                    suppressNulls = true;
                    valueToSuppress = this._valueType.isReferenceType() ? MARKER_FOR_EMPTY : null;
                    break;
                }
                case NON_EMPTY: {
                    suppressNulls = true;
                    valueToSuppress = MARKER_FOR_EMPTY;
                    break;
                }
                case CUSTOM: {
                    valueToSuppress = ctxt.includeFilterInstance(null, value.getContentFilter());
                    if (valueToSuppress == null) {
                        suppressNulls = true;
                        break;
                    }
                    suppressNulls = ctxt.includeFilterSuppressNulls(valueToSuppress);
                    break;
                }
                case NON_NULL: {
                    valueToSuppress = null;
                    suppressNulls = true;
                    break;
                }
                default: {
                    valueToSuppress = null;
                    suppressNulls = false;
                }
            }
            mser = mser.withContentInclusion(valueToSuppress, suppressNulls);
        }
        return mser;
    }

    @Override
    public JavaType getContentType() {
        return this._valueType;
    }

    @Override
    public ValueSerializer<?> getContentSerializer() {
        return this._valueSerializer;
    }

    @Override
    public boolean isEmpty(SerializationContext prov, Map<?, ?> value) {
        boolean checkEmpty;
        if (value.isEmpty()) {
            return true;
        }
        Object supp = this._suppressableValue;
        if (supp == null && !this._suppressNulls) {
            return false;
        }
        ValueSerializer<Object> valueSer = this._valueSerializer;
        boolean bl = checkEmpty = MARKER_FOR_EMPTY == supp;
        if (valueSer != null) {
            for (Object elemValue : value.values()) {
                if (elemValue == null) {
                    if (this._suppressNulls) continue;
                    return false;
                }
                if (!(checkEmpty ? !valueSer.isEmpty(prov, elemValue) : supp == null || !supp.equals(value))) continue;
                return false;
            }
            return true;
        }
        for (Object elemValue : value.values()) {
            if (elemValue == null) {
                if (this._suppressNulls) continue;
                return false;
            }
            valueSer = this._findSerializer(prov, elemValue);
            if (!(checkEmpty ? !valueSer.isEmpty(prov, elemValue) : supp == null || !supp.equals(value))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasSingleElement(Map<?, ?> value) {
        return value.size() == 1;
    }

    public ValueSerializer<?> getKeySerializer() {
        return this._keySerializer;
    }

    @Override
    public void serialize(Map<?, ?> value, JsonGenerator gen, SerializationContext provider) throws JacksonException {
        gen.writeStartObject(value);
        this.serializeWithoutTypeInfo(value, gen, provider);
        gen.writeEndObject();
    }

    @Override
    public void serializeWithType(Map<?, ?> value, JsonGenerator gen, SerializationContext ctxt, TypeSerializer typeSer) throws JacksonException {
        gen.assignCurrentValue(value);
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(gen, ctxt, typeSer.typeId(value, JsonToken.START_OBJECT));
        this.serializeWithoutTypeInfo(value, gen, ctxt);
        typeSer.writeTypeSuffix(gen, ctxt, typeIdDef);
    }

    public void serializeWithoutTypeInfo(Map<?, ?> value, JsonGenerator gen, SerializationContext ctxt) throws JacksonException {
        if (!value.isEmpty()) {
            PropertyFilter pf;
            if (this._sortKeys || ctxt.isEnabled(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS)) {
                value = this._orderEntries(value, gen, ctxt);
            }
            if (this._filterId != null && (pf = this.findPropertyFilter(ctxt, this._filterId, value)) != null) {
                this.serializeFilteredEntries(value, gen, ctxt, pf, this._suppressableValue);
            } else if (this._suppressableValue != null || this._suppressNulls) {
                this.serializeOptionalFields(value, gen, ctxt, this._suppressableValue);
            } else if (this._valueSerializer != null) {
                this.serializeEntriesUsing(value, gen, ctxt, this._valueSerializer);
            } else {
                this.serializeEntries(value, gen, ctxt);
            }
        }
    }

    public void serializeEntries(Map<?, ?> value, JsonGenerator gen, SerializationContext provider) throws JacksonException {
        if (this._valueTypeSerializer != null) {
            this.serializeTypedEntries(value, gen, provider, null);
            return;
        }
        ValueSerializer<Object> keySerializer = this._keySerializer;
        Object keyElem = null;
        try {
            for (Map.Entry<?, ?> entry : value.entrySet()) {
                Object valueElem = entry.getValue();
                keyElem = entry.getKey();
                if (keyElem == null) {
                    provider.findNullKeySerializer(this._keyType, this._property).serialize(null, gen, provider);
                } else {
                    if (this._inclusionChecker != null && this._inclusionChecker.shouldIgnore(keyElem)) continue;
                    keySerializer.serialize(keyElem, gen, provider);
                }
                if (valueElem == null) {
                    provider.defaultSerializeNullValue(gen);
                    continue;
                }
                ValueSerializer<Object> serializer = this._valueSerializer;
                if (serializer == null) {
                    serializer = this._findSerializer(provider, valueElem);
                }
                serializer.serialize(valueElem, gen, provider);
            }
        }
        catch (Exception e) {
            this.wrapAndThrow(provider, (Throwable)e, value, String.valueOf(keyElem));
        }
    }

    public void serializeOptionalFields(Map<?, ?> value, JsonGenerator gen, SerializationContext provider, Object suppressableValue) throws JacksonException {
        if (this._valueTypeSerializer != null) {
            this.serializeTypedEntries(value, gen, provider, suppressableValue);
            return;
        }
        boolean checkEmpty = MARKER_FOR_EMPTY == suppressableValue;
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            ValueSerializer<Object> valueSer;
            ValueSerializer<Object> keySerializer;
            Object keyElem = entry.getKey();
            if (keyElem == null) {
                keySerializer = provider.findNullKeySerializer(this._keyType, this._property);
            } else {
                if (this._inclusionChecker != null && this._inclusionChecker.shouldIgnore(keyElem)) continue;
                keySerializer = this._keySerializer;
            }
            Object valueElem = entry.getValue();
            if (valueElem == null) {
                if (this._suppressNulls) continue;
                valueSer = provider.getDefaultNullValueSerializer();
            } else {
                valueSer = this._valueSerializer;
                if (valueSer == null) {
                    valueSer = this._findSerializer(provider, valueElem);
                }
                if (checkEmpty ? valueSer.isEmpty(provider, valueElem) : suppressableValue != null && suppressableValue.equals(valueElem)) continue;
            }
            try {
                keySerializer.serialize(keyElem, gen, provider);
                valueSer.serialize(valueElem, gen, provider);
            }
            catch (Exception e) {
                this.wrapAndThrow(provider, (Throwable)e, value, String.valueOf(keyElem));
            }
        }
    }

    public void serializeEntriesUsing(Map<?, ?> value, JsonGenerator gen, SerializationContext provider, ValueSerializer<Object> ser) throws JacksonException {
        ValueSerializer<Object> keySerializer = this._keySerializer;
        TypeSerializer typeSer = this._valueTypeSerializer;
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            Object keyElem = entry.getKey();
            if (this._inclusionChecker != null && this._inclusionChecker.shouldIgnore(keyElem)) continue;
            if (keyElem == null) {
                provider.findNullKeySerializer(this._keyType, this._property).serialize(null, gen, provider);
            } else {
                keySerializer.serialize(keyElem, gen, provider);
            }
            Object valueElem = entry.getValue();
            if (valueElem == null) {
                provider.defaultSerializeNullValue(gen);
                continue;
            }
            try {
                if (typeSer == null) {
                    ser.serialize(valueElem, gen, provider);
                    continue;
                }
                ser.serializeWithType(valueElem, gen, provider, typeSer);
            }
            catch (Exception e) {
                this.wrapAndThrow(provider, (Throwable)e, value, String.valueOf(keyElem));
            }
        }
    }

    public void serializeFilteredEntries(Map<?, ?> value, JsonGenerator gen, SerializationContext provider, PropertyFilter filter, Object suppressableValue) throws JacksonException {
        MapProperty prop = new MapProperty(this._valueTypeSerializer, this._property);
        boolean checkEmpty = MARKER_FOR_EMPTY == suppressableValue;
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            ValueSerializer<Object> valueSer;
            Object keyElem = entry.getKey();
            if (this._inclusionChecker != null && this._inclusionChecker.shouldIgnore(keyElem)) continue;
            ValueSerializer<Object> keySerializer = keyElem == null ? provider.findNullKeySerializer(this._keyType, this._property) : this._keySerializer;
            Object valueElem = entry.getValue();
            if (valueElem == null) {
                if (this._suppressNulls) continue;
                valueSer = provider.getDefaultNullValueSerializer();
            } else {
                valueSer = this._valueSerializer;
                if (valueSer == null) {
                    valueSer = this._findSerializer(provider, valueElem);
                }
                if (checkEmpty ? valueSer.isEmpty(provider, valueElem) : suppressableValue != null && suppressableValue.equals(valueElem)) continue;
            }
            prop.reset(keyElem, valueElem, keySerializer, valueSer);
            try {
                filter.serializeAsProperty(value, gen, provider, prop);
            }
            catch (Exception e) {
                this.wrapAndThrow(provider, (Throwable)e, value, String.valueOf(keyElem));
            }
        }
    }

    public void serializeTypedEntries(Map<?, ?> value, JsonGenerator gen, SerializationContext provider, Object suppressableValue) throws JacksonException {
        boolean checkEmpty = MARKER_FOR_EMPTY == suppressableValue;
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            ValueSerializer<Object> valueSer;
            ValueSerializer<Object> keySerializer;
            Object keyElem = entry.getKey();
            if (keyElem == null) {
                keySerializer = provider.findNullKeySerializer(this._keyType, this._property);
            } else {
                if (this._inclusionChecker != null && this._inclusionChecker.shouldIgnore(keyElem)) continue;
                keySerializer = this._keySerializer;
            }
            Object valueElem = entry.getValue();
            if (valueElem == null) {
                if (this._suppressNulls) continue;
                valueSer = provider.getDefaultNullValueSerializer();
            } else {
                valueSer = this._valueSerializer;
                if (valueSer == null) {
                    valueSer = this._findSerializer(provider, valueElem);
                }
                if (checkEmpty ? valueSer.isEmpty(provider, valueElem) : suppressableValue != null && suppressableValue.equals(valueElem)) continue;
            }
            keySerializer.serialize(keyElem, gen, provider);
            try {
                valueSer.serializeWithType(valueElem, gen, provider, this._valueTypeSerializer);
            }
            catch (Exception e) {
                this.wrapAndThrow(provider, (Throwable)e, value, String.valueOf(keyElem));
            }
        }
    }

    public void serializeFilteredAnyProperties(SerializationContext provider, JsonGenerator gen, Object bean, Map<?, ?> value, PropertyFilter filter, Object suppressableValue) throws JacksonException {
        MapProperty prop = new MapProperty(this._valueTypeSerializer, this._property);
        boolean checkEmpty = MARKER_FOR_EMPTY == suppressableValue;
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            ValueSerializer<Object> valueSer;
            Object keyElem = entry.getKey();
            if (this._inclusionChecker != null && this._inclusionChecker.shouldIgnore(keyElem)) continue;
            ValueSerializer<Object> keySerializer = keyElem == null ? provider.findNullKeySerializer(this._keyType, this._property) : this._keySerializer;
            Object valueElem = entry.getValue();
            if (valueElem == null) {
                if (this._suppressNulls) continue;
                valueSer = provider.getDefaultNullValueSerializer();
            } else {
                valueSer = this._valueSerializer;
                if (valueSer == null) {
                    valueSer = this._findSerializer(provider, valueElem);
                }
                if (checkEmpty ? valueSer.isEmpty(provider, valueElem) : suppressableValue != null && suppressableValue.equals(valueElem)) continue;
            }
            prop.reset(keyElem, valueElem, keySerializer, valueSer);
            try {
                filter.serializeAsProperty(bean, gen, provider, prop);
            }
            catch (Exception e) {
                this.wrapAndThrow(provider, (Throwable)e, value, String.valueOf(keyElem));
            }
        }
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
        JsonMapFormatVisitor v2 = visitor.expectMapFormat(typeHint);
        if (v2 != null) {
            v2.keyFormat(this._keySerializer, this._keyType);
            ValueSerializer<Object> valueSer = this._valueSerializer;
            if (valueSer == null) {
                valueSer = this._findAndAddDynamic(visitor.getContext(), this._valueType);
            }
            v2.valueFormat(valueSer, this._valueType);
        }
    }

    protected Map<?, ?> _orderEntries(Map<?, ?> input, JsonGenerator gen, SerializationContext provider) throws JacksonException {
        if (input instanceof SortedMap) {
            return input;
        }
        if (input.isEmpty()) {
            return input;
        }
        Object firstKey = input.keySet().iterator().next();
        if (!Comparable.class.isInstance(firstKey)) {
            if (!provider.isEnabled(SerializationFeature.FAIL_ON_ORDER_MAP_BY_INCOMPARABLE_KEY)) {
                return input;
            }
            Class clazz = firstKey == null ? Object.class : firstKey.getClass();
            provider.reportBadDefinition(clazz, String.format("Cannot order Map entries by key of incomparable type %s, consider disabling `SerializationFeature.FAIL_ON_ORDER_MAP_BY_INCOMPARABLE_KEY` to simply skip sorting", ClassUtil.classNameOf(firstKey)));
        }
        if (this._hasNullKey(input)) {
            TreeMap result = new TreeMap();
            for (Map.Entry<?, ?> entry : input.entrySet()) {
                Object key = entry.getKey();
                if (key == null) {
                    this._writeNullKeyedEntry(gen, provider, entry.getValue());
                    continue;
                }
                result.put(key, entry.getValue());
            }
            return result;
        }
        return new TreeMap(input);
    }

    protected boolean _hasNullKey(Map<?, ?> input) {
        return input instanceof HashMap && input.containsKey(null);
    }

    protected void _writeNullKeyedEntry(JsonGenerator g, SerializationContext ctxt, Object value) throws JacksonException {
        ValueSerializer<Object> valueSer;
        ValueSerializer<Object> keySerializer = ctxt.findNullKeySerializer(this._keyType, this._property);
        if (value == null) {
            if (this._suppressNulls) {
                return;
            }
            valueSer = ctxt.getDefaultNullValueSerializer();
        } else {
            valueSer = this._valueSerializer;
            if (valueSer == null) {
                valueSer = this._findSerializer(ctxt, value);
            }
            if (this._suppressableValue == MARKER_FOR_EMPTY ? valueSer.isEmpty(ctxt, value) : this._suppressableValue != null && this._suppressableValue.equals(value)) {
                return;
            }
        }
        try {
            keySerializer.serialize(null, g, ctxt);
            valueSer.serialize(value, g, ctxt);
        }
        catch (Exception e) {
            this.wrapAndThrow(ctxt, (Throwable)e, value, "");
        }
    }

    private final ValueSerializer<Object> _findSerializer(SerializationContext ctxt, Object value) {
        Class<?> cc = value.getClass();
        ValueSerializer<Object> valueSer = this._dynamicValueSerializers.serializerFor(cc);
        if (valueSer != null) {
            return valueSer;
        }
        if (this._valueType.hasGenericTypes()) {
            return this._findAndAddDynamic(ctxt, ctxt.constructSpecializedType(this._valueType, cc));
        }
        return this._findAndAddDynamic(ctxt, cc);
    }
}

