/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.gatekeeper.libs.yaml.updater;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import xyz.lychee.gatekeeper.libs.yaml.block.implementation.Section;
import xyz.lychee.gatekeeper.libs.yaml.dvs.Version;
import xyz.lychee.gatekeeper.libs.yaml.dvs.versioning.Versioning;
import xyz.lychee.gatekeeper.libs.yaml.route.Route;
import xyz.lychee.gatekeeper.libs.yaml.settings.updater.UpdaterSettings;
import xyz.lychee.gatekeeper.libs.yaml.updater.operators.Mapper;
import xyz.lychee.gatekeeper.libs.yaml.updater.operators.Relocator;

public class VersionedOperations {
    public static boolean run(@NotNull Section document, @NotNull Section defaults, @NotNull UpdaterSettings settings, char separator) {
        int compared;
        Versioning versioning = settings.getVersioning();
        if (versioning == null) {
            return false;
        }
        Version documentVersion = versioning.getDocumentVersion(document, false);
        Version defaultsVersion = Objects.requireNonNull(versioning.getDocumentVersion(defaults, true), "Version ID of the defaults cannot be null! Is it malformed or not specified?");
        int n = compared = documentVersion != null ? documentVersion.compareTo(defaultsVersion) : -1;
        if (compared > 0 && !settings.isEnableDowngrading()) {
            throw new UnsupportedOperationException(String.format("Downgrading is not enabled (%s > %s)!", defaultsVersion.asID(), documentVersion.asID()));
        }
        if (compared == 0) {
            return true;
        }
        if (compared < 0) {
            VersionedOperations.iterate(document, documentVersion != null ? documentVersion : versioning.getFirstVersion(), defaultsVersion, settings, separator);
        }
        settings.getIgnoredRoutes(defaultsVersion.asID(), separator).forEach(route -> document.getOptionalBlock((Route)route).ifPresent(block -> block.setIgnored(true)));
        return false;
    }

    private static void iterate(@NotNull Section document, @NotNull Version documentVersion, @NotNull Version defaultsVersion, @NotNull UpdaterSettings settings, char separator) {
        Version current = documentVersion.copy();
        while (current.compareTo(defaultsVersion) <= 0) {
            current.next();
            Relocator.apply(document, settings.getRelocations(current.asID(), separator));
            Mapper.apply(document, settings.getMappers(current.asID(), separator));
            settings.getCustomLogic(current.asID()).forEach(consumer -> consumer.accept(document.getRoot()));
        }
    }
}

