/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.gatekeeper.shared.checks;

import java.net.InetAddress;
import xyz.lychee.gatekeeper.shared.Gatekeeper;
import xyz.lychee.gatekeeper.shared.manager.AccountLimitManager;
import xyz.lychee.gatekeeper.shared.objects.AbstractCheck;

public class AccountLimitCheck
extends AbstractCheck {
    private int accountLimitPerIp;

    public AccountLimitCheck(Gatekeeper<?> gatekeeper) {
        super(gatekeeper, "AccountLimit");
    }

    @Override
    public boolean check(InetAddress address, String name, int dataAddress) {
        return this.accountLimitPerIp > 0 && AccountLimitManager.INSTANCE.numOfConnections(dataAddress) >= this.accountLimitPerIp;
    }

    @Override
    public boolean load() {
        this.accountLimitPerIp = this.getConfig().getInt("per_ip_limit");
        return true;
    }
}

