/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.gatekeeper.shared.checks;

import java.net.InetAddress;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import xyz.lychee.gatekeeper.shared.Gatekeeper;
import xyz.lychee.gatekeeper.shared.objects.AbstractCheck;

public class NicknameCheck
extends AbstractCheck {
    private final Set<String> list = new HashSet<String>();
    private boolean ignoreCase;

    public NicknameCheck(Gatekeeper<?> gatekeeper) {
        super(gatekeeper, "NicknameBlock");
    }

    @Override
    public boolean check(InetAddress address, String name, int dataAddress) {
        String processedName = this.ignoreCase ? name.toLowerCase() : name;
        for (String pattern : this.list) {
            if (!processedName.contains(pattern)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean load() {
        this.ignoreCase = this.getConfig().getBoolean("ignore_case", (Boolean)true);
        List<String> patterns = this.getConfig().getStringList("list");
        this.list.clear();
        if (this.ignoreCase) {
            for (String pattern : patterns) {
                this.list.add(pattern.toLowerCase());
            }
        } else {
            this.list.addAll(patterns);
        }
        return true;
    }
}

