/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.gatekeeper.shared.checks;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.ObjectMapper;
import xyz.lychee.gatekeeper.shared.Gatekeeper;
import xyz.lychee.gatekeeper.shared.objects.AbstractCheck;
import xyz.lychee.gatekeeper.shared.util.ConditionSet;

public class ProxyCheck
extends AbstractCheck {
    private final ObjectMapper mapper = new ObjectMapper();
    private final Map<Integer, Boolean> checked = new HashMap<Integer, Boolean>();
    private final Set<String> whitelist = new HashSet<String>();
    private final List<ConditionSet.Provider> providers = new ArrayList<ConditionSet.Provider>();
    private ExecutorService executor;
    private Semaphore semaphore;
    private int connect_timeout;
    private int read_timeout;
    private int execute_timeout;

    public ProxyCheck(Gatekeeper<?> gatekeeper) {
        super(gatekeeper, "AntiProxy");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public boolean check(InetAddress address, String name, int dataAddress) {
        if (this.providers.isEmpty()) {
            return false;
        }
        Boolean cached = this.checked.get(dataAddress);
        if (cached != null) {
            return cached;
        }
        String ip = address.getHostAddress();
        if (this.whitelist.contains(ip)) {
            this.checked.put(dataAddress, Boolean.FALSE);
            return false;
        }
        ExecutorCompletionService<ProviderResult> ecs = new ExecutorCompletionService<ProviderResult>(this.executor);
        ArrayList<Future<ProviderResult>> futures = new ArrayList<Future<ProviderResult>>(this.providers.size());
        for (ConditionSet.Provider provider : this.providers) {
            Callable<ProviderResult> task = () -> {
                boolean acquired = false;
                try {
                    this.semaphore.acquire();
                    acquired = true;
                    String urlStr = provider.getUrl().replace("%address%", ip);
                    JsonNode response = this.fetchJson(urlStr);
                    boolean match = provider.matches(response);
                    ProviderResult providerResult = new ProviderResult(provider, match, null);
                    return providerResult;
                }
                catch (Throwable t) {
                    ProviderResult providerResult = new ProviderResult(provider, false, t);
                    return providerResult;
                }
                finally {
                    if (acquired) {
                        this.semaphore.release();
                    }
                }
            };
            futures.add(ecs.submit(task));
        }
        boolean detected = false;
        try {
            for (int remaining = this.providers.size(); remaining > 0; --remaining) {
                Future completed = ecs.poll(this.execute_timeout, TimeUnit.MILLISECONDS);
                if (completed == null) {
                } else {
                    void var11_15;
                    try {
                        ProviderResult providerResult = (ProviderResult)completed.get(0L, TimeUnit.MILLISECONDS);
                        continue;
                    }
                    catch (ExecutionException | TimeoutException e) {
                        ProviderResult providerResult = new ProviderResult(null, false, e);
                    }
                    if (var11_15 == null || !var11_15.matched) continue;
                    detected = true;
                    for (Future future : futures) {
                        if (future.isDone()) continue;
                        future.cancel(true);
                    }
                }
                break;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            for (Future future : futures) {
                if (future.isDone()) continue;
                future.cancel(true);
            }
        }
        this.checked.put(dataAddress, detected);
        return detected;
    }

    @Override
    public boolean load() throws IOException {
        this.whitelist.clear();
        this.providers.clear();
        if (this.executor != null) {
            this.executor.shutdown();
        }
        int threads = Math.max(1, this.getConfig().getInt("threads"));
        int max_concurrent_checks = Math.max(1, this.getConfig().getInt("max_concurrent_checks"));
        this.connect_timeout = this.getConfig().getInt("connect_timeout");
        this.read_timeout = this.getConfig().getInt("read_timeout");
        this.execute_timeout = Math.max(1000, this.connect_timeout + this.read_timeout);
        this.executor = Executors.newFixedThreadPool(threads);
        this.semaphore = new Semaphore(max_concurrent_checks);
        this.whitelist.addAll(this.getConfig().getStringList("whitelist"));
        this.getConfig().getSection("checks").getKeys().stream().map(key -> this.getConfig().getSection("checks." + key)).filter(section -> section.getBoolean("enabled", (Boolean)false)).forEach(section -> {
            String condStr = section.getString("condition", null);
            String url = section.getString("url", "");
            int priority = section.getInt("priority", (Integer)0);
            ConditionSet cs = condStr != null ? ConditionSet.compile(condStr) : null;
            this.providers.add(new ConditionSet.Provider(url, priority, cs));
        });
        this.providers.sort(Comparator.comparingInt(ConditionSet.Provider::getPriority));
        return true;
    }

    private JsonNode fetchJson(String urlStr) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)URI.create(urlStr).toURL().openConnection();
        connection.setConnectTimeout(this.connect_timeout);
        connection.setReadTimeout(this.read_timeout);
        connection.setRequestMethod("GET");
        try {
            JsonNode jsonNode;
            block9: {
                InputStream inputStream = connection.getInputStream();
                try {
                    jsonNode = this.mapper.readTree(inputStream);
                    if (inputStream == null) break block9;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            return jsonNode;
        }
        finally {
            connection.disconnect();
        }
    }

    private static class ProviderResult {
        final ConditionSet.Provider provider;
        final boolean matched;
        final Throwable error;

        ProviderResult(ConditionSet.Provider provider, boolean matched, Throwable error) {
            this.provider = provider;
            this.matched = matched;
            this.error = error;
        }
    }
}

