/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.gatekeeper.shared.checks;

import java.net.InetAddress;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import xyz.lychee.gatekeeper.shared.Gatekeeper;
import xyz.lychee.gatekeeper.shared.manager.RateLimitManager;
import xyz.lychee.gatekeeper.shared.objects.AbstractCheck;

public class RateLimitCheck
extends AbstractCheck
implements Runnable {
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture<?> task;
    private int server_limit;
    private int ip_limit;

    public RateLimitCheck(Gatekeeper<?> gatekeeper) {
        super(gatekeeper, "RateLimit");
    }

    @Override
    public boolean check(InetAddress address, String name, int dataAddress) {
        RateLimitManager rateLimit = RateLimitManager.INSTANCE;
        long now = System.currentTimeMillis();
        if (rateLimit.getServerConnect() + (long)this.server_limit > now) {
            return true;
        }
        Long l = rateLimit.connectTimestamp(dataAddress);
        return l != null && l + (long)this.ip_limit > now;
    }

    @Override
    public boolean load() {
        if (this.task != null) {
            this.task.cancel(true);
        }
        this.server_limit = this.getConfig().getInt("server_limit");
        this.ip_limit = this.getConfig().getInt("ip_limit");
        this.task = this.executor.scheduleAtFixedRate(this, 1L, 1L, TimeUnit.MINUTES);
        return true;
    }

    @Override
    public void run() {
        RateLimitManager.INSTANCE.purge(this.ip_limit);
    }

    @Generated
    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    @Generated
    public ScheduledFuture<?> getTask() {
        return this.task;
    }

    @Generated
    public int getServer_limit() {
        return this.server_limit;
    }

    @Generated
    public int getIp_limit() {
        return this.ip_limit;
    }
}

