/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.gatekeeper.shared.command;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import xyz.lychee.gatekeeper.shared.Gatekeeper;
import xyz.lychee.gatekeeper.shared.objects.CommandPlayer;

public abstract class PermissibleCommand<T> {
    private final Gatekeeper<T> gatekeeper;
    private final String permission;

    public PermissibleCommand(Gatekeeper<T> gatekeeper, String permission) {
        this.gatekeeper = gatekeeper;
        this.permission = permission;
    }

    public void execute(CommandPlayer<T> player, String[] args) {
        if (!player.hasPermission(this.permission)) {
            player.sendMessage(this.gatekeeper.language(), "messages.no_permission", new String[0]);
            return;
        }
        this.handleExecution(player, args);
    }

    public List<String> suggest(CommandPlayer<T> player, String[] args) {
        return !player.hasPermission(this.permission) ? Collections.emptyList() : this.handleSuggestion(player, args);
    }

    protected abstract void handleExecution(CommandPlayer<T> var1, String[] var2);

    protected abstract List<String> handleSuggestion(CommandPlayer<T> var1, String[] var2);

    @Generated
    public Gatekeeper<T> getGatekeeper() {
        return this.gatekeeper;
    }

    @Generated
    public String getPermission() {
        return this.permission;
    }
}

