/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.gatekeeper.shared.manager;

import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;

public class RateLimitManager {
    public static final RateLimitManager INSTANCE = new RateLimitManager();
    private final ConcurrentHashMap<Integer, Long> ipConnect = new ConcurrentHashMap();
    private volatile long serverConnect = 0L;

    public void update(int dataAddress) {
        long now;
        this.serverConnect = now = System.currentTimeMillis();
        this.ipConnect.put(dataAddress, now);
    }

    public Long connectTimestamp(int dataAddress) {
        return this.ipConnect.get(dataAddress);
    }

    public void purge(int ip_limit) {
        long removable = System.currentTimeMillis() - (long)ip_limit;
        this.ipConnect.values().removeIf(value -> value < removable);
    }

    @Generated
    public ConcurrentHashMap<Integer, Long> getIpConnect() {
        return this.ipConnect;
    }

    @Generated
    public long getServerConnect() {
        return this.serverConnect;
    }
}

