/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.gatekeeper.shared.manager;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.type.CollectionType;
import xyz.lychee.gatekeeper.shared.Gatekeeper;
import xyz.lychee.gatekeeper.shared.manager.ConfigManager;

public class UpdaterManager
implements Runnable {
    public static final UpdaterManager INSTANCE = new UpdaterManager();
    private final VersionComparator comparator = new VersionComparator();
    private final ObjectMapper mapper = new ObjectMapper();
    private int compared = 0;
    private int difference = 0;
    private int behind = -1;
    private String latestVersion = "";
    private String currentVersion = "";
    private boolean updater;
    private Gatekeeper<?> plugin;

    public void load(Gatekeeper<?> plugin) throws IOException {
        this.updater = ConfigManager.INSTANCE.getYaml().getBoolean("updater");
        this.currentVersion = plugin.version().trim();
        this.plugin = plugin;
    }

    private int calculateBuildsBehind(List<ModrinthVersion> versions) {
        if (this.currentVersion.equals(this.latestVersion)) {
            return 0;
        }
        int currentIndex = -1;
        int latestIndex = -1;
        for (int i = 0; i < versions.size(); ++i) {
            ModrinthVersion version = versions.get(i);
            if (version.getVersion_number().equals(this.currentVersion)) {
                currentIndex = i;
            }
            if (!version.getVersion_number().equals(this.latestVersion)) continue;
            latestIndex = i;
        }
        if (currentIndex != -1 && latestIndex != -1) {
            return currentIndex - latestIndex;
        }
        return -1;
    }

    @Override
    public void run() {
        try {
            URL url = new URL("https://api.modrinth.com/v2/project/gatekeeper-mc/version");
            InputStreamReader reader = new InputStreamReader(url.openStream(), StandardCharsets.UTF_8);
            CollectionType type = this.mapper.getTypeFactory().constructCollectionType(ArrayList.class, ModrinthVersion.class);
            List versions = (List)this.mapper.readValue((Reader)reader, (JavaType)type);
            versions.removeIf(version -> version.getVersion_number().matches(".*[^0-9.].*"));
            if (!versions.isEmpty()) {
                versions.sort((v1, v2) -> this.comparator.compare(v2.getVersion_number(), v1.getVersion_number()));
                ModrinthVersion latest = (ModrinthVersion)versions.get(0);
                this.latestVersion = latest.getVersion_number();
                this.behind = this.calculateBuildsBehind(versions);
            } else {
                this.latestVersion = this.currentVersion;
                this.behind = 0;
            }
            this.difference = this.comparator.difference(this.currentVersion, this.latestVersion);
            this.compared = this.comparator.compare(this.currentVersion, this.latestVersion);
            if (this.difference >= 0 && this.difference < 2 || this.behind > 5) {
                this.updater = true;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (this.updater && this.compared < 0) {
            this.plugin.logger().info(String.format("\n&8\u2218\u208a\u2727\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2727\u208a\u2218\n&c&lGatekeeper needs an update!\n&fVersion: &e&n%s&r -> &e&n%s&r\n&ahttps://modrinth.com/plugin/gatekeeper-mc/version/%s\n&8\u2218\u208a\u2727\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2727\u208a\u2218", this.currentVersion, this.latestVersion, this.latestVersion));
        }
    }

    @Generated
    public VersionComparator getComparator() {
        return this.comparator;
    }

    @Generated
    public ObjectMapper getMapper() {
        return this.mapper;
    }

    @Generated
    public int getCompared() {
        return this.compared;
    }

    @Generated
    public int getDifference() {
        return this.difference;
    }

    @Generated
    public int getBehind() {
        return this.behind;
    }

    @Generated
    public String getLatestVersion() {
        return this.latestVersion;
    }

    @Generated
    public String getCurrentVersion() {
        return this.currentVersion;
    }

    @Generated
    public boolean isUpdater() {
        return this.updater;
    }

    @Generated
    public Gatekeeper<?> getPlugin() {
        return this.plugin;
    }

    public static class VersionComparator
    implements Comparator<String> {
        @Override
        public int compare(String current, String latest) {
            String[] parts1 = current.split("\\.");
            String[] parts2 = latest.split("\\.");
            int length = Math.max(parts1.length, parts2.length);
            for (int i = 0; i < length; ++i) {
                int num2;
                int num1 = i < parts1.length ? Integer.parseInt(parts1[i]) : 0;
                int n = num2 = i < parts2.length ? Integer.parseInt(parts2[i]) : 0;
                if (num1 == num2) continue;
                return Integer.compare(num1, num2);
            }
            return 0;
        }

        public int difference(String current, String latest) {
            String[] parts1 = current.split("\\.");
            String[] parts2 = latest.split("\\.");
            int length = Math.max(parts1.length, parts2.length);
            for (int i = 0; i < length; ++i) {
                int num2;
                int num1 = i < parts1.length ? Integer.parseInt(parts1[i]) : 0;
                int n = num2 = i < parts2.length ? Integer.parseInt(parts2[i]) : 0;
                if (num1 >= num2) continue;
                return i;
            }
            return -1;
        }
    }

    public static class ModrinthVersion {
        private List<String> game_versions;
        private List<String> loaders;
        private String id;
        private String project_id;
        private String author_id;
        private boolean featured;
        private String name;
        private String version_number;
        private String changelog;
        private String changelog_url;
        private String date_published;
        private int downloads;
        private String version_type;
        private String status;
        private String requested_status;
        private List<VersionFile> files;
        private List<Dependency> dependencies;

        @Generated
        public List<String> getGame_versions() {
            return this.game_versions;
        }

        @Generated
        public List<String> getLoaders() {
            return this.loaders;
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getProject_id() {
            return this.project_id;
        }

        @Generated
        public String getAuthor_id() {
            return this.author_id;
        }

        @Generated
        public boolean isFeatured() {
            return this.featured;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getVersion_number() {
            return this.version_number;
        }

        @Generated
        public String getChangelog() {
            return this.changelog;
        }

        @Generated
        public String getChangelog_url() {
            return this.changelog_url;
        }

        @Generated
        public String getDate_published() {
            return this.date_published;
        }

        @Generated
        public int getDownloads() {
            return this.downloads;
        }

        @Generated
        public String getVersion_type() {
            return this.version_type;
        }

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public String getRequested_status() {
            return this.requested_status;
        }

        @Generated
        public List<VersionFile> getFiles() {
            return this.files;
        }

        @Generated
        public List<Dependency> getDependencies() {
            return this.dependencies;
        }

        @Generated
        public void setGame_versions(List<String> game_versions) {
            this.game_versions = game_versions;
        }

        @Generated
        public void setLoaders(List<String> loaders) {
            this.loaders = loaders;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @Generated
        public void setProject_id(String project_id) {
            this.project_id = project_id;
        }

        @Generated
        public void setAuthor_id(String author_id) {
            this.author_id = author_id;
        }

        @Generated
        public void setFeatured(boolean featured) {
            this.featured = featured;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setVersion_number(String version_number) {
            this.version_number = version_number;
        }

        @Generated
        public void setChangelog(String changelog) {
            this.changelog = changelog;
        }

        @Generated
        public void setChangelog_url(String changelog_url) {
            this.changelog_url = changelog_url;
        }

        @Generated
        public void setDate_published(String date_published) {
            this.date_published = date_published;
        }

        @Generated
        public void setDownloads(int downloads) {
            this.downloads = downloads;
        }

        @Generated
        public void setVersion_type(String version_type) {
            this.version_type = version_type;
        }

        @Generated
        public void setStatus(String status) {
            this.status = status;
        }

        @Generated
        public void setRequested_status(String requested_status) {
            this.requested_status = requested_status;
        }

        @Generated
        public void setFiles(List<VersionFile> files) {
            this.files = files;
        }

        @Generated
        public void setDependencies(List<Dependency> dependencies) {
            this.dependencies = dependencies;
        }
    }

    public static class Dependency {
        public String version_id;
        public String project_id;
        public String file_name;
        public String dependency_type;

        @Generated
        public String getVersion_id() {
            return this.version_id;
        }

        @Generated
        public String getProject_id() {
            return this.project_id;
        }

        @Generated
        public String getFile_name() {
            return this.file_name;
        }

        @Generated
        public String getDependency_type() {
            return this.dependency_type;
        }

        @Generated
        public void setVersion_id(String version_id) {
            this.version_id = version_id;
        }

        @Generated
        public void setProject_id(String project_id) {
            this.project_id = project_id;
        }

        @Generated
        public void setFile_name(String file_name) {
            this.file_name = file_name;
        }

        @Generated
        public void setDependency_type(String dependency_type) {
            this.dependency_type = dependency_type;
        }
    }

    public static class VersionFile {
        private Map<String, String> hashes;
        private String url;
        private String filename;
        private boolean primary;
        private int size;
        private String file_type;

        @Generated
        public Map<String, String> getHashes() {
            return this.hashes;
        }

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public String getFilename() {
            return this.filename;
        }

        @Generated
        public boolean isPrimary() {
            return this.primary;
        }

        @Generated
        public int getSize() {
            return this.size;
        }

        @Generated
        public String getFile_type() {
            return this.file_type;
        }

        @Generated
        public void setHashes(Map<String, String> hashes) {
            this.hashes = hashes;
        }

        @Generated
        public void setUrl(String url) {
            this.url = url;
        }

        @Generated
        public void setFilename(String filename) {
            this.filename = filename;
        }

        @Generated
        public void setPrimary(boolean primary) {
            this.primary = primary;
        }

        @Generated
        public void setSize(int size) {
            this.size = size;
        }

        @Generated
        public void setFile_type(String file_type) {
            this.file_type = file_type;
        }
    }
}

