/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.gatekeeper.shared.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import tools.jackson.databind.JsonNode;

public final class ConditionSet {
    private final List<List<Term>> orClauses;

    private ConditionSet(List<List<Term>> orClauses) {
        this.orClauses = orClauses;
    }

    public boolean evaluate(JsonNode node) {
        for (List<Term> andBlock : this.orClauses) {
            boolean allMatch = true;
            for (Term t : andBlock) {
                if (t.matches(node)) continue;
                allMatch = false;
                break;
            }
            if (!allMatch) continue;
            return true;
        }
        return false;
    }

    public static ConditionSet compile(String expr) {
        if (expr == null || expr.trim().isEmpty()) {
            return null;
        }
        String[] orParts = expr.split("\\|");
        ArrayList<List<Term>> orClauses = new ArrayList<List<Term>>(orParts.length);
        for (String orPart : orParts) {
            String trimmedOr = orPart.trim();
            if (trimmedOr.isEmpty()) continue;
            String[] andParts = trimmedOr.split("&");
            ArrayList<Term> andList = new ArrayList<Term>(andParts.length);
            for (String andPart : andParts) {
                Term t;
                String e = andPart.trim();
                if (e.isEmpty() || (t = ConditionSet.parseTerm(e)) == null) continue;
                andList.add(t);
            }
            if (andList.isEmpty()) continue;
            orClauses.add(andList);
        }
        return new ConditionSet(orClauses);
    }

    private static Term parseTerm(String expression) {
        String opStr;
        int pos = expression.indexOf(">=");
        if (pos >= 0) {
            opStr = ">=";
        } else {
            pos = expression.indexOf("<=");
            if (pos >= 0) {
                opStr = "<=";
            } else {
                pos = expression.indexOf(">");
                if (pos >= 0) {
                    opStr = ">";
                } else {
                    pos = expression.indexOf("<");
                    if (pos >= 0) {
                        opStr = "<";
                    } else {
                        pos = expression.indexOf("=");
                        if (pos >= 0) {
                            opStr = "=";
                        } else {
                            return null;
                        }
                    }
                }
            }
        }
        String path = expression.substring(0, pos).trim();
        String valuePart = expression.substring(pos + opStr.length()).trim();
        if (path.isEmpty() || valuePart.isEmpty()) {
            return null;
        }
        String[] segments = ConditionSet.splitPath(path);
        if (">=".equals(opStr) || ">".equals(opStr) || "<=".equals(opStr) || "<".equals(opStr)) {
            try {
                Op op;
                double d = Double.parseDouble(valuePart);
                switch (opStr) {
                    case ">=": {
                        op = Op.GTE;
                        break;
                    }
                    case "<=": {
                        op = Op.LTE;
                        break;
                    }
                    case ">": {
                        op = Op.GT;
                        break;
                    }
                    default: {
                        op = Op.LT;
                    }
                }
                return new Term(segments, op, d);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        String low = valuePart.toLowerCase(Locale.ROOT);
        if ("true".equals(low) || "false".equals(low)) {
            boolean b = Boolean.parseBoolean(low);
            return new Term(segments, Op.EQ, b);
        }
        try {
            double d = Double.parseDouble(valuePart);
            return new Term(segments, Op.EQ, d);
        }
        catch (NumberFormatException numberFormatException) {
            return new Term(segments, Op.EQ, valuePart);
        }
    }

    private static String[] splitPath(String path) {
        String[] raw = path.split(">");
        for (int i = 0; i < raw.length; ++i) {
            raw[i] = raw[i].trim();
        }
        return raw;
    }

    private static final class Term {
        final String[] pathSegments;
        final Op op;
        final ValueType valueType;
        final double expectedNumber;
        final boolean expectedBool;
        final String expectedText;

        Term(String[] pathSegments, Op op, double expectedNumber) {
            this.pathSegments = pathSegments;
            this.op = op;
            this.valueType = ValueType.NUMBER;
            this.expectedNumber = expectedNumber;
            this.expectedBool = false;
            this.expectedText = null;
        }

        Term(String[] pathSegments, Op op, boolean expectedBool) {
            this.pathSegments = pathSegments;
            this.op = op;
            this.valueType = ValueType.BOOLEAN;
            this.expectedNumber = 0.0;
            this.expectedBool = expectedBool;
            this.expectedText = null;
        }

        Term(String[] pathSegments, Op op, String expectedText) {
            this.pathSegments = pathSegments;
            this.op = op;
            this.valueType = ValueType.TEXT;
            this.expectedNumber = 0.0;
            this.expectedBool = false;
            this.expectedText = expectedText;
        }

        boolean matches(JsonNode root) {
            JsonNode cur = root;
            for (String seg : this.pathSegments) {
                if (cur == null) {
                    return false;
                }
                cur = cur.get(seg);
            }
            if (cur == null || cur.isNull()) {
                return false;
            }
            switch (this.valueType.ordinal()) {
                case 0: {
                    if (!cur.isNumber()) {
                        return false;
                    }
                    double actual = cur.asDouble();
                    switch (this.op.ordinal()) {
                        case 0: {
                            return actual == this.expectedNumber;
                        }
                        case 1: {
                            return actual > this.expectedNumber;
                        }
                        case 2: {
                            return actual < this.expectedNumber;
                        }
                        case 3: {
                            return actual >= this.expectedNumber;
                        }
                        case 4: {
                            return actual <= this.expectedNumber;
                        }
                    }
                    return false;
                }
                case 1: {
                    boolean actualBool;
                    if (cur.isBoolean()) {
                        actualBool = cur.asBoolean();
                    } else if (cur.isString()) {
                        actualBool = Boolean.parseBoolean(cur.asString());
                    } else {
                        return false;
                    }
                    return this.op == Op.EQ && actualBool == this.expectedBool;
                }
                case 2: {
                    String actualText;
                    String string = actualText = cur.isString() ? cur.asString() : cur.asString(null);
                    if (actualText == null) {
                        return false;
                    }
                    return this.op == Op.EQ && actualText.equalsIgnoreCase(this.expectedText);
                }
            }
            return false;
        }
    }

    public static enum Op {
        EQ,
        GT,
        LT,
        GTE,
        LTE;

    }

    public static final class Provider {
        private final String url;
        private final int priority;
        private final ConditionSet condition;

        public Provider(String url, int priority, ConditionSet condition) {
            this.url = url;
            this.priority = priority;
            this.condition = condition;
        }

        public boolean matches(JsonNode json) {
            if (this.condition == null) {
                return true;
            }
            return this.condition.evaluate(json);
        }

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public int getPriority() {
            return this.priority;
        }

        @Generated
        public ConditionSet getCondition() {
            return this.condition;
        }
    }

    private static enum ValueType {
        NUMBER,
        BOOLEAN,
        TEXT;

    }
}

