/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser;

import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.SerializableString;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ser.impl.ObjectIdWriter;

public final class WritableObjectId {
    public final ObjectIdGenerator<?> generator;
    public Object id;
    protected boolean idWritten = false;

    public WritableObjectId(ObjectIdGenerator<?> g) {
        this.generator = g;
    }

    public boolean writeAsReference(JsonGenerator g, SerializationContext ctxt, ObjectIdWriter w) throws JacksonException {
        if (this.id != null && (this.idWritten || w.alwaysAsId)) {
            if (g.canWriteObjectId()) {
                g.writeObjectRef(String.valueOf(this.id));
            } else {
                w.serializer.serialize(this.id, g, ctxt);
            }
            return true;
        }
        return false;
    }

    public Object generateId(Object forPojo) {
        if (this.id == null) {
            this.id = this.generator.generateId(forPojo);
        }
        return this.id;
    }

    public void writeAsDeclaration(JsonGenerator g, SerializationContext ctxt, ObjectIdWriter w) throws JacksonException {
        this.idWritten = true;
        if (g.canWriteObjectId()) {
            String idStr = this.id == null ? null : String.valueOf(this.id);
            g.writeObjectId(idStr);
            return;
        }
        SerializableString name = w.propertyName;
        if (name != null) {
            g.writeName(name);
            w.serializer.serialize(this.id, g, ctxt);
        }
    }
}

