/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser.bean;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonToken;
import tools.jackson.core.type.WritableTypeId;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.BeanDescription;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.DatabindException;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.SerializationConfig;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.introspect.AnnotatedMember;
import tools.jackson.databind.introspect.ObjectIdInfo;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tools.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.ser.AnyGetterWriter;
import tools.jackson.databind.ser.BeanPropertyWriter;
import tools.jackson.databind.ser.BeanSerializerBuilder;
import tools.jackson.databind.ser.PropertyFilter;
import tools.jackson.databind.ser.PropertyWriter;
import tools.jackson.databind.ser.WritableObjectId;
import tools.jackson.databind.ser.impl.ObjectIdWriter;
import tools.jackson.databind.ser.impl.PropertyBasedObjectIdGenerator;
import tools.jackson.databind.ser.jdk.EnumSerializer;
import tools.jackson.databind.ser.jdk.MapEntrySerializer;
import tools.jackson.databind.ser.std.StdContainerSerializer;
import tools.jackson.databind.ser.std.StdDelegatingSerializer;
import tools.jackson.databind.ser.std.StdSerializer;
import tools.jackson.databind.util.ClassUtil;
import tools.jackson.databind.util.Converter;
import tools.jackson.databind.util.IgnorePropertiesUtil;
import tools.jackson.databind.util.NameTransformer;

public abstract class BeanSerializerBase
extends StdSerializer<Object> {
    protected static final PropertyName NAME_FOR_OBJECT_REF = new PropertyName("#object-ref");
    protected static final BeanPropertyWriter[] NO_PROPS = new BeanPropertyWriter[0];
    protected final JavaType _beanType;
    protected final BeanPropertyWriter[] _props;
    protected final BeanPropertyWriter[] _filteredProps;
    protected final Object _propertyFilterId;
    protected final AnnotatedMember _typeId;
    protected final ObjectIdWriter _objectIdWriter;
    protected final JsonFormat.Shape _serializationShape;

    protected BeanSerializerBase(JavaType type, BeanSerializerBuilder builder, BeanPropertyWriter[] properties, BeanPropertyWriter[] filteredProperties) {
        super(type);
        this._beanType = type;
        this._props = properties;
        this._filteredProps = filteredProperties;
        if (builder == null) {
            this._typeId = null;
            this._propertyFilterId = null;
            this._objectIdWriter = null;
            this._serializationShape = null;
        } else {
            this._typeId = builder.getTypeId();
            this._propertyFilterId = builder.getFilterId();
            this._objectIdWriter = builder.getObjectIdWriter();
            JsonFormat.Value format = builder.getBeanDescriptionRef().findExpectedFormat(type.getRawClass());
            this._serializationShape = format.getShape();
        }
    }

    protected BeanSerializerBase(BeanSerializerBase src) {
        this(src, src._props, src._filteredProps);
    }

    protected BeanSerializerBase(BeanSerializerBase src, BeanPropertyWriter[] properties, BeanPropertyWriter[] filteredProperties) {
        super(src._handledType);
        this._beanType = src._beanType;
        this._props = properties;
        this._filteredProps = filteredProperties;
        this._typeId = src._typeId;
        this._objectIdWriter = src._objectIdWriter;
        this._propertyFilterId = src._propertyFilterId;
        this._serializationShape = src._serializationShape;
    }

    protected BeanSerializerBase(BeanSerializerBase src, ObjectIdWriter objectIdWriter) {
        this(src, objectIdWriter, src._propertyFilterId);
    }

    protected BeanSerializerBase(BeanSerializerBase src, ObjectIdWriter objectIdWriter, Object filterId) {
        super(src._handledType);
        this._beanType = src._beanType;
        this._props = src._props;
        this._filteredProps = src._filteredProps;
        this._typeId = src._typeId;
        this._objectIdWriter = objectIdWriter;
        this._propertyFilterId = filterId;
        this._serializationShape = src._serializationShape;
    }

    protected BeanSerializerBase(BeanSerializerBase src, Set<String> toIgnore, Set<String> toInclude) {
        super(src._handledType);
        this._beanType = src._beanType;
        BeanPropertyWriter[] propsIn = src._props;
        BeanPropertyWriter[] fpropsIn = src._filteredProps;
        int len = propsIn.length;
        ArrayList<BeanPropertyWriter> propsOut = new ArrayList<BeanPropertyWriter>(len);
        ArrayList<BeanPropertyWriter> fpropsOut = fpropsIn == null ? null : new ArrayList<BeanPropertyWriter>(len);
        for (int i = 0; i < len; ++i) {
            BeanPropertyWriter bpw = propsIn[i];
            if (IgnorePropertiesUtil.shouldIgnore(bpw.getName(), toIgnore, toInclude)) continue;
            propsOut.add(bpw);
            if (fpropsIn == null) continue;
            fpropsOut.add(fpropsIn[i]);
        }
        this._props = propsOut.toArray(NO_PROPS);
        this._filteredProps = fpropsOut == null ? null : fpropsOut.toArray(NO_PROPS);
        this._typeId = src._typeId;
        this._objectIdWriter = src._objectIdWriter;
        this._propertyFilterId = src._propertyFilterId;
        this._serializationShape = src._serializationShape;
    }

    public abstract BeanSerializerBase withObjectIdWriter(ObjectIdWriter var1);

    protected abstract BeanSerializerBase withByNameInclusion(Set<String> var1, Set<String> var2);

    protected abstract BeanSerializerBase asArraySerializer();

    public abstract BeanSerializerBase withFilterId(Object var1);

    protected abstract BeanSerializerBase withProperties(BeanPropertyWriter[] var1, BeanPropertyWriter[] var2);

    @Override
    public abstract ValueSerializer<Object> unwrappingSerializer(NameTransformer var1);

    protected BeanSerializerBase(BeanSerializerBase src, NameTransformer unwrapper) {
        this(src, BeanSerializerBase.rename(src._props, unwrapper), BeanSerializerBase.rename(src._filteredProps, unwrapper));
    }

    private static final BeanPropertyWriter[] rename(BeanPropertyWriter[] props, NameTransformer transformer) {
        if (props == null || props.length == 0 || transformer == null || transformer == NameTransformer.NOP) {
            return props;
        }
        int len = props.length;
        BeanPropertyWriter[] result = new BeanPropertyWriter[len];
        for (int i = 0; i < len; ++i) {
            BeanPropertyWriter bpw = props[i];
            if (bpw == null) continue;
            result[i] = bpw.rename(transformer);
        }
        return result;
    }

    @Override
    public void resolve(SerializationContext provider) {
        int i;
        int filteredCount = this._filteredProps == null ? 0 : this._filteredProps.length;
        int len = this._props.length;
        for (i = 0; i < len; ++i) {
            BeanPropertyWriter w2;
            ValueSerializer<Object> nullSer;
            BeanPropertyWriter prop = this._props[i];
            if (!prop.willSuppressNulls() && !prop.hasNullSerializer() && (nullSer = provider.findNullValueSerializer(prop)) != null) {
                prop.assignNullSerializer(nullSer);
                if (i < filteredCount && (w2 = this._filteredProps[i]) != null) {
                    w2.assignNullSerializer(nullSer);
                }
            }
            if (prop.hasSerializer()) continue;
            ValueSerializer<Object> ser = this.findConvertingSerializer(provider, prop);
            if (ser == null) {
                TypeSerializer typeSer;
                JavaType type = prop.getSerializationType();
                if (type == null && !(type = prop.getType()).isFinal()) {
                    if (!type.isContainerType() && type.containedTypeCount() <= 0) continue;
                    prop.setNonTrivialBaseType(type);
                    continue;
                }
                ser = provider.findPrimaryPropertySerializer(type, (BeanProperty)prop);
                if (type.isContainerType() && (typeSer = (TypeSerializer)type.getContentType().getTypeHandler()) != null && ser instanceof StdContainerSerializer) {
                    StdContainerSerializer<?> ser2 = ((StdContainerSerializer)ser).withValueTypeSerializer(typeSer);
                    ser = ser2;
                }
            }
            if (i < filteredCount && (w2 = this._filteredProps[i]) != null) {
                w2.assignSerializer(ser);
                continue;
            }
            prop.assignSerializer(ser);
        }
        for (i = 0; i < this._props.length; ++i) {
            BeanPropertyWriter prop = this._props[i];
            if (!(prop instanceof AnyGetterWriter)) continue;
            ((AnyGetterWriter)prop).resolve(provider);
        }
    }

    protected ValueSerializer<Object> findConvertingSerializer(SerializationContext provider, BeanPropertyWriter prop) {
        Object convDef;
        AnnotatedMember m;
        AnnotationIntrospector intr = provider.getAnnotationIntrospector();
        if (intr != null && (m = prop.getMember()) != null && (convDef = intr.findSerializationConverter(provider.getConfig(), m)) != null) {
            Converter<Object, Object> conv = provider.converterInstance(prop.getMember(), convDef);
            JavaType delegateType = conv.getOutputType(provider.getTypeFactory());
            ValueSerializer<Object> ser = delegateType.isJavaLangObject() ? null : provider.findPrimaryPropertySerializer(delegateType, (BeanProperty)prop);
            return new StdDelegatingSerializer(conv, delegateType, ser, prop);
        }
        return null;
    }

    @Override
    public ValueSerializer<?> createContextual(SerializationContext ctxt, BeanProperty property) {
        ValueSerializer<Object> ser;
        AnnotationIntrospector intr = ctxt.getAnnotationIntrospector();
        AnnotatedMember accessor = BeanSerializerBase._neitherNull(property, intr) ? property.getMember() : null;
        SerializationConfig config = ctxt.getConfig();
        JsonFormat.Value format = this.findFormatOverrides(ctxt, property, this._handledType);
        JsonFormat.Shape shape = null;
        if (format != null && format.hasShape() && (shape = format.getShape()) != JsonFormat.Shape.ANY && shape != this._serializationShape) {
            if (this._beanType.isEnumType()) {
                switch (shape) {
                    case STRING: 
                    case NUMBER: 
                    case NUMBER_INT: {
                        BeanDescription desc = ctxt.introspectBeanDescription(this._beanType);
                        EnumSerializer ser2 = EnumSerializer.construct(this._beanType.getRawClass(), config, desc, format);
                        return ctxt.handlePrimaryContextualization(ser2, property);
                    }
                }
            } else if (!(shape != JsonFormat.Shape.NATURAL || this._beanType.isMapLikeType() && Map.class.isAssignableFrom(this._handledType) || !Map.Entry.class.isAssignableFrom(this._handledType))) {
                JavaType mapEntryType = this._beanType.findSuperType(Map.Entry.class);
                JavaType kt = mapEntryType.containedTypeOrUnknown(0);
                JavaType vt = mapEntryType.containedTypeOrUnknown(1);
                MapEntrySerializer ser3 = new MapEntrySerializer(this._beanType, kt, vt, false, null, property);
                return ctxt.handlePrimaryContextualization(ser3, property);
            }
        }
        ObjectIdWriter oiw = this._objectIdWriter;
        int idPropOrigIndex = 0;
        Set<String> ignoredProps = null;
        Set<String> includedProps = null;
        Object newFilterId = null;
        if (accessor != null) {
            Object filterId;
            ignoredProps = intr.findPropertyIgnoralByName(config, accessor).findIgnoredForSerialization();
            includedProps = intr.findPropertyInclusionByName(config, accessor).getIncluded();
            ObjectIdInfo objectIdInfo = intr.findObjectIdInfo(config, accessor);
            if (objectIdInfo == null) {
                if (oiw != null && (objectIdInfo = intr.findObjectReferenceInfo(config, accessor, null)) != null) {
                    oiw = this._objectIdWriter.withAlwaysAsId(objectIdInfo.getAlwaysAsId());
                }
            } else {
                objectIdInfo = intr.findObjectReferenceInfo(config, accessor, objectIdInfo);
                Class<? extends ObjectIdGenerator<?>> implClass = objectIdInfo.getGeneratorType();
                JavaType type = ctxt.constructType(implClass);
                JavaType idType = ctxt.getTypeFactory().findTypeParameters(type, ObjectIdGenerator.class)[0];
                if (implClass == ObjectIdGenerators.PropertyGenerator.class) {
                    BeanPropertyWriter prop;
                    String propName = objectIdInfo.getPropertyName().getSimpleName();
                    BeanPropertyWriter idProp = null;
                    int i = 0;
                    int len = this._props.length;
                    while (true) {
                        if (i == len) {
                            ctxt.reportBadDefinition(this._beanType, String.format("Invalid Object Id definition for %s: cannot find property with name %s", ClassUtil.getTypeDescription(this._beanType), ClassUtil.name(propName)));
                        }
                        if (propName.equals((prop = this._props[i]).getName())) break;
                        ++i;
                    }
                    idProp = prop;
                    idPropOrigIndex = i;
                    idType = idProp.getType();
                    PropertyBasedObjectIdGenerator gen = new PropertyBasedObjectIdGenerator(objectIdInfo, idProp);
                    oiw = ObjectIdWriter.construct(idType, null, gen, objectIdInfo.getAlwaysAsId());
                } else {
                    ObjectIdGenerator<?> gen = ctxt.objectIdGeneratorInstance(accessor, objectIdInfo);
                    oiw = ObjectIdWriter.construct(idType, objectIdInfo.getPropertyName(), gen, objectIdInfo.getAlwaysAsId());
                }
            }
            if ((filterId = intr.findFilterId(config, accessor)) != null && !filterId.equals(this._propertyFilterId)) {
                newFilterId = filterId;
            }
        }
        BeanSerializerBase contextual = this;
        if (idPropOrigIndex > 0) {
            BeanPropertyWriter[] newFiltered;
            BeanPropertyWriter[] newProps = Arrays.copyOf(this._props, this._props.length);
            BeanPropertyWriter bpw = newProps[idPropOrigIndex];
            System.arraycopy(newProps, 0, newProps, 1, idPropOrigIndex);
            newProps[0] = bpw;
            if (this._filteredProps == null) {
                newFiltered = null;
            } else {
                newFiltered = Arrays.copyOf(this._filteredProps, this._filteredProps.length);
                bpw = newFiltered[idPropOrigIndex];
                System.arraycopy(newFiltered, 0, newFiltered, 1, idPropOrigIndex);
                newFiltered[0] = bpw;
            }
            contextual = contextual.withProperties(newProps, newFiltered);
        }
        if (oiw != null && (oiw = oiw.withSerializer(ser = ctxt.findRootValueSerializer(oiw.idType))) != this._objectIdWriter) {
            contextual = contextual.withObjectIdWriter(oiw);
        }
        if (ignoredProps != null && !ignoredProps.isEmpty() || includedProps != null) {
            contextual = contextual.withByNameInclusion(ignoredProps, includedProps);
        }
        if (newFilterId != null) {
            contextual = contextual.withFilterId(newFilterId);
        }
        if (shape == null) {
            shape = this._serializationShape;
        }
        if (shape == JsonFormat.Shape.ARRAY) {
            return contextual.asArraySerializer();
        }
        return contextual;
    }

    @Override
    public Iterator<PropertyWriter> properties() {
        return Arrays.asList(this._props).iterator();
    }

    public int propertyCount() {
        return this._props.length;
    }

    public boolean hasViewProperties() {
        return this._filteredProps != null;
    }

    public Object getFilterId() {
        return this._propertyFilterId;
    }

    public boolean canCreateArraySerializer() {
        return this._objectIdWriter == null;
    }

    @Override
    public boolean usesObjectId() {
        return this._objectIdWriter != null;
    }

    @Override
    public abstract void serialize(Object var1, JsonGenerator var2, SerializationContext var3) throws JacksonException;

    @Override
    public void serializeWithType(Object bean, JsonGenerator gen, SerializationContext ctxt, TypeSerializer typeSer) throws JacksonException {
        if (this._objectIdWriter != null) {
            this._serializeWithObjectId(bean, gen, ctxt, typeSer);
            return;
        }
        WritableTypeId typeIdDef = this._typeIdDef(typeSer, bean, JsonToken.START_OBJECT);
        typeSer.writeTypePrefix(gen, ctxt, typeIdDef);
        gen.assignCurrentValue(bean);
        if (this._propertyFilterId != null) {
            this._serializePropertiesFiltered(bean, gen, ctxt, this._propertyFilterId);
        } else {
            this._serializeProperties(bean, gen, ctxt);
        }
        typeSer.writeTypeSuffix(gen, ctxt, typeIdDef);
    }

    protected final void _serializeWithObjectId(Object bean, JsonGenerator g, SerializationContext provider, boolean startEndObject) throws JacksonException {
        ObjectIdWriter w = this._objectIdWriter;
        WritableObjectId objectId = provider.findObjectId(bean, w.generator);
        if (objectId.writeAsReference(g, provider, w)) {
            return;
        }
        Object id = objectId.generateId(bean);
        if (w.alwaysAsId) {
            w.serializer.serialize(id, g, provider);
            return;
        }
        if (startEndObject) {
            g.writeStartObject(bean);
        }
        objectId.writeAsDeclaration(g, provider, w);
        if (this._propertyFilterId != null) {
            this._serializePropertiesFiltered(bean, g, provider, this._propertyFilterId);
        } else {
            this._serializeProperties(bean, g, provider);
        }
        if (startEndObject) {
            g.writeEndObject();
        }
    }

    protected final void _serializeWithObjectId(Object bean, JsonGenerator g, SerializationContext provider, TypeSerializer typeSer) throws JacksonException {
        g.assignCurrentValue(bean);
        ObjectIdWriter w = this._objectIdWriter;
        WritableObjectId objectId = provider.findObjectId(bean, w.generator);
        if (objectId.writeAsReference(g, provider, w)) {
            return;
        }
        Object id = objectId.generateId(bean);
        if (w.alwaysAsId) {
            w.serializer.serialize(id, g, provider);
            return;
        }
        this._serializeObjectId(bean, g, provider, typeSer, objectId);
    }

    protected void _serializeObjectId(Object bean, JsonGenerator g, SerializationContext ctxt, TypeSerializer typeSer, WritableObjectId objectId) throws JacksonException {
        ObjectIdWriter w = this._objectIdWriter;
        WritableTypeId typeIdDef = this._typeIdDef(typeSer, bean, JsonToken.START_OBJECT);
        typeSer.writeTypePrefix(g, ctxt, typeIdDef);
        objectId.writeAsDeclaration(g, ctxt, w);
        if (this._propertyFilterId != null) {
            this._serializePropertiesFiltered(bean, g, ctxt, this._propertyFilterId);
        } else {
            this._serializeProperties(bean, g, ctxt);
        }
        typeSer.writeTypeSuffix(g, ctxt, typeIdDef);
    }

    protected final WritableTypeId _typeIdDef(TypeSerializer typeSer, Object bean, JsonToken valueShape) {
        if (this._typeId == null) {
            return typeSer.typeId(bean, valueShape);
        }
        Object typeId = this._typeId.getValue(bean);
        if (typeId == null) {
            typeId = "";
        }
        return typeSer.typeId(bean, valueShape, typeId);
    }

    protected void _serializePropertiesNoView(Object bean, JsonGenerator gen, SerializationContext provider, BeanPropertyWriter[] props) throws JacksonException {
        int i = 0;
        int left = props.length;
        BeanPropertyWriter prop = null;
        try {
            if (left > 3) {
                do {
                    prop = props[i];
                    prop.serializeAsProperty(bean, gen, provider);
                    prop = props[i + 1];
                    prop.serializeAsProperty(bean, gen, provider);
                    prop = props[i + 2];
                    prop.serializeAsProperty(bean, gen, provider);
                    prop = props[i + 3];
                    prop.serializeAsProperty(bean, gen, provider);
                    i += 4;
                } while ((left -= 4) > 3);
            }
            switch (left) {
                case 3: {
                    prop = props[i++];
                    prop.serializeAsProperty(bean, gen, provider);
                }
                case 2: {
                    prop = props[i++];
                    prop.serializeAsProperty(bean, gen, provider);
                }
                case 1: {
                    prop = props[i++];
                    prop.serializeAsProperty(bean, gen, provider);
                }
            }
        }
        catch (Exception e) {
            String name = prop == null ? "[anySetter]" : prop.getName();
            this.wrapAndThrow(provider, (Throwable)e, bean, name);
        }
        catch (StackOverflowError e) {
            String name = prop == null ? "[anySetter]" : prop.getName();
            throw DatabindException.from(gen, "Infinite recursion (StackOverflowError)", (Throwable)e).prependPath(bean, name);
        }
    }

    protected void _serializePropertiesMaybeView(Object bean, JsonGenerator g, SerializationContext provider, BeanPropertyWriter[] props) throws JacksonException {
        int i = 0;
        int left = props.length;
        BeanPropertyWriter prop = null;
        try {
            if (left > 3) {
                do {
                    if ((prop = props[i]) != null) {
                        prop.serializeAsProperty(bean, g, provider);
                    }
                    if ((prop = props[i + 1]) != null) {
                        prop.serializeAsProperty(bean, g, provider);
                    }
                    if ((prop = props[i + 2]) != null) {
                        prop.serializeAsProperty(bean, g, provider);
                    }
                    if ((prop = props[i + 3]) != null) {
                        prop.serializeAsProperty(bean, g, provider);
                    }
                    i += 4;
                } while ((left -= 4) > 3);
            }
            switch (left) {
                case 3: {
                    prop = props[i++];
                    if (prop != null) {
                        prop.serializeAsProperty(bean, g, provider);
                    }
                }
                case 2: {
                    prop = props[i++];
                    if (prop != null) {
                        prop.serializeAsProperty(bean, g, provider);
                    }
                }
                case 1: {
                    prop = props[i++];
                    if (prop == null) break;
                    prop.serializeAsProperty(bean, g, provider);
                }
            }
        }
        catch (Exception e) {
            String name = prop == null ? "[anySetter]" : prop.getName();
            this.wrapAndThrow(provider, (Throwable)e, bean, name);
        }
        catch (StackOverflowError e) {
            String name = prop == null ? "[anySetter]" : prop.getName();
            throw DatabindException.from(g, "Infinite recursion (StackOverflowError)", (Throwable)e).prependPath(bean, name);
        }
    }

    protected void _serializePropertiesFiltered(Object bean, JsonGenerator g, SerializationContext provider, Object filterId) throws JacksonException {
        int i;
        BeanPropertyWriter[] props;
        PropertyFilter filter = this.findPropertyFilter(provider, filterId, bean);
        if (this._filteredProps != null && provider.getActiveView() != null) {
            props = this._filteredProps;
            if (filter == null) {
                this._serializePropertiesMaybeView(bean, g, provider, props);
                return;
            }
        } else {
            props = this._props;
            if (filter == null) {
                this._serializePropertiesNoView(bean, g, provider, props);
                return;
            }
        }
        try {
            for (BeanPropertyWriter prop : props) {
                if (prop == null) continue;
                filter.serializeAsProperty(bean, g, provider, prop);
            }
        }
        catch (Exception e) {
            String name = i == props.length ? "[anySetter]" : props[i].getName();
            this.wrapAndThrow(provider, (Throwable)e, bean, name);
        }
        catch (StackOverflowError e) {
            String name = i == props.length ? "[anySetter]" : props[i].getName();
            throw DatabindException.from(g, "Infinite recursion (StackOverflowError)", (Throwable)e).prependPath(bean, name);
        }
    }

    protected void _serializeProperties(Object bean, JsonGenerator g, SerializationContext provider) throws JacksonException {
        if (this._filteredProps != null && provider.getActiveView() != null) {
            this._serializePropertiesMaybeView(bean, g, provider, this._filteredProps);
        } else {
            this._serializePropertiesNoView(bean, g, provider, this._props);
        }
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
        if (visitor == null) {
            return;
        }
        JsonObjectFormatVisitor objectVisitor = visitor.expectObjectFormat(typeHint);
        if (objectVisitor == null) {
            return;
        }
        SerializationContext provider = visitor.getContext();
        if (this._propertyFilterId != null) {
            PropertyFilter filter = this.findPropertyFilter(visitor.getContext(), this._propertyFilterId, null);
            int end = this._props.length;
            for (int i = 0; i < end; ++i) {
                filter.depositSchemaProperty(this._props[i], objectVisitor, provider);
            }
        } else {
            Class<?> view = this._filteredProps == null || provider == null ? null : provider.getActiveView();
            for (BeanPropertyWriter prop : view != null ? this._filteredProps : this._props) {
                if (prop == null) continue;
                prop.depositSchemaProperty(objectVisitor, provider);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " for " + this.handledType().getName();
    }
}

