/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.gatekeeper.paper;

import java.io.File;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.logging.Level;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import xyz.lychee.gatekeeper.libs.metrics.bukkit.Metrics;
import xyz.lychee.gatekeeper.paper.PaperCommand;
import xyz.lychee.gatekeeper.paper.PaperListeners;
import xyz.lychee.gatekeeper.shared.Gatekeeper;
import xyz.lychee.gatekeeper.shared.manager.ConfigManager;
import xyz.lychee.gatekeeper.shared.manager.DataManager;
import xyz.lychee.gatekeeper.shared.manager.GeoipManager;
import xyz.lychee.gatekeeper.shared.manager.ModuleManager;
import xyz.lychee.gatekeeper.shared.manager.TaskManager;
import xyz.lychee.gatekeeper.shared.manager.UpdaterManager;
import xyz.lychee.gatekeeper.shared.modules.BlacklistModule;
import xyz.lychee.gatekeeper.shared.objects.AbstractLang;
import xyz.lychee.gatekeeper.shared.objects.CommandPlayer;
import xyz.lychee.gatekeeper.shared.objects.EnumAccess;
import xyz.lychee.gatekeeper.shared.util.AddressUtils;
import xyz.lychee.gatekeeper.shared.util.ColoredLogger;

public class PaperMain
extends JavaPlugin
implements Gatekeeper<Component>,
Listener {
    private final LegacyComponentSerializer serializer = LegacyComponentSerializer.builder().character('&').hexCharacter('#').hexColors().useUnusualXRepeatedCharacterHexFormat().build();
    private ColoredLogger logger;
    private Metrics metrics;
    private AbstractLang<Component> language;

    public void onEnable() {
        this.logger = new ColoredLogger(Bukkit.getLogger());
        try {
            this.metrics = new Metrics((Plugin)this, 27416);
            this.language = new PaperLang(this);
            ConfigManager.INSTANCE.loadConfig(this);
            DataManager.INSTANCE.loadDatabase(this);
            ModuleManager.INSTANCE.loadChecks(this);
            GeoipManager.INSTANCE.loadDatabases(this);
            TaskManager.INSTANCE.loadTasks(this);
            UpdaterManager.INSTANCE.load(this);
            this.language.loadLanguage();
            PluginManager pm = Bukkit.getPluginManager();
            pm.registerEvents((Listener)new PaperListeners(), (Plugin)this);
            PaperCommand commandHandler = new PaperCommand(this);
            CommandMap commandMap = Bukkit.getServer().getCommandMap();
            commandMap.register("gatekeeper", (Command)commandHandler);
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to load plugin", e);
        }
    }

    public void onDisable() {
        if (this.metrics != null) {
            this.metrics.shutdown();
        }
    }

    @Override
    public InputStream resource(String name) {
        return this.getResource(name);
    }

    @Override
    public File dataFolder() {
        return this.getDataFolder();
    }

    @Override
    public ColoredLogger logger() {
        return this.logger;
    }

    @Override
    public String version() {
        return this.getPluginMeta().getVersion();
    }

    @Override
    public AbstractLang<Component> language() {
        return this.language;
    }

    @Override
    public CommandPlayer<Component> commandPlayer(Object player) {
        return new CommandPlayer<Component>(player){

            @Override
            public boolean hasPermission(String permission) {
                if (this.getPlayer() instanceof CommandSender) {
                    return ((CommandSender)this.getPlayer()).hasPermission(permission);
                }
                return false;
            }

            @Override
            public void sendMessage(Component message) {
                if (this.getPlayer() instanceof CommandSender) {
                    ((CommandSender)this.getPlayer()).sendMessage(message);
                }
            }

            @Override
            public void applyChange(String target, EnumAccess newAccess) {
                Player player2;
                BlacklistModule check = ModuleManager.INSTANCE.getCheck(BlacklistModule.class);
                if (!(check.getKickMessage() instanceof Component)) {
                    return;
                }
                Component kickMessage = (Component)check.getKickMessage();
                try {
                    if (AddressUtils.isIpAddress(target)) {
                        InetAddress addr = InetAddress.getByAddress(AddressUtils.parseIp(target));
                        DataManager.INSTANCE.setAccess(AddressUtils.addressToInteger(addr), newAccess);
                        if (newAccess == EnumAccess.BLACKLIST) {
                            Bukkit.getOnlinePlayers().stream().filter(player -> player.getAddress().getAddress().equals(addr)).forEach(player -> player.kick(kickMessage));
                        }
                        return;
                    }
                }
                catch (Exception addr) {
                    // empty catch block
                }
                DataManager.INSTANCE.setAccess(target, newAccess);
                if (newAccess == EnumAccess.BLACKLIST && (player2 = Bukkit.getPlayer((String)target)) != null) {
                    player2.kick(kickMessage);
                }
            }
        };
    }

    public class PaperLang
    extends AbstractLang<Component> {
        public PaperLang(PaperMain gatekeeper) {
            super(gatekeeper);
        }

        @Override
        public Component color(String text, boolean prefix) {
            TextComponent deserialized = PaperMain.this.serializer.deserialize(text);
            if (prefix && ConfigManager.INSTANCE.getPrefix() instanceof ComponentLike) {
                return deserialized.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%prefix%").replacement((ComponentLike)((Component)ConfigManager.INSTANCE.getPrefix())).build());
            }
            return deserialized;
        }
    }
}

