/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.gatekeeper.shared.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import xyz.lychee.gatekeeper.shared.Gatekeeper;
import xyz.lychee.gatekeeper.shared.command.PermissibleCommand;
import xyz.lychee.gatekeeper.shared.command.subcommand.BlacklistCommand;
import xyz.lychee.gatekeeper.shared.command.subcommand.InfoCommand;
import xyz.lychee.gatekeeper.shared.command.subcommand.ReloadCommand;
import xyz.lychee.gatekeeper.shared.command.subcommand.WhitelistCommand;
import xyz.lychee.gatekeeper.shared.objects.AbstractLang;
import xyz.lychee.gatekeeper.shared.objects.CommandPlayer;

public class CommandHandler<T>
extends PermissibleCommand<T> {
    private final Map<String, PermissibleCommand<T>> commandMap = new HashMap<String, PermissibleCommand<T>>();

    public CommandHandler(Gatekeeper<T> gatekeeper) {
        super(gatekeeper, "gatekeeper.command");
        this.commandMap.put("whitelist", new WhitelistCommand<T>(gatekeeper));
        this.commandMap.put("blacklist", new BlacklistCommand<T>(gatekeeper));
        this.commandMap.put("info", new InfoCommand<T>(gatekeeper));
        this.commandMap.put("reload", new ReloadCommand<T>(gatekeeper));
    }

    @Override
    protected void handleExecution(CommandPlayer<T> player, String[] args) {
        AbstractLang lang = this.getGatekeeper().language();
        if (args.length == 0 || !this.commandMap.containsKey(args[0])) {
            player.sendMessage(lang, "messages.main_usage", new String[0]);
            return;
        }
        this.commandMap.get(args[0]).execute(player, Arrays.copyOfRange(args, 1, args.length));
    }

    @Override
    @NotNull
    protected List<String> handleSuggestion(CommandPlayer<T> player, String[] args) {
        if (args.length == 1) {
            ArrayList<String> firstArguments = new ArrayList<String>();
            for (String commandString : this.commandMap.keySet()) {
                if (this.commandMap.get(commandString) != null) {
                    PermissibleCommand<T> cmd = this.commandMap.get(commandString);
                    if (!player.hasPermission(cmd.getPermission())) continue;
                    firstArguments.add(commandString);
                    continue;
                }
                firstArguments.add(commandString);
            }
            return firstArguments;
        }
        if (args.length > 1 && this.commandMap.containsKey(args[0])) {
            return this.commandMap.get(args[0]).suggest(player, Arrays.copyOfRange(args, 1, args.length));
        }
        return Collections.emptyList();
    }
}

