/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.gatekeeper.shared.manager;

import java.net.InetAddress;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import xyz.lychee.gatekeeper.shared.Gatekeeper;
import xyz.lychee.gatekeeper.shared.manager.ConfigManager;
import xyz.lychee.gatekeeper.shared.objects.EnumAccess;
import xyz.lychee.gatekeeper.shared.objects.StoredPlayer;
import xyz.lychee.gatekeeper.shared.util.AddressUtils;

public class DataManager
implements Runnable {
    public static final DataManager INSTANCE = new DataManager();
    private final HashSet<StoredPlayer> players = new HashSet();
    private final HashMap<Integer, HashSet<StoredPlayer>> playersByIp = new HashMap();
    private final HashMap<String, HashSet<StoredPlayer>> playersByName = new HashMap();
    private final HashMap<Integer, Byte> addresses = new HashMap();
    private final HashMap<String, Byte> nicknames = new HashMap();
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private Connection connection;
    private Logger logger;
    private boolean saveAllPlayers = false;

    public void loadDatabase(Gatekeeper<?> gatekeeper) {
        this.logger = gatekeeper.logger();
        this.saveAllPlayers = ConfigManager.INSTANCE.getYaml().getBoolean("save_all_players", (Boolean)false);
        String url = "jdbc:sqlite:" + gatekeeper.dataFolder().toPath().resolve("database.db").toAbsolutePath();
        try {
            Class.forName("org.sqlite.JDBC");
            this.connection = this.setupConnection(url, "CREATE TABLE IF NOT EXISTS players (address INTEGER, nickname TEXT);", "CREATE TABLE IF NOT EXISTS addresses (address INTEGER, access INTEGER DEFAULT 0 CHECK (access IN (-1, 0, 1)), PRIMARY KEY (address));", "CREATE TABLE IF NOT EXISTS nicknames (nickname TEXT, access INTEGER DEFAULT 0 CHECK (access IN (-1, 0, 1)), PRIMARY KEY (nickname));");
            this.connection.setAutoCommit(false);
            this.loadAddresses();
            this.loadNicknames();
            this.loadPlayers();
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, "Failed to load database", ex);
        }
    }

    private Connection setupConnection(String url, String ... commands) throws SQLException {
        Connection conn = DriverManager.getConnection(url);
        for (String cmd : commands) {
            conn.createStatement().executeUpdate(cmd);
        }
        return conn;
    }

    public void loadAddresses() throws SQLException {
        String query = "SELECT address, access FROM `addresses`";
        try (PreparedStatement stmt = this.connection.prepareStatement(query);
             ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                this.addresses.put(rs.getInt("address"), rs.getByte("access"));
            }
        }
    }

    public void loadNicknames() throws SQLException {
        String query = "SELECT nickname, access FROM `nicknames`";
        try (PreparedStatement stmt = this.connection.prepareStatement(query);
             ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                this.nicknames.put(rs.getString("nickname"), rs.getByte("access"));
            }
        }
    }

    public void loadPlayers() throws SQLException {
        String query = "SELECT address, nickname FROM `players`";
        try (PreparedStatement stmt = this.connection.prepareStatement(query);
             ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                this.loadUser(new StoredPlayer(rs.getString("nickname"), rs.getInt("address")));
            }
        }
    }

    public void loadUser(StoredPlayer sp) {
        this.players.add(sp);
        this.playersByIp.computeIfAbsent(sp.getAddress(), k -> new HashSet()).add(sp);
        this.playersByName.computeIfAbsent(sp.getName(), k -> new HashSet()).add(sp);
    }

    public boolean hasAccess(int address, EnumAccess access) {
        return this.addresses.getOrDefault(address, (byte)0).byteValue() == access.getType();
    }

    public boolean hasAccess(String nickname, EnumAccess access) {
        return this.nicknames.getOrDefault(nickname, (byte)0).byteValue() == access.getType();
    }

    public byte getAccess(int access) {
        return this.addresses.getOrDefault(access, (byte)0);
    }

    public byte getAccess(String nickname) {
        return this.nicknames.getOrDefault(nickname, (byte)0);
    }

    public void setAccess(int address, EnumAccess access) {
        this.addresses.put(address, access.getType());
        this.updateAccess(address, access);
    }

    public void setAccess(String nickname, EnumAccess access) {
        this.nicknames.put(nickname, access.getType());
        this.updateAccess(nickname, access);
    }

    public void updatePlayer(StoredPlayer sp) {
        this.executor.execute(() -> {
            String sql = "INSERT INTO players (address, nickname) VALUES (?, ?);";
            try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
                pstmt.setInt(1, sp.getAddress());
                pstmt.setString(2, sp.getName());
                pstmt.executeUpdate();
            }
            catch (SQLException ex) {
                this.logger.log(Level.SEVERE, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas aktualizacji adresu IP", ex);
            }
        });
    }

    public void updateAccess(int ip, EnumAccess access) {
        this.executor.execute(() -> {
            String sql = "INSERT INTO addresses (address, access) VALUES (?, ?) ON CONFLICT(address) DO UPDATE SET access = excluded.access;";
            try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
                pstmt.setInt(1, ip);
                pstmt.setInt(2, access.getType());
                pstmt.executeUpdate();
            }
            catch (SQLException ex) {
                this.logger.log(Level.SEVERE, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas aktualizacji adresu IP", ex);
            }
        });
    }

    public void updateAccess(String nickname, EnumAccess access) {
        this.executor.execute(() -> {
            String sql = "INSERT INTO nicknames (nickname, access) VALUES (?, ?) ON CONFLICT(nickname) DO UPDATE SET access = excluded.access;";
            try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
                pstmt.setString(1, nickname);
                pstmt.setInt(2, access.getType());
                pstmt.executeUpdate();
            }
            catch (SQLException ex) {
                this.logger.log(Level.SEVERE, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas aktualizacji nicku", ex);
            }
        });
    }

    public byte resolveAccess(String target) {
        try {
            if (AddressUtils.isIpAddress(target)) {
                InetAddress addr = InetAddress.getByAddress(AddressUtils.parseIp(target));
                return this.getAccess(AddressUtils.addressToInteger(addr));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getAccess(target);
    }

    @Override
    public void run() {
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.logger.log(Level.SEVERE, "Wyst\u0105pi\u0142 b\u0142\u0105d podczas aktualizacji bazy danych", ex);
        }
    }

    @Generated
    public HashSet<StoredPlayer> getPlayers() {
        return this.players;
    }

    @Generated
    public HashMap<Integer, HashSet<StoredPlayer>> getPlayersByIp() {
        return this.playersByIp;
    }

    @Generated
    public HashMap<String, HashSet<StoredPlayer>> getPlayersByName() {
        return this.playersByName;
    }

    @Generated
    public HashMap<Integer, Byte> getAddresses() {
        return this.addresses;
    }

    @Generated
    public HashMap<String, Byte> getNicknames() {
        return this.nicknames;
    }

    @Generated
    public ExecutorService getExecutor() {
        return this.executor;
    }

    @Generated
    public Connection getConnection() {
        return this.connection;
    }

    @Generated
    public Logger getLogger() {
        return this.logger;
    }

    @Generated
    public boolean isSaveAllPlayers() {
        return this.saveAllPlayers;
    }
}

