/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.gatekeeper.shared.manager;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import xyz.lychee.gatekeeper.shared.Gatekeeper;
import xyz.lychee.gatekeeper.shared.util.BinaryGeoIPDatabase;

public class GeoipManager
implements Runnable {
    public static final GeoipManager INSTANCE = new GeoipManager();
    private final Map<Integer, String> countryCache = new ConcurrentHashMap<Integer, String>();
    private final Map<Integer, Integer> asnCache = new ConcurrentHashMap<Integer, Integer>();
    private BinaryGeoIPDatabase database;
    private Gatekeeper<?> gatekeeper;
    private Set<BinaryGeoIPDatabase.GeoRange<String>> countryRangeCache = Collections.emptySet();
    private Set<BinaryGeoIPDatabase.GeoRange<Integer>> asnRangeCache = Collections.emptySet();

    public void loadDatabases(Gatekeeper<?> gatekeeper) {
        this.gatekeeper = gatekeeper;
        File dataFile = new File(gatekeeper.dataFolder(), "geodata.lgi");
        try {
            if (this.shouldDownloadDatabase(dataFile)) {
                this.gatekeeper.logger().info("Downloading GeoIP database...");
                this.downloadDatabase(dataFile);
            } else {
                this.gatekeeper.logger().info("Using existing GeoIP database: " + dataFile.getName());
            }
            this.initializeDatabase(dataFile);
            this.cacheAllRanges();
            this.gatekeeper.logger().info("GeoIP database has been loaded successfully!");
        }
        catch (IOException ex) {
            this.gatekeeper.logger().log(Level.SEVERE, "GeoIP files could not be loaded.", ex);
            this.clearCache();
        }
    }

    private boolean shouldDownloadDatabase(File dataFile) {
        long updateIntervalMillis;
        if (!dataFile.exists()) {
            return true;
        }
        long fileAgeInMillis = System.currentTimeMillis() - dataFile.lastModified();
        return fileAgeInMillis > (updateIntervalMillis = 39600000L);
    }

    private void downloadDatabase(File dataFile) throws IOException {
        File parentDir = dataFile.getParentFile();
        if (parentDir != null && !parentDir.exists()) {
            parentDir.mkdirs();
        }
        File tempFile = new File(dataFile.getAbsolutePath() + ".tmp");
        try (InputStream is = URI.create("https://cdn.sakuramc.pl/geodata.lgi").toURL().openStream();
             OutputStream os = Files.newOutputStream(tempFile.toPath(), new OpenOption[0]);){
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = is.read(buffer)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
        }
        if (dataFile.exists()) {
            dataFile.delete();
        }
        if (!tempFile.renameTo(dataFile)) {
            throw new IOException("Failed to replace old database file");
        }
    }

    private void initializeDatabase(File dataFile) throws IOException {
        if (this.database != null) {
            this.close();
        }
        this.database = new BinaryGeoIPDatabase(dataFile.getAbsolutePath());
        this.database.load();
    }

    private void cacheAllRanges() {
        this.clearCache();
        try {
            this.countryRangeCache = this.database.getAllCountryRanges();
            this.asnRangeCache = this.database.getAllASNRanges();
            this.gatekeeper.logger().info("Loaded " + this.countryRangeCache.size() + " country and " + this.asnRangeCache.size() + " asn ranges!");
        }
        catch (Exception ex) {
            this.gatekeeper.logger().log(Level.WARNING, "Failed to load GeoIP ranges", ex);
            this.clearCache();
        }
    }

    @NotNull
    public String getCountryCode(int addressData) {
        String cached = this.countryCache.get(addressData);
        if (cached != null) {
            return cached;
        }
        for (BinaryGeoIPDatabase.GeoRange<String> record : this.countryRangeCache) {
            if (!record.contains(addressData)) continue;
            this.countryCache.put(addressData, record.getValue());
            return record.getValue();
        }
        String unknown = "--";
        this.countryCache.put(addressData, unknown);
        return unknown;
    }

    @NotNull
    public Integer getAsnCode(int addressData) {
        Integer cached = this.asnCache.get(addressData);
        if (cached != null) {
            return cached;
        }
        for (BinaryGeoIPDatabase.GeoRange<Integer> record : this.asnRangeCache) {
            if (!record.contains(addressData)) continue;
            this.asnCache.put(addressData, record.getValue());
            return record.getValue();
        }
        int unknown = -1;
        this.asnCache.put(addressData, unknown);
        return unknown;
    }

    public void clearCache() {
        this.countryCache.clear();
        this.asnCache.clear();
    }

    public void close() {
        this.clearCache();
        if (this.database != null) {
            this.database.close();
        }
    }

    @Override
    public void run() {
        if (this.gatekeeper != null) {
            this.loadDatabases(this.gatekeeper);
        }
    }

    @Generated
    public Map<Integer, String> getCountryCache() {
        return this.countryCache;
    }

    @Generated
    public Map<Integer, Integer> getAsnCache() {
        return this.asnCache;
    }

    @Generated
    public BinaryGeoIPDatabase getDatabase() {
        return this.database;
    }

    @Generated
    public Gatekeeper<?> getGatekeeper() {
        return this.gatekeeper;
    }

    @Generated
    public Set<BinaryGeoIPDatabase.GeoRange<String>> getCountryRangeCache() {
        return this.countryRangeCache;
    }

    @Generated
    public Set<BinaryGeoIPDatabase.GeoRange<Integer>> getAsnRangeCache() {
        return this.asnRangeCache;
    }
}

