/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.gatekeeper.shared.manager;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import lombok.Generated;
import xyz.lychee.gatekeeper.shared.Gatekeeper;
import xyz.lychee.gatekeeper.shared.modules.AccountLimitModule;
import xyz.lychee.gatekeeper.shared.modules.AntiVpnModule;
import xyz.lychee.gatekeeper.shared.modules.AsnFilterModule;
import xyz.lychee.gatekeeper.shared.modules.BlacklistModule;
import xyz.lychee.gatekeeper.shared.modules.CountryFilterModule;
import xyz.lychee.gatekeeper.shared.modules.RateLimitModule;
import xyz.lychee.gatekeeper.shared.objects.AbstractModule;

public class ModuleManager {
    public static ModuleManager INSTANCE = new ModuleManager();
    private final Set<AbstractModule> allChecks = new HashSet<AbstractModule>();
    private final List<AbstractModule> loadedChecks = new ArrayList<AbstractModule>();
    private final HashMap<Class<? extends AbstractModule>, AbstractModule> checksMap = new HashMap();

    public void loadChecks(Gatekeeper<?> gatekeeper) {
        this.register(new AccountLimitModule(gatekeeper), new AsnFilterModule(gatekeeper), new BlacklistModule(gatekeeper), new CountryFilterModule(gatekeeper), new RateLimitModule(gatekeeper), new AntiVpnModule(gatekeeper));
        this.reload();
    }

    public void register(AbstractModule ... checks) {
        this.checksMap.clear();
        this.allChecks.clear();
        for (AbstractModule check : checks) {
            this.checksMap.put(check.getClass(), check);
            this.allChecks.add(check);
        }
    }

    public <T extends AbstractModule> T getCheck(Class<T> clazz) {
        return (T)((AbstractModule)clazz.cast(this.checksMap.get(clazz)));
    }

    public void reload() {
        this.loadedChecks.clear();
        for (AbstractModule check : this.allChecks) {
            try {
                boolean success = check.loadAllConfig();
                if (success) {
                    this.loadedChecks.add(check);
                }
                check.setLoaded(success);
            }
            catch (Exception ex) {
                check.setLoaded(false);
                check.getGatekeeper().logger().log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        this.loadedChecks.sort(Comparator.comparingInt(AbstractModule::getPriority));
    }

    @Generated
    public Set<AbstractModule> getAllChecks() {
        return this.allChecks;
    }

    @Generated
    public List<AbstractModule> getLoadedChecks() {
        return this.loadedChecks;
    }

    @Generated
    public HashMap<Class<? extends AbstractModule>, AbstractModule> getChecksMap() {
        return this.checksMap;
    }
}

