/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.gatekeeper.shared.modules;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.ObjectMapper;
import xyz.lychee.gatekeeper.shared.Gatekeeper;
import xyz.lychee.gatekeeper.shared.manager.GeoipManager;
import xyz.lychee.gatekeeper.shared.objects.AbstractModule;
import xyz.lychee.gatekeeper.shared.util.ConditionSet;

public class AntiVpnModule
extends AbstractModule {
    private final ObjectMapper mapper = new ObjectMapper();
    private final Map<Integer, Boolean> checked = new HashMap<Integer, Boolean>();
    private final AtomicInteger roundRobinIndex = new AtomicInteger(0);
    private final Set<String> whitelist = new HashSet<String>();
    private final List<ConditionSet.Provider> providers = new ArrayList<ConditionSet.Provider>();
    private ExecutorService executor;
    private Semaphore semaphore;
    private int connect_timeout;
    private int read_timeout;
    private int execute_timeout;
    private int mode;

    public AntiVpnModule(Gatekeeper<?> gatekeeper) {
        super(gatekeeper, "AntiVpn");
    }

    @Override
    public boolean handlePreLogin(InetAddress address, String name, int dataAddress) {
        boolean detected;
        Boolean cached;
        if (this.providers.isEmpty()) {
            return false;
        }
        int asn = GeoipManager.INSTANCE.getAsnCode(dataAddress);
        if (asn == -1) {
            asn = dataAddress;
        }
        if ((cached = this.checked.get(asn)) != null) {
            return cached;
        }
        String ip = address.getHostAddress();
        if (this.whitelist.contains(ip)) {
            this.checked.put(asn, Boolean.FALSE);
            return false;
        }
        if (this.mode == 0) {
            detected = this.runMode0(ip);
        } else if (this.mode == 1) {
            detected = this.runMode1(ip);
        } else {
            return false;
        }
        this.checked.put(dataAddress, detected);
        return detected;
    }

    @Override
    public boolean handlePostLogin(InetAddress address, String name, int dataAddress) {
        return false;
    }

    @Override
    public boolean handleDisconnect(InetAddress address, String name, int dataAddress) {
        return false;
    }

    @Override
    public boolean load() throws IOException {
        this.whitelist.clear();
        this.providers.clear();
        if (this.executor != null) {
            this.executor.shutdown();
        }
        int threads = Math.max(1, this.getConfig().getInt("threads"));
        int max_concurrent_checks = Math.max(1, this.getConfig().getInt("max_concurrent_checks"));
        this.connect_timeout = this.getConfig().getInt("connect_timeout");
        this.read_timeout = this.getConfig().getInt("read_timeout");
        this.mode = this.getConfig().getInt("mode");
        this.execute_timeout = Math.max(1000, this.connect_timeout + this.read_timeout);
        this.executor = Executors.newFixedThreadPool(threads);
        this.semaphore = new Semaphore(max_concurrent_checks);
        this.whitelist.addAll(this.getConfig().getStringList("whitelist"));
        this.getConfig().getSection("checks").getKeys().stream().map(key -> this.getConfig().getSection("checks." + key)).filter(section -> section.getBoolean("enabled", (Boolean)false)).forEach(section -> {
            String condStr = section.getString("condition", null);
            String url = section.getString("url", "");
            int priority = section.getInt("priority", (Integer)0);
            List<String> headers = section.getStringList("headers", Collections.emptyList());
            ConditionSet cs = condStr != null ? ConditionSet.compile(condStr) : null;
            this.providers.add(new ConditionSet.Provider(url, priority, headers, cs));
        });
        this.providers.sort(Comparator.comparingInt(ConditionSet.Provider::getPriority));
        return true;
    }

    private boolean runMode0(String ip) {
        int index = this.roundRobinIndex.getAndUpdate(i -> (i + 1) % this.providers.size());
        ConditionSet.Provider provider = this.providers.get(index);
        Future<Boolean> future = this.executor.submit(() -> {
            boolean acquired = false;
            try {
                this.semaphore.acquire();
                acquired = true;
                Boolean bl = provider.matches(this.fetchJson(provider, ip));
                return bl;
            }
            catch (Throwable t) {
                Boolean bl = false;
                return bl;
            }
            finally {
                if (acquired) {
                    this.semaphore.release();
                }
            }
        });
        try {
            return future.get(this.execute_timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            future.cancel(true);
            return false;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (ExecutionException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private boolean runMode1(String ip) {
        ExecutorCompletionService<ProviderResult> ecs = new ExecutorCompletionService<ProviderResult>(this.executor);
        ArrayList<Future<ProviderResult>> futures = new ArrayList<Future<ProviderResult>>(this.providers.size());
        for (ConditionSet.Provider provider : this.providers) {
            Callable<ProviderResult> task = () -> {
                boolean acquired = false;
                try {
                    this.semaphore.acquire();
                    acquired = true;
                    boolean match = provider.matches(this.fetchJson(provider, ip));
                    ProviderResult providerResult = new ProviderResult(provider, match, null);
                    return providerResult;
                }
                catch (Throwable t) {
                    ProviderResult providerResult = new ProviderResult(provider, false, t);
                    return providerResult;
                }
                finally {
                    if (acquired) {
                        this.semaphore.release();
                    }
                }
            };
            futures.add(ecs.submit(task));
        }
        boolean detected = false;
        try {
            for (int remaining = this.providers.size(); remaining > 0; --remaining) {
                Future completed = ecs.poll(this.execute_timeout, TimeUnit.MILLISECONDS);
                if (completed == null) {
                } else {
                    void var7_11;
                    try {
                        ProviderResult providerResult = (ProviderResult)completed.get(0L, TimeUnit.MILLISECONDS);
                        continue;
                    }
                    catch (ExecutionException | TimeoutException e) {
                        ProviderResult providerResult = new ProviderResult(null, false, e);
                    }
                    if (var7_11 == null || !var7_11.matched) continue;
                    detected = true;
                    for (Future future : futures) {
                        if (future.isDone()) continue;
                        future.cancel(true);
                    }
                }
                break;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            for (Future future : futures) {
                if (future.isDone()) continue;
                future.cancel(true);
            }
        }
        return detected;
    }

    private JsonNode fetchJson(ConditionSet.Provider provider, String ip) throws IOException {
        String urlStr = provider.getUrl().replace("%address%", ip);
        HttpURLConnection connection = (HttpURLConnection)URI.create(urlStr).toURL().openConnection();
        connection.setConnectTimeout(this.connect_timeout);
        connection.setReadTimeout(this.read_timeout);
        connection.setRequestMethod("GET");
        if (!provider.getHeaders().isEmpty()) {
            provider.getHeaders().forEach(connection::setRequestProperty);
        }
        try {
            JsonNode jsonNode;
            block10: {
                InputStream inputStream = connection.getInputStream();
                try {
                    jsonNode = this.mapper.readTree(inputStream);
                    if (inputStream == null) break block10;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            return jsonNode;
        }
        finally {
            connection.disconnect();
        }
    }

    private static class ProviderResult {
        final ConditionSet.Provider provider;
        final boolean matched;
        final Throwable error;

        ProviderResult(ConditionSet.Provider provider, boolean matched, Throwable error) {
            this.provider = provider;
            this.matched = matched;
            this.error = error;
        }
    }
}

