/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.gatekeeper.shared.modules;

import java.net.InetAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import xyz.lychee.gatekeeper.shared.Gatekeeper;
import xyz.lychee.gatekeeper.shared.objects.AbstractModule;

public class RateLimitModule
extends AbstractModule
implements Runnable {
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private final ConcurrentHashMap<Integer, Long> ip_connect = new ConcurrentHashMap();
    private ScheduledFuture<?> task;
    private int server_limit;
    private int ip_limit;
    private volatile long server_connect = 0L;

    public RateLimitModule(Gatekeeper<?> gatekeeper) {
        super(gatekeeper, "RateLimit");
    }

    @Override
    public boolean handlePreLogin(InetAddress address, String name, int dataAddress) {
        long now = System.currentTimeMillis();
        if (this.server_connect + (long)this.server_limit > now) {
            return true;
        }
        Long l = this.ip_connect.get(dataAddress);
        return l != null && l + (long)this.ip_limit > now;
    }

    @Override
    public boolean handlePostLogin(InetAddress address, String name, int dataAddress) {
        long now;
        this.server_connect = now = System.currentTimeMillis();
        this.ip_connect.put(dataAddress, now);
        return false;
    }

    @Override
    public boolean handleDisconnect(InetAddress address, String name, int dataAddress) {
        return false;
    }

    @Override
    public boolean load() {
        if (this.task != null) {
            this.task.cancel(true);
        }
        this.server_limit = this.getConfig().getInt("server_limit");
        this.ip_limit = this.getConfig().getInt("ip_limit");
        this.task = this.executor.scheduleAtFixedRate(this, 1L, 1L, TimeUnit.MINUTES);
        return true;
    }

    @Override
    public void run() {
        long removable = System.currentTimeMillis() - (long)this.ip_limit;
        this.ip_connect.values().removeIf(value -> value < removable);
    }

    @Generated
    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    @Generated
    public ConcurrentHashMap<Integer, Long> getIp_connect() {
        return this.ip_connect;
    }

    @Generated
    public ScheduledFuture<?> getTask() {
        return this.task;
    }

    @Generated
    public int getServer_limit() {
        return this.server_limit;
    }

    @Generated
    public int getIp_limit() {
        return this.ip_limit;
    }

    @Generated
    public long getServer_connect() {
        return this.server_connect;
    }
}

