/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.gatekeeper.shared.objects;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;
import xyz.lychee.gatekeeper.libs.yaml.YamlDocument;
import xyz.lychee.gatekeeper.libs.yaml.block.implementation.Section;
import xyz.lychee.gatekeeper.libs.yaml.settings.dumper.DumperSettings;
import xyz.lychee.gatekeeper.libs.yaml.settings.general.GeneralSettings;
import xyz.lychee.gatekeeper.libs.yaml.settings.loader.LoaderSettings;
import xyz.lychee.gatekeeper.shared.Gatekeeper;

public abstract class AbstractLang<T> {
    private final Gatekeeper<T> gatekeeper;
    private final HashMap<String, T> components = new HashMap();
    private YamlDocument yaml;

    public AbstractLang(Gatekeeper<T> gatekeeper) {
        this.gatekeeper = gatekeeper;
    }

    public void loadLanguage() {
        try {
            this.yaml = YamlDocument.create(new File(this.gatekeeper.dataFolder(), "lang.yml"), this.gatekeeper.resource("lang.yml"), GeneralSettings.DEFAULT, LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT);
            this.yaml.save();
            HashSet<String> keys = new HashSet<String>();
            this.collect(this.yaml, "", keys);
            for (String key : keys) {
                String text = this.yaml.isList(key) ? String.join((CharSequence)"\n", this.yaml.getStringList(key)) : this.yaml.getString(key);
                this.components.put(key, this.color(text, true));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void collect(Section section, String prefix, Collection<String> out) {
        for (Object keyObj : section.getKeys()) {
            String route;
            String key = keyObj.toString();
            String string = route = prefix.isEmpty() ? key : prefix + "." + key;
            if (section.isSection(key)) {
                Section child = section.getSection(key);
                this.collect(child, route, out);
                continue;
            }
            out.add(route);
        }
    }

    public abstract T color(String var1, boolean var2);

    public T message(String key, String ... placeholders) {
        if (placeholders != null && placeholders.length > 0) {
            String message = this.getString(key);
            if (message == null) {
                return null;
            }
            for (String placeholder : placeholders) {
                message = message.replaceFirst("\\{}", placeholder);
            }
            return this.color(message, true);
        }
        return this.components.get(key);
    }

    @Nullable
    public T getComponent(String key) {
        return this.components.get(key);
    }

    @Nullable
    public String getString(String key) {
        return this.yaml.getString(key);
    }

    @Generated
    public Gatekeeper<T> getGatekeeper() {
        return this.gatekeeper;
    }

    @Generated
    public HashMap<String, T> getComponents() {
        return this.components;
    }

    @Generated
    public YamlDocument getYaml() {
        return this.yaml;
    }
}

