/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.gatekeeper.shared.objects;

import java.io.File;
import java.net.InetAddress;
import java.util.Collections;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;
import xyz.lychee.gatekeeper.libs.yaml.YamlDocument;
import xyz.lychee.gatekeeper.libs.yaml.block.implementation.Section;
import xyz.lychee.gatekeeper.libs.yaml.settings.dumper.DumperSettings;
import xyz.lychee.gatekeeper.libs.yaml.settings.general.GeneralSettings;
import xyz.lychee.gatekeeper.libs.yaml.settings.loader.LoaderSettings;
import xyz.lychee.gatekeeper.shared.Gatekeeper;

public abstract class AbstractModule {
    private final Gatekeeper<?> gatekeeper;
    private final String name;
    private Section config;
    private boolean loaded = false;
    private int priority;
    private Object kickMessage;
    @Nullable
    private String logMessage;

    public AbstractModule(Gatekeeper<?> gatekeeper, String name) {
        this.gatekeeper = gatekeeper;
        this.name = name;
    }

    public abstract boolean handlePreLogin(InetAddress var1, String var2, int var3);

    public abstract boolean handlePostLogin(InetAddress var1, String var2, int var3);

    public abstract boolean handleDisconnect(InetAddress var1, String var2, int var3);

    public void printCheck(InetAddress address, String name) {
        if (this.logMessage != null) {
            this.gatekeeper.logger().info(this.logMessage.replace("%name%", name).replace("%address%", address.getHostAddress()));
        }
    }

    public boolean loadAllConfig() throws Exception {
        String resourcePath = "modules/" + this.name + ".yml";
        File configFile = new File(this.gatekeeper.dataFolder(), resourcePath);
        YamlDocument yaml = YamlDocument.create(configFile, this.gatekeeper.resource(resourcePath), GeneralSettings.DEFAULT, LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT);
        yaml.save();
        if (!yaml.getBoolean("enabled").booleanValue()) {
            return false;
        }
        this.config = yaml.getSection("values");
        this.priority = yaml.getInt("priority");
        String log = yaml.getString("log", "");
        this.logMessage = log.isEmpty() ? null : log;
        String kick = String.join((CharSequence)"\n", yaml.getStringList("kick", Collections.emptyList()));
        this.kickMessage = this.gatekeeper.language().color(kick, true);
        return this.load();
    }

    public abstract boolean load() throws Exception;

    @Generated
    public void setConfig(Section config) {
        this.config = config;
    }

    @Generated
    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    @Generated
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Generated
    public void setKickMessage(Object kickMessage) {
        this.kickMessage = kickMessage;
    }

    @Generated
    public void setLogMessage(@Nullable String logMessage) {
        this.logMessage = logMessage;
    }

    @Generated
    public Gatekeeper<?> getGatekeeper() {
        return this.gatekeeper;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Section getConfig() {
        return this.config;
    }

    @Generated
    public boolean isLoaded() {
        return this.loaded;
    }

    @Generated
    public int getPriority() {
        return this.priority;
    }

    @Generated
    public Object getKickMessage() {
        return this.kickMessage;
    }

    @Nullable
    @Generated
    public String getLogMessage() {
        return this.logMessage;
    }
}

