/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.gatekeeper.shared.objects;

import lombok.Generated;
import xyz.lychee.gatekeeper.shared.objects.AbstractLang;
import xyz.lychee.gatekeeper.shared.objects.EnumAccess;

public abstract class CommandPlayer<T> {
    private final Object player;

    public void sendMessage(AbstractLang<T> lang, String key, String ... placeholders) {
        T message;
        if (placeholders != null && placeholders.length > 0) {
            String str = lang.getString(key);
            if (str == null) {
                return;
            }
            for (String placeholder : placeholders) {
                str = str.replaceFirst("\\{}", placeholder);
            }
            message = lang.color(str, true);
        } else {
            message = lang.getComponents().get(key);
        }
        if (message == null) {
            throw new NullPointerException("Unknown language key: \"messages.no_permission");
        }
        this.sendMessage(message);
    }

    public abstract boolean hasPermission(String var1);

    public abstract void sendMessage(T var1);

    public abstract void applyChange(String var1, EnumAccess var2);

    @Generated
    public Object getPlayer() {
        return this.player;
    }

    @Generated
    public CommandPlayer(Object player) {
        this.player = player;
    }
}

