/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.gatekeeper.shared.util;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import lombok.Generated;

public class BinaryGeoIPDatabase {
    public static final int UNKNOWN_ASN = -1;
    public static final String UNKNOWN_COUNTRY = "--";
    public static final int MAGIC_NUMBER = 1195724617;
    public static final int VERSION = 1;
    private final String dbFile;
    private ByteBuffer countryBuffer;
    private ByteBuffer asnBuffer;
    private int countryRecordCount;
    private int asnRecordCount;

    public BinaryGeoIPDatabase(String dbFile) {
        this.dbFile = dbFile;
    }

    public void load() throws IOException {
        byte[] data;
        Path path = Paths.get(this.dbFile, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException("Database file not found: " + this.dbFile);
        }
        try (InputStream fileIn = Files.newInputStream(path, new OpenOption[0]);
             GZIPInputStream gzipIn = new GZIPInputStream(fileIn);
             ByteArrayOutputStream out = new ByteArrayOutputStream();){
            int len;
            byte[] buffer = new byte[8192];
            while ((len = gzipIn.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
            data = out.toByteArray();
        }
        ByteBuffer buffer = ByteBuffer.wrap(data);
        int magic = buffer.getInt();
        if (magic != 1195724617) {
            throw new IOException("Invalid database format (wrong magic number)");
        }
        int version = buffer.getInt();
        if (version != 1) {
            throw new IOException("Unsupported database version: " + version);
        }
        this.countryRecordCount = buffer.getInt();
        this.asnRecordCount = buffer.getInt();
        int countryDataSize = this.countryRecordCount * 10;
        byte[] countryData = new byte[countryDataSize];
        buffer.get(countryData);
        int asnDataSize = this.asnRecordCount * 12;
        byte[] asnData = new byte[asnDataSize];
        buffer.get(asnData);
        this.countryBuffer = ByteBuffer.wrap(countryData).asReadOnlyBuffer();
        this.asnBuffer = ByteBuffer.wrap(asnData).asReadOnlyBuffer();
    }

    private GeoRange<String> getCountryRecord(int index) {
        int pos = index * 10;
        int start = this.countryBuffer.getInt(pos);
        int end = this.countryBuffer.getInt(pos + 4);
        char[] countryChars = new char[]{(char)this.countryBuffer.get(pos + 8), (char)this.countryBuffer.get(pos + 9)};
        String countryCode = new String(countryChars);
        return new GeoRange<String>(start, end, countryCode);
    }

    private GeoRange<Integer> getASNRecord(int index) {
        int pos = index * 12;
        int start = this.asnBuffer.getInt(pos);
        int end = this.asnBuffer.getInt(pos + 4);
        int asn = this.asnBuffer.getInt(pos + 8);
        return new GeoRange<Integer>(start, end, asn);
    }

    public Set<GeoRange<String>> getAllCountryRanges() {
        HashSet<GeoRange<String>> ranges = new HashSet<GeoRange<String>>(this.countryRecordCount);
        for (int i = 0; i < this.countryRecordCount; ++i) {
            ranges.add(this.getCountryRecord(i));
        }
        return ranges;
    }

    public Set<GeoRange<Integer>> getAllASNRanges() {
        HashSet<GeoRange<Integer>> ranges = new HashSet<GeoRange<Integer>>(this.asnRecordCount);
        for (int i = 0; i < this.asnRecordCount; ++i) {
            ranges.add(this.getASNRecord(i));
        }
        return ranges;
    }

    public void close() {
        this.countryBuffer = null;
        this.asnBuffer = null;
    }

    @Generated
    public String getDbFile() {
        return this.dbFile;
    }

    @Generated
    public ByteBuffer getCountryBuffer() {
        return this.countryBuffer;
    }

    @Generated
    public ByteBuffer getAsnBuffer() {
        return this.asnBuffer;
    }

    @Generated
    public int getCountryRecordCount() {
        return this.countryRecordCount;
    }

    @Generated
    public int getAsnRecordCount() {
        return this.asnRecordCount;
    }

    public static class GeoRange<T> {
        private final int start;
        private final int end;
        private final T value;

        public boolean contains(int ipNum) {
            return Integer.compareUnsigned(ipNum, this.start) >= 0 && Integer.compareUnsigned(ipNum, this.end) <= 0;
        }

        @Generated
        public int getStart() {
            return this.start;
        }

        @Generated
        public int getEnd() {
            return this.end;
        }

        @Generated
        public T getValue() {
            return this.value;
        }

        @Generated
        public GeoRange(int start, int end, T value) {
            this.start = start;
            this.end = end;
            this.value = value;
        }
    }
}

