/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.introspect;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import tools.jackson.core.util.Snapshottable;
import tools.jackson.databind.introspect.MixInResolver;
import tools.jackson.databind.type.ClassKey;

public class MixInHandler
implements MixInResolver,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final MixInResolver _overrides;
    protected Map<ClassKey, Class<?>> _localMixIns;

    public MixInHandler(MixInResolver overrides) {
        this._overrides = overrides;
    }

    protected MixInHandler(MixInResolver overrides, Map<ClassKey, Class<?>> mixins) {
        this._overrides = overrides;
        this._localMixIns = mixins;
    }

    public MixInHandler withOverrides(MixInResolver overrides) {
        return new MixInHandler(overrides, this._localMixIns);
    }

    public MixInHandler withoutLocalDefinitions() {
        return new MixInHandler(this._overrides, null);
    }

    public MixInHandler addLocalDefinitions(Map<Class<?>, Class<?>> sourceMixins) {
        if (!sourceMixins.isEmpty()) {
            if (this._localMixIns == null) {
                this._localMixIns = new HashMap(sourceMixins.size());
            }
            for (Map.Entry<Class<?>, Class<?>> en : sourceMixins.entrySet()) {
                this._localMixIns.put(new ClassKey(en.getKey()), en.getValue());
            }
        }
        return this;
    }

    public MixInHandler addLocalDefinition(Class<?> target, Class<?> mixinSource) {
        if (this._localMixIns == null) {
            this._localMixIns = new HashMap();
        }
        this._localMixIns.put(new ClassKey(target), mixinSource);
        return this;
    }

    public MixInHandler clearLocalDefinitions(Map<Class<?>, Class<?>> sourceMixins) {
        this._localMixIns = null;
        return this;
    }

    @Override
    public MixInHandler snapshot() {
        MixInResolver overrides = Snapshottable.takeSnapshot(this._overrides);
        HashMap mixIns = this._localMixIns == null ? null : new HashMap(this._localMixIns);
        return new MixInHandler(overrides, mixIns);
    }

    @Override
    public Class<?> findMixInClassFor(Class<?> cls) {
        Class<?> mixin;
        Class<?> clazz = mixin = this._overrides == null ? null : this._overrides.findMixInClassFor(cls);
        if (mixin == null && this._localMixIns != null) {
            mixin = this._localMixIns.get(new ClassKey(cls));
        }
        return mixin;
    }

    @Override
    public boolean hasMixIns() {
        return this._localMixIns != null || this._overrides != null && this._overrides.hasMixIns();
    }

    public int localSize() {
        return this._localMixIns == null ? 0 : this._localMixIns.size();
    }
}

