/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Collection;
import java.util.Objects;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.DatabindContext;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.MapperFeature;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.introspect.AnnotatedClass;
import tools.jackson.databind.introspect.AnnotatedClassResolver;
import tools.jackson.databind.jsontype.NamedType;
import tools.jackson.databind.jsontype.PolymorphicTypeValidator;
import tools.jackson.databind.jsontype.TypeDeserializer;
import tools.jackson.databind.jsontype.TypeIdResolver;
import tools.jackson.databind.jsontype.TypeResolverBuilder;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.jsontype.impl.AsArrayTypeDeserializer;
import tools.jackson.databind.jsontype.impl.AsArrayTypeSerializer;
import tools.jackson.databind.jsontype.impl.AsDeductionTypeDeserializer;
import tools.jackson.databind.jsontype.impl.AsDeductionTypeSerializer;
import tools.jackson.databind.jsontype.impl.AsExistingPropertyTypeSerializer;
import tools.jackson.databind.jsontype.impl.AsExternalTypeDeserializer;
import tools.jackson.databind.jsontype.impl.AsExternalTypeSerializer;
import tools.jackson.databind.jsontype.impl.AsPropertyTypeDeserializer;
import tools.jackson.databind.jsontype.impl.AsPropertyTypeSerializer;
import tools.jackson.databind.jsontype.impl.AsWrapperTypeDeserializer;
import tools.jackson.databind.jsontype.impl.AsWrapperTypeSerializer;
import tools.jackson.databind.jsontype.impl.ClassNameIdResolver;
import tools.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import tools.jackson.databind.jsontype.impl.MinimalClassNameIdResolver;
import tools.jackson.databind.jsontype.impl.SimpleNameIdResolver;
import tools.jackson.databind.jsontype.impl.TypeNameIdResolver;
import tools.jackson.databind.util.ClassUtil;

public class StdTypeResolverBuilder
implements TypeResolverBuilder<StdTypeResolverBuilder> {
    protected JsonTypeInfo.Id _idType;
    protected JsonTypeInfo.As _includeAs;
    protected String _typeProperty;
    protected boolean _typeIdVisible = false;
    protected Boolean _requireTypeIdForSubtypes;
    protected Class<?> _defaultImpl;
    protected TypeIdResolver _customIdResolver;

    public StdTypeResolverBuilder() {
    }

    public StdTypeResolverBuilder(JsonTypeInfo.Value settings) {
        if (settings != null) {
            this.withSettings(settings);
        }
    }

    public StdTypeResolverBuilder(JsonTypeInfo.Id idType, JsonTypeInfo.As idAs, String propName) {
        if (idType == null) {
            throw new IllegalArgumentException("idType cannot be null");
        }
        this._idType = idType;
        this._includeAs = idAs;
        this._typeProperty = this._propName(propName, this._idType);
    }

    protected StdTypeResolverBuilder(StdTypeResolverBuilder base, Class<?> defaultImpl) {
        this._idType = base._idType;
        this._includeAs = base._includeAs;
        this._typeProperty = base._typeProperty;
        this._typeIdVisible = base._typeIdVisible;
        this._customIdResolver = base._customIdResolver;
        this._defaultImpl = defaultImpl;
        this._requireTypeIdForSubtypes = base._requireTypeIdForSubtypes;
    }

    public static StdTypeResolverBuilder noTypeInfoBuilder() {
        return new StdTypeResolverBuilder(JsonTypeInfo.Id.NONE, null, null);
    }

    @Override
    public TypeSerializer buildTypeSerializer(SerializationContext ctxt, JavaType baseType, Collection<NamedType> subtypes) {
        if (this._idType == JsonTypeInfo.Id.NONE) {
            return null;
        }
        if (baseType.isPrimitive() && !this.allowPrimitiveTypes(ctxt, baseType)) {
            return null;
        }
        if (this._idType == JsonTypeInfo.Id.DEDUCTION) {
            return AsDeductionTypeSerializer.instance();
        }
        TypeIdResolver idRes = this.idResolver(ctxt, baseType, this.subTypeValidator(ctxt), subtypes, true, false);
        switch (this._includeAs) {
            case WRAPPER_ARRAY: {
                return new AsArrayTypeSerializer(idRes, null);
            }
            case PROPERTY: {
                return new AsPropertyTypeSerializer(idRes, null, this._typeProperty);
            }
            case WRAPPER_OBJECT: {
                return new AsWrapperTypeSerializer(idRes, null);
            }
            case EXTERNAL_PROPERTY: {
                return new AsExternalTypeSerializer(idRes, null, this._typeProperty);
            }
            case EXISTING_PROPERTY: {
                return new AsExistingPropertyTypeSerializer(idRes, null, this._typeProperty);
            }
        }
        throw new IllegalStateException("Do not know how to construct standard type serializer for inclusion type: " + String.valueOf((Object)this._includeAs));
    }

    @Override
    public TypeDeserializer buildTypeDeserializer(DeserializationContext ctxt, JavaType baseType, Collection<NamedType> subtypes) {
        if (this._idType == JsonTypeInfo.Id.NONE) {
            return null;
        }
        if (baseType.isPrimitive() && !this.allowPrimitiveTypes(ctxt, baseType)) {
            return null;
        }
        PolymorphicTypeValidator subTypeValidator = this.verifyBaseTypeValidity(ctxt, baseType);
        TypeIdResolver idRes = this.idResolver(ctxt, baseType, subTypeValidator, subtypes, false, true);
        JavaType defaultImpl = this.defineDefaultImpl(ctxt, baseType);
        if (this._idType == JsonTypeInfo.Id.DEDUCTION) {
            return new AsDeductionTypeDeserializer(ctxt, baseType, idRes, defaultImpl, subtypes);
        }
        switch (this._includeAs) {
            case WRAPPER_ARRAY: {
                return new AsArrayTypeDeserializer(baseType, idRes, this._typeProperty, this._typeIdVisible, defaultImpl);
            }
            case PROPERTY: 
            case EXISTING_PROPERTY: {
                return new AsPropertyTypeDeserializer(baseType, idRes, this._typeProperty, this._typeIdVisible, defaultImpl, this._includeAs, this._strictTypeIdHandling(ctxt, baseType));
            }
            case WRAPPER_OBJECT: {
                return new AsWrapperTypeDeserializer(baseType, idRes, this._typeProperty, this._typeIdVisible, defaultImpl);
            }
            case EXTERNAL_PROPERTY: {
                return new AsExternalTypeDeserializer(baseType, idRes, this._typeProperty, this._typeIdVisible, defaultImpl);
            }
        }
        throw new IllegalStateException("Do not know how to construct standard type serializer for inclusion type: " + String.valueOf((Object)this._includeAs));
    }

    protected JavaType defineDefaultImpl(DatabindContext ctxt, JavaType baseType) {
        if (this._defaultImpl != null) {
            if (this._defaultImpl == Void.class) {
                return ctxt.getTypeFactory().constructType(this._defaultImpl);
            }
            if (baseType.hasRawClass(this._defaultImpl)) {
                return baseType;
            }
            if (baseType.isTypeOrSuperTypeOf(this._defaultImpl)) {
                return ctxt.getTypeFactory().constructSpecializedType(baseType, this._defaultImpl);
            }
            if (baseType.hasRawClass(this._defaultImpl)) {
                return baseType;
            }
        }
        if (ctxt.isEnabled(MapperFeature.USE_BASE_TYPE_AS_DEFAULT_IMPL) && !baseType.isAbstract()) {
            return baseType;
        }
        return null;
    }

    @Override
    public StdTypeResolverBuilder init(JsonTypeInfo.Value settings, TypeIdResolver idRes) {
        this._customIdResolver = idRes;
        if (settings != null) {
            this.withSettings(settings);
        }
        return this;
    }

    @Override
    public StdTypeResolverBuilder withDefaultImpl(Class<?> defaultImpl) {
        if (this._defaultImpl == defaultImpl) {
            return this;
        }
        ClassUtil.verifyMustOverride(StdTypeResolverBuilder.class, this, "withDefaultImpl");
        return new StdTypeResolverBuilder(this, defaultImpl);
    }

    @Override
    public StdTypeResolverBuilder withSettings(JsonTypeInfo.Value settings) {
        this._idType = Objects.requireNonNull(settings.getIdType());
        this._includeAs = settings.getInclusionType();
        this._typeProperty = this._propName(settings.getPropertyName(), this._idType);
        this._defaultImpl = settings.getDefaultImpl();
        this._typeIdVisible = settings.getIdVisible();
        this._requireTypeIdForSubtypes = settings.getRequireTypeIdForSubtypes();
        return this;
    }

    protected String _propName(String propName, JsonTypeInfo.Id idType) {
        if (propName == null || propName.isEmpty()) {
            propName = idType.getDefaultPropertyName();
        }
        return propName;
    }

    @Override
    public Class<?> getDefaultImpl() {
        return this._defaultImpl;
    }

    public String getTypeProperty() {
        return this._typeProperty;
    }

    public boolean isTypeIdVisible() {
        return this._typeIdVisible;
    }

    protected TypeIdResolver idResolver(DatabindContext ctxt, JavaType baseType, PolymorphicTypeValidator subtypeValidator, Collection<NamedType> subtypes, boolean forSer, boolean forDeser) {
        if (this._customIdResolver != null) {
            return this._customIdResolver;
        }
        if (this._idType == null) {
            throw new IllegalStateException("Cannot build, 'init()' not yet called");
        }
        switch (this._idType) {
            case DEDUCTION: 
            case CLASS: {
                return ClassNameIdResolver.construct(baseType, subtypes, subtypeValidator);
            }
            case MINIMAL_CLASS: {
                return MinimalClassNameIdResolver.construct(baseType, subtypes, subtypeValidator);
            }
            case SIMPLE_NAME: {
                return SimpleNameIdResolver.construct(ctxt.getConfig(), baseType, subtypes, forSer, forDeser);
            }
            case NAME: {
                return TypeNameIdResolver.construct(ctxt.getConfig(), baseType, subtypes, forSer, forDeser);
            }
            case NONE: {
                return null;
            }
        }
        throw new IllegalStateException("Do not know how to construct standard type id resolver for idType: " + String.valueOf((Object)this._idType));
    }

    public PolymorphicTypeValidator subTypeValidator(DatabindContext ctxt) {
        return ctxt.getConfig().getPolymorphicTypeValidator();
    }

    protected PolymorphicTypeValidator verifyBaseTypeValidity(DatabindContext ctxt, JavaType baseType) {
        PolymorphicTypeValidator ptv = this.subTypeValidator(ctxt);
        if (this._idType == JsonTypeInfo.Id.CLASS || this._idType == JsonTypeInfo.Id.MINIMAL_CLASS) {
            PolymorphicTypeValidator.Validity validity = ptv.validateBaseType(ctxt, baseType);
            if (validity == PolymorphicTypeValidator.Validity.DENIED) {
                return this.reportInvalidBaseType(ctxt, baseType, ptv);
            }
            if (validity == PolymorphicTypeValidator.Validity.ALLOWED) {
                return LaissezFaireSubTypeValidator.instance;
            }
        }
        return ptv;
    }

    protected PolymorphicTypeValidator reportInvalidBaseType(DatabindContext ctxt, JavaType baseType, PolymorphicTypeValidator ptv) {
        return (PolymorphicTypeValidator)ctxt.reportBadDefinition(baseType, String.format("Configured `PolymorphicTypeValidator` (of type %s) denied resolution of all subtypes of base type %s", ClassUtil.classNameOf(ptv), ClassUtil.classNameOf(baseType.getRawClass())));
    }

    protected boolean allowPrimitiveTypes(DatabindContext ctxt, JavaType baseType) {
        return false;
    }

    protected boolean _strictTypeIdHandling(DatabindContext ctxt, JavaType baseType) {
        if (this._requireTypeIdForSubtypes != null && baseType.isConcrete()) {
            return this._requireTypeIdForSubtypes;
        }
        if (ctxt.isEnabled(MapperFeature.REQUIRE_TYPE_ID_FOR_SUBTYPES)) {
            return true;
        }
        return this._hasTypeResolver(ctxt, baseType);
    }

    protected boolean _hasTypeResolver(DatabindContext ctxt, JavaType baseType) {
        AnnotatedClass ac = AnnotatedClassResolver.resolveWithoutSuperTypes(ctxt.getConfig(), baseType.getRawClass());
        AnnotationIntrospector ai = ctxt.getAnnotationIntrospector();
        return ai.findPolymorphicTypeInfo(ctxt.getConfig(), ac) != null;
    }
}

