/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.node;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.JacksonSerializable;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.ObjectWriter;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.json.JsonMapper;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.BaseJsonNode;
import tools.jackson.databind.node.ObjectNode;
import tools.jackson.databind.node.POJONode;

class InternalNodeSerializer {
    private static final JsonMapper MAPPER = JsonMapper.shared();
    private static final ObjectWriter COMPACT_WRITER = MAPPER.writer();
    private static final ObjectWriter PRETTY_WRITER = MAPPER.writerWithDefaultPrettyPrinter();

    InternalNodeSerializer() {
    }

    private static JacksonSerializable _wrapper(BaseJsonNode root) {
        return new WrapperForSerializer(root);
    }

    public static String toString(BaseJsonNode root) {
        return COMPACT_WRITER.writeValueAsString(InternalNodeSerializer._wrapper(root));
    }

    public static String toPrettyString(BaseJsonNode root) {
        return PRETTY_WRITER.writeValueAsString(InternalNodeSerializer._wrapper(root));
    }

    protected static class WrapperForSerializer
    extends JacksonSerializable.Base {
        protected final BaseJsonNode _root;
        protected SerializationContext _context;

        public WrapperForSerializer(BaseJsonNode root) {
            this._root = root;
        }

        @Override
        public void serialize(JsonGenerator g, SerializationContext ctxt) throws JacksonException {
            this._context = ctxt;
            this._serializeNonRecursive(g, this._root);
        }

        @Override
        public void serializeWithType(JsonGenerator gen, SerializationContext serializers, TypeSerializer typeSer) throws JacksonException {
            this.serialize(gen, serializers);
        }

        protected void _serializeNonRecursive(JsonGenerator g, JsonNode node) throws JacksonException {
            if (node instanceof ObjectNode) {
                g.writeStartObject(this, node.size());
                this._serializeNonRecursive(g, new IteratorStack(), node.properties().iterator());
            } else if (node instanceof ArrayNode) {
                g.writeStartArray(this, node.size());
                this._serializeNonRecursive(g, new IteratorStack(), node.iterator());
            } else {
                node.serialize(g, this._context);
            }
        }

        protected void _serializeNonRecursive(JsonGenerator g, IteratorStack stack, Iterator<?> rootIterator) throws JacksonException {
            Iterator<Object> currIt = rootIterator;
            while (true) {
                if (currIt.hasNext()) {
                    JsonNode value;
                    Object elem = currIt.next();
                    if (elem instanceof Map.Entry) {
                        Map.Entry en = (Map.Entry)elem;
                        g.writeName((String)en.getKey());
                        value = (JsonNode)en.getValue();
                    } else {
                        value = (JsonNode)elem;
                    }
                    if (value instanceof ObjectNode) {
                        stack.push(currIt);
                        currIt = value.properties().iterator();
                        g.writeStartObject(value, value.size());
                        continue;
                    }
                    if (value instanceof ArrayNode) {
                        stack.push(currIt);
                        currIt = value.iterator();
                        g.writeStartArray(value, value.size());
                        continue;
                    }
                    if (value instanceof POJONode) {
                        try {
                            value.serialize(g, this._context);
                        }
                        catch (JacksonException e) {
                            g.writeString(String.format("[ERROR: (%s) %s]", e.getClass().getName(), e.getMessage()));
                        }
                        continue;
                    }
                    value.serialize(g, this._context);
                    continue;
                }
                if (g.streamWriteContext().inArray()) {
                    g.writeEndArray();
                } else {
                    g.writeEndObject();
                }
                if ((currIt = stack.popOrNull()) == null) break;
            }
        }
    }

    static final class IteratorStack {
        private Iterator<?>[] _stack;
        private int _top;
        private int _end;

        public void push(Iterator<?> it) {
            if (this._top < this._end) {
                this._stack[this._top++] = it;
                return;
            }
            if (this._stack == null) {
                this._end = 10;
                this._stack = new Iterator[this._end];
            } else {
                this._end += Math.min(4000, Math.max(20, this._end >> 1));
                this._stack = Arrays.copyOf(this._stack, this._end);
            }
            this._stack[this._top++] = it;
        }

        public Iterator<?> popOrNull() {
            if (this._top == 0) {
                return null;
            }
            return this._stack[--this._top];
        }
    }
}

