/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.gatekeeper.bukkit;

import java.io.File;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import xyz.lychee.gatekeeper.bukkit.BukkitCommand;
import xyz.lychee.gatekeeper.bukkit.BukkitListeners;
import xyz.lychee.gatekeeper.libs.metrics.bukkit.Metrics;
import xyz.lychee.gatekeeper.shared.Gatekeeper;
import xyz.lychee.gatekeeper.shared.checks.BlacklistCheck;
import xyz.lychee.gatekeeper.shared.manager.ChecksManager;
import xyz.lychee.gatekeeper.shared.manager.ConfigManager;
import xyz.lychee.gatekeeper.shared.manager.DataManager;
import xyz.lychee.gatekeeper.shared.manager.GeoipManager;
import xyz.lychee.gatekeeper.shared.manager.TaskManager;
import xyz.lychee.gatekeeper.shared.manager.UpdaterManager;
import xyz.lychee.gatekeeper.shared.objects.AbstractLang;
import xyz.lychee.gatekeeper.shared.objects.CommandPlayer;
import xyz.lychee.gatekeeper.shared.objects.EnumAccess;
import xyz.lychee.gatekeeper.shared.util.AddressUtils;
import xyz.lychee.gatekeeper.shared.util.ColoredLogger;

public class BukkitMain
extends JavaPlugin
implements Gatekeeper<String>,
Listener {
    private ColoredLogger logger;
    private Metrics metrics;
    private AbstractLang<String> language;

    public void onEnable() {
        this.logger = new ColoredLogger(Bukkit.getLogger());
        try {
            this.metrics = new Metrics((Plugin)this, 27416);
            this.language = new BukkitLang(this);
            ConfigManager.INSTANCE.loadConfig(this);
            DataManager.INSTANCE.loadDatabase(this);
            ChecksManager.INSTANCE.loadChecks(this);
            GeoipManager.INSTANCE.loadDatabases(this);
            TaskManager.INSTANCE.loadTasks(this);
            UpdaterManager.INSTANCE.load(this);
            this.language.loadLanguage();
            PluginManager pm = Bukkit.getPluginManager();
            pm.registerEvents((Listener)new BukkitListeners(), (Plugin)this);
            BukkitCommand commandHandler = new BukkitCommand(this);
            PluginCommand command = this.getCommand("gatekeeper");
            command.setExecutor((CommandExecutor)commandHandler);
            command.setTabCompleter((TabCompleter)commandHandler);
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to load plugin", e);
        }
    }

    public void onDisable() {
        if (this.metrics != null) {
            this.metrics.shutdown();
        }
    }

    @Override
    public InputStream resource(String name) {
        return this.getResource(name);
    }

    @Override
    public File dataFolder() {
        return this.getDataFolder();
    }

    @Override
    public ColoredLogger logger() {
        return this.logger;
    }

    @Override
    public String version() {
        return this.getDescription().getVersion();
    }

    @Override
    public AbstractLang<String> language() {
        return this.language;
    }

    @Override
    public CommandPlayer<String> commandPlayer(Object player) {
        return new CommandPlayer<String>(player){

            @Override
            public boolean hasPermission(String permission) {
                if (this.getPlayer() instanceof CommandSender) {
                    return ((CommandSender)this.getPlayer()).hasPermission(permission);
                }
                return false;
            }

            @Override
            public void sendMessage(String message) {
                if (this.getPlayer() instanceof CommandSender) {
                    ((CommandSender)this.getPlayer()).sendMessage(message);
                }
            }

            @Override
            public void applyChange(String target, EnumAccess newAccess) {
                Player player2;
                BlacklistCheck check = ChecksManager.INSTANCE.getCheck(BlacklistCheck.class);
                Object kickMessage = check.getKickMessage();
                try {
                    if (AddressUtils.isIpAddress(target)) {
                        InetAddress addr = InetAddress.getByAddress(AddressUtils.parseIp(target));
                        DataManager.INSTANCE.setAccess(AddressUtils.addressToInteger(addr), newAccess);
                        if (newAccess == EnumAccess.BLACKLIST && kickMessage instanceof String) {
                            String str = (String)kickMessage;
                            Bukkit.getOnlinePlayers().stream().filter(player -> player.getAddress().getAddress().equals(addr)).forEach(player -> player.kickPlayer(str));
                        }
                        return;
                    }
                }
                catch (Exception addr) {
                    // empty catch block
                }
                DataManager.INSTANCE.setAccess(target, newAccess);
                if (newAccess == EnumAccess.BLACKLIST && kickMessage instanceof String && (player2 = Bukkit.getPlayer((String)target)) != null) {
                    player2.kickPlayer((String)kickMessage);
                }
            }
        };
    }

    public static class BukkitLang
    extends AbstractLang<String> {
        private final Pattern hexPattern = Pattern.compile("&#([A-Fa-f0-9]{6})");

        public BukkitLang(BukkitMain gatekeeper) {
            super(gatekeeper);
        }

        @Override
        public String color(String text, boolean prefix) {
            String colored = this.applyColors(text);
            if (prefix && ConfigManager.INSTANCE.getPrefix() instanceof String) {
                return colored.replace("%prefix%", (String)ConfigManager.INSTANCE.getPrefix());
            }
            return colored;
        }

        private String applyColors(String message) {
            Matcher matcher = this.hexPattern.matcher(message);
            StringBuffer buffer = new StringBuffer();
            while (matcher.find()) {
                String hex = matcher.group(1);
                StringBuilder replacement = new StringBuilder("\u00a7x");
                for (char c : hex.toCharArray()) {
                    replacement.append('\u00a7').append(c);
                }
                matcher.appendReplacement(buffer, replacement.toString());
            }
            matcher.appendTail(buffer);
            return ChatColor.translateAlternateColorCodes((char)'&', (String)buffer.toString());
        }
    }
}

