/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.gatekeeper.shared.checks;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import xyz.lychee.gatekeeper.shared.Gatekeeper;
import xyz.lychee.gatekeeper.shared.manager.GeoipManager;
import xyz.lychee.gatekeeper.shared.objects.AbstractCheck;

public class ASNCheck
extends AbstractCheck
implements Runnable {
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private final HashSet<Integer> downloadedAsn = new HashSet();
    private final HashSet<Integer> listedAsn = new HashSet();
    private final HashSet<String> sources = new HashSet();
    private final Path asnPath = this.getGatekeeper().dataFolder().toPath().resolve("asn.txt");
    private Pattern pattern;
    private ScheduledFuture<?> task;
    private boolean list_mode;

    public ASNCheck(Gatekeeper<?> gatekeeper) {
        super(gatekeeper, "AsnBlock");
    }

    @Override
    public boolean check(InetAddress address, String name, int dataAddress) {
        int asn = GeoipManager.INSTANCE.getAsnCode(dataAddress);
        return asn > 0 && (this.downloadedAsn.contains(asn) || this.listedAsn.contains(asn) == this.list_mode);
    }

    @Override
    public boolean load() throws IOException {
        this.downloadedAsn.clear();
        this.listedAsn.clear();
        this.sources.clear();
        if (this.task != null) {
            this.task.cancel(true);
        }
        if (Files.exists(this.asnPath, new LinkOption[0])) {
            Files.readAllLines(this.asnPath).forEach(line -> {
                try {
                    this.downloadedAsn.add(Integer.parseInt(line));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
        }
        long interval = (long)this.getConfig().getInt("auto_update.interval").intValue() * 60L * 60L;
        this.pattern = Pattern.compile(this.getConfig().getString("auto_update.asn_pattern"));
        this.sources.addAll(this.getConfig().getStringList("auto_update.sources"));
        this.task = this.executor.scheduleAtFixedRate(this, 10L, interval, TimeUnit.SECONDS);
        this.listedAsn.addAll(this.getConfig().getIntList("list"));
        this.list_mode = this.getConfig().getBoolean("list_mode");
        return true;
    }

    @Override
    public void run() {
        HashSet<Integer> asns = new HashSet<Integer>();
        HashSet<String> lines = new HashSet<String>();
        for (String source : this.sources) {
            try {
                HttpURLConnection conn = (HttpURLConnection)URI.create(source).toURL().openConnection();
                conn.setRequestMethod("GET");
                conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:90.0) Gecko/20100101 Firefox/90.0");
                try (InputStream is = conn.getInputStream();
                     BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                    String line;
                    StringBuilder sb = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        sb.append(line).append('\n');
                    }
                    String text = sb.toString();
                    Matcher matcher = this.pattern.matcher(text);
                    while (matcher.find()) {
                        try {
                            String g = matcher.group();
                            asns.add(Integer.parseInt(g));
                            lines.add(g);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
                conn.disconnect();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (asns.isEmpty()) {
            return;
        }
        this.downloadedAsn.clear();
        this.downloadedAsn.addAll(asns);
        try {
            Files.write(this.asnPath, lines, new OpenOption[0]);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

