/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.gatekeeper.shared.manager;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;

public class AccountLimitManager {
    public static final AccountLimitManager INSTANCE = new AccountLimitManager();
    private final ConcurrentHashMap<Integer, AtomicInteger> addressesMap = new ConcurrentHashMap();

    public void increment(int dataAddress) {
        this.addressesMap.computeIfAbsent(dataAddress, k -> new AtomicInteger()).incrementAndGet();
    }

    public void decrement(int dataAddress) {
        this.addressesMap.computeIfPresent(dataAddress, (k, ai) -> {
            if (ai.decrementAndGet() <= 0) {
                return null;
            }
            return ai;
        });
    }

    public int numOfConnections(int dataAddress) {
        AtomicInteger val = this.addressesMap.get(dataAddress);
        return val == null ? 0 : val.get();
    }

    @Generated
    public ConcurrentHashMap<Integer, AtomicInteger> getAddressesMap() {
        return this.addressesMap;
    }
}

