/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.gatekeeper.shared.manager;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import lombok.Generated;
import xyz.lychee.gatekeeper.shared.Gatekeeper;
import xyz.lychee.gatekeeper.shared.checks.ASNCheck;
import xyz.lychee.gatekeeper.shared.checks.AccountLimitCheck;
import xyz.lychee.gatekeeper.shared.checks.BlacklistCheck;
import xyz.lychee.gatekeeper.shared.checks.CountryBlockCheck;
import xyz.lychee.gatekeeper.shared.checks.NicknameCheck;
import xyz.lychee.gatekeeper.shared.checks.ProxyCheck;
import xyz.lychee.gatekeeper.shared.checks.RateLimitCheck;
import xyz.lychee.gatekeeper.shared.objects.AbstractCheck;
import xyz.lychee.gatekeeper.shared.util.AddressUtils;

public class ChecksManager {
    public static ChecksManager INSTANCE = new ChecksManager();
    private final Set<AbstractCheck> allChecks = new HashSet<AbstractCheck>();
    private final List<AbstractCheck> loadedChecks = new ArrayList<AbstractCheck>();
    private final HashMap<Class<? extends AbstractCheck>, AbstractCheck> checksMap = new HashMap();

    public void loadChecks(Gatekeeper<?> gatekeeper) {
        this.register(new NicknameCheck(gatekeeper), new AccountLimitCheck(gatekeeper), new ASNCheck(gatekeeper), new BlacklistCheck(gatekeeper), new CountryBlockCheck(gatekeeper), new RateLimitCheck(gatekeeper), new ProxyCheck(gatekeeper));
        this.reload();
    }

    public void register(AbstractCheck ... checks) {
        this.checksMap.clear();
        this.allChecks.clear();
        for (AbstractCheck check : checks) {
            this.checksMap.put(check.getClass(), check);
            this.allChecks.add(check);
        }
    }

    public <T extends AbstractCheck> T getCheck(Class<T> clazz) {
        return (T)((AbstractCheck)clazz.cast(this.checksMap.get(clazz)));
    }

    public void reload() {
        this.loadedChecks.clear();
        for (AbstractCheck check : this.allChecks) {
            try {
                boolean success = check.loadAllConfig();
                if (success) {
                    this.loadedChecks.add(check);
                }
                check.setLoaded(success);
            }
            catch (Exception ex) {
                check.setLoaded(false);
                check.getGatekeeper().logger().log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        this.loadedChecks.sort(Comparator.comparingInt(AbstractCheck::getPriority));
    }

    public AbstractCheck checkPlayer(InetAddress address, String name) {
        int dataAddress = AddressUtils.addressToInteger(address);
        for (AbstractCheck ac : this.loadedChecks) {
            if (!ac.check(address, name, dataAddress)) continue;
            return ac;
        }
        return null;
    }

    @Generated
    public Set<AbstractCheck> getAllChecks() {
        return this.allChecks;
    }

    @Generated
    public List<AbstractCheck> getLoadedChecks() {
        return this.loadedChecks;
    }

    @Generated
    public HashMap<Class<? extends AbstractCheck>, AbstractCheck> getChecksMap() {
        return this.checksMap;
    }
}

