/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.gatekeeper.shared.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import sun.misc.Unsafe;

public class ReflectionUtils {
    private static final Unsafe UNSAFE = (Unsafe)ReflectionUtils.get(ReflectionUtils.getField(Unsafe.class, "theUnsafe"));

    private ReflectionUtils() throws IllegalAccessException {
        throw new IllegalAccessException();
    }

    public static boolean exists(String clazz) {
        try {
            Class.forName(clazz);
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    public static Object get(Field field, Object object) {
        try {
            return field.get(object);
        }
        catch (IllegalAccessException ex) {
            return null;
        }
    }

    public static Class<?> getClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    public static Class<?> getClass(String className, String alternativeClass) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ex1) {
            try {
                return Class.forName(alternativeClass);
            }
            catch (ClassNotFoundException ex2) {
                return null;
            }
        }
    }

    public static Method getMethod(Class<?> clazz, String name) {
        try {
            Method method = clazz.getDeclaredMethod(name, new Class[0]);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public static Method getMethod(String className, String name) {
        try {
            return ReflectionUtils.getMethod(Class.forName(className), name);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    public static Field getField(Class<?> clazz, String name) {
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException ex) {
            return null;
        }
    }

    public static Field getField(String className, String name) {
        try {
            return ReflectionUtils.getField(Class.forName(className), name);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    public static Field getFieldRetryClass(String className, String name, String alternativeClass) {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException var7) {
            try {
                clazz = Class.forName(alternativeClass);
            }
            catch (ClassNotFoundException ex) {
                return null;
            }
        }
        return ReflectionUtils.getField(clazz, name);
    }

    public static Field getFieldRetryField(String className, String name, String alternativeName) {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException var8) {
            return null;
        }
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException var7) {
            try {
                Field field = clazz.getDeclaredField(alternativeName);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException var6) {
                return null;
            }
        }
    }

    public static Field searchField(Class<?> clazz, Class<?> searchFor) {
        Class<?> currentClass = clazz;
        while ((currentClass = currentClass.getSuperclass()) != null) {
            for (Field field : currentClass.getDeclaredFields()) {
                if (!searchFor.isAssignableFrom(field.getType())) continue;
                return field;
            }
        }
        return null;
    }

    public static Field searchField(String className, Class<?> searchFor) {
        try {
            return ReflectionUtils.searchField(Class.forName(className), searchFor);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    public static <T> T get(Field field) {
        try {
            return (T)field.get(null);
        }
        catch (IllegalAccessException ex) {
            return null;
        }
    }

    public static void setField(Object object, Field field, Object value) {
        UNSAFE.putObject(object, UNSAFE.objectFieldOffset(field), value);
    }

    public static void setFieldReflect(Object object, Field field, Object value) {
        try {
            field.set(object, value);
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
    }

    public static void invoke(Method method, Object object) {
        try {
            method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            ex.printStackTrace();
        }
    }

    public static Field getField(Class<?> clazz, Class<?> typeClass) {
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            for (Field field : current.getDeclaredFields()) {
                if (!typeClass.isAssignableFrom(field.getType())) continue;
                return field;
            }
        }
        return null;
    }
}

