/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.tweak_api.api.configure;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.loader.api.FabricLoader;

public class JsonConfigManager<T extends ConfigSchema> {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
    public final String modId;
    private final Path configPath;
    private final Class<T> configClass;
    private final List<Consumer<T>> configChangeListeners = new ArrayList<Consumer<T>>();

    public JsonConfigManager(String modId, Class<T> configClass) {
        this.modId = modId;
        this.configClass = configClass;
        this.configPath = FabricLoader.getInstance().getConfigDir().resolve(modId + ".json");
    }

    public T loadConfig() {
        if (!Files.exists(this.configPath, new LinkOption[0])) {
            T defaultConfig = this.createDefaultConfig();
            defaultConfig.onConfigLoaded();
            this.saveConfig(defaultConfig);
            return defaultConfig;
        }
        try {
            String json = Files.readString(this.configPath);
            ConfigSchema config = (ConfigSchema)GSON.fromJson(json, this.configClass);
            if (config != null) {
                config.onConfigLoaded();
                return (T)config;
            }
            return this.createDefaultWithLoaded();
        }
        catch (JsonSyntaxException | IOException e) {
            System.err.println("Failed to load config, using defaults: " + e.getMessage());
            return this.createDefaultWithLoaded();
        }
    }

    private T createDefaultWithLoaded() {
        T defaultConfig = this.createDefaultConfig();
        defaultConfig.onConfigLoaded();
        return defaultConfig;
    }

    public boolean saveConfig(T config) {
        config.onConfigSaving();
        try {
            if (!Files.exists(this.configPath.getParent(), new LinkOption[0])) {
                Files.createDirectories(this.configPath.getParent(), new FileAttribute[0]);
            }
            String json = GSON.toJson(config, this.configClass);
            Files.writeString(this.configPath, (CharSequence)json, new OpenOption[0]);
            this.notifyConfigChangeListeners(config);
            return true;
        }
        catch (IOException e) {
            System.err.println("Failed to save config: " + e.getMessage());
            return false;
        }
    }

    public void registerConfigChangeListener(Consumer<T> listener) {
        this.configChangeListeners.add(listener);
    }

    public void unregisterConfigChangeListener(Consumer<T> listener) {
        this.configChangeListeners.remove(listener);
    }

    private void notifyConfigChangeListeners(T newConfig) {
        for (Consumer<T> listener : this.configChangeListeners) {
            try {
                listener.accept(newConfig);
            }
            catch (Exception e) {
                System.err.println("Error in config change listener: " + e.getMessage());
            }
        }
    }

    public T createDefaultConfig() {
        try {
            return (T)((ConfigSchema)this.configClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create default config instance for: " + this.configClass.getName(), e);
        }
    }

    public Path getConfigPath() {
        return this.configPath;
    }

    public T reloadConfig() {
        T config = this.loadConfig();
        this.notifyConfigChangeListeners(config);
        return config;
    }

    public T resetToDefaults() {
        T defaultConfig = this.createDefaultConfig();
        defaultConfig.onConfigLoaded();
        this.saveConfig(defaultConfig);
        return defaultConfig;
    }

    public boolean configExists() {
        return Files.exists(this.configPath, new LinkOption[0]);
    }

    public boolean deleteConfig() {
        try {
            return Files.deleteIfExists(this.configPath);
        }
        catch (IOException e) {
            System.err.println("Failed to delete config: " + e.getMessage());
            return false;
        }
    }

    public int getListenerCount() {
        return this.configChangeListeners.size();
    }

    public void clearAllListeners() {
        this.configChangeListeners.clear();
    }

    public T getConfig(T defaultValue) {
        try {
            String json = Files.readString(this.configPath);
            ConfigSchema config = (ConfigSchema)GSON.fromJson(json, this.configClass);
            if (config != null) {
                config.onConfigLoaded();
                return (T)config;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    public static boolean isConfigModifiedExternally(Path configPath, long lastKnownModifyTime) {
        try {
            if (!Files.exists(configPath, new LinkOption[0])) {
                return false;
            }
            long currentModifyTime = Files.getLastModifiedTime(configPath, new LinkOption[0]).toMillis();
            return currentModifyTime > lastKnownModifyTime;
        }
        catch (IOException e) {
            System.err.println("Failed to check config modification time: " + e.getMessage());
            return false;
        }
    }

    public T reloadIfModifiedExternally(long lastKnownModifyTime) {
        if (JsonConfigManager.isConfigModifiedExternally(this.configPath, lastKnownModifyTime)) {
            System.out.println("Config file modified externally, reloading...");
            return this.reloadConfig();
        }
        return null;
    }

    public long getConfigLastModifiedTime() {
        try {
            if (Files.exists(this.configPath, new LinkOption[0])) {
                return Files.getLastModifiedTime(this.configPath, new LinkOption[0]).toMillis();
            }
        }
        catch (IOException e) {
            System.err.println("Failed to get config modification time: " + e.getMessage());
        }
        return 0L;
    }

    public static void registerConfigModificationCheck(JsonConfigManager<?> configManager, int checkIntervalTicks) {
        long[] lastModTime = new long[]{configManager.getConfigLastModifiedTime()};
        int[] tickCounter = new int[]{0};
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            tickCounter[0] = tickCounter[0] + 1;
            if (tickCounter[0] >= checkIntervalTicks) {
                tickCounter[0] = 0;
                Object reloadedConfig = configManager.reloadIfModifiedExternally(lastModTime[0]);
                if (reloadedConfig != null) {
                    System.out.println("Config '" + configManager.modId + "' was modified externally and reloaded");
                    lastModTime[0] = configManager.getConfigLastModifiedTime();
                    if (reloadedConfig instanceof ConfigSchema) {
                        ((ConfigSchema)reloadedConfig).onConfigLoaded();
                    }
                }
            }
        });
    }

    public static void registerConfigModificationCheck(JsonConfigManager<?> configManager) {
        JsonConfigManager.registerConfigModificationCheck(configManager, 20);
    }

    public static void registerMultipleConfigModificationCheck(int checkIntervalTicks, JsonConfigManager<?> ... configManagers) {
        long[] lastModTimes = new long[configManagers.length];
        for (int i = 0; i < configManagers.length; ++i) {
            lastModTimes[i] = configManagers[i].getConfigLastModifiedTime();
        }
        int[] tickCounter = new int[]{0};
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            tickCounter[0] = tickCounter[0] + 1;
            if (tickCounter[0] >= checkIntervalTicks) {
                tickCounter[0] = 0;
                for (int i = 0; i < configManagers.length; ++i) {
                    JsonConfigManager manager = configManagers[i];
                    Object reloadedConfig = manager.reloadIfModifiedExternally(lastModTimes[i]);
                    if (reloadedConfig == null) continue;
                    System.out.println("Config '" + manager.modId + "' was modified externally and reloaded");
                    lastModTimes[i] = manager.getConfigLastModifiedTime();
                    if (!(reloadedConfig instanceof ConfigSchema)) continue;
                    ((ConfigSchema)reloadedConfig).onConfigLoaded();
                }
            }
        });
    }

    public static interface ConfigSchema {
        public void onConfigLoaded();

        public void onConfigSaving();
    }

    public static class ConfigOptions
    implements ConfigSchema {
        @Override
        public void onConfigLoaded() {
        }

        @Override
        public void onConfigSaving() {
        }

        public String toString() {
            return "ConfigOptions{}";
        }
    }
}

