/*
 * Decompiled with CFR 0.152.
 */
package ru.stepanyaa.redstoneDetector;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import ru.stepanyaa.redstoneDetector.RedstoneDetector;

public class GuiManager
implements Listener {
    private final RedstoneDetector plugin;
    private final Map<UUID, PlayerGuiState> playerStates = new HashMap<UUID, PlayerGuiState>();

    public GuiManager(RedstoneDetector plugin) {
        this.plugin = plugin;
    }

    public void openWorldSelectionGUI(Player player) {
        String title = this.plugin.getMessage("gui.world_selection_title", "Select a World");
        Inventory gui = Bukkit.createInventory(null, (int)45, (String)title);
        ArrayList worlds = new ArrayList(Bukkit.getWorlds());
        int[] centerSlots = new int[]{12, 13, 14, 21, 22, 23, 30, 31, 32};
        int slotIndex = 0;
        for (World world : worlds) {
            Material icon = this.getWorldIcon(world);
            ItemStack item = new ItemStack(icon);
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(String.valueOf(ChatColor.GREEN) + world.getName());
                String viewChunksText = this.plugin.getMessage("gui.world_view_chunks", "Click to view chunks");
                meta.setLore(Collections.singletonList(String.valueOf(ChatColor.GRAY) + viewChunksText));
                item.setItemMeta(meta);
            }
            if (slotIndex >= centerSlots.length) continue;
            gui.setItem(centerSlots[slotIndex++], item);
        }
        PlayerGuiState state = new PlayerGuiState(GuiState.WORLD_SELECTION);
        this.playerStates.put(player.getUniqueId(), state);
        player.openInventory(gui);
    }

    private Material getWorldIcon(World world) {
        return switch (world.getEnvironment()) {
            case World.Environment.NETHER -> Material.NETHERRACK;
            case World.Environment.THE_END -> Material.END_STONE;
            default -> Material.GRASS_BLOCK;
        };
    }

    public void openChunksGUI(Player player, String worldName, int page) {
        ArrayList<Map.Entry<RedstoneDetector.ChunkCoordinate, RedstoneDetector.ChunkData>> filteredChunks = new ArrayList<Map.Entry<RedstoneDetector.ChunkCoordinate, RedstoneDetector.ChunkData>>();
        long retentionTime = System.currentTimeMillis() - 86400000L;
        for (Map.Entry<RedstoneDetector.ChunkCoordinate, RedstoneDetector.ChunkData> entry : this.plugin.getChunkMap().entrySet()) {
            if (!entry.getKey().world().equals(worldName) || entry.getValue().lastScanned < retentionTime || entry.getValue().redstoneCount.get() <= this.plugin.getMaxRedstone() && entry.getValue().entityCount.get() <= this.plugin.getMaxEntities() || entry.getValue().clearedByAdmin) continue;
            filteredChunks.add(entry);
        }
        filteredChunks.sort((a, b) -> {
            int xCompare = Integer.compare(((RedstoneDetector.ChunkCoordinate)a.getKey()).x(), ((RedstoneDetector.ChunkCoordinate)b.getKey()).x());
            if (xCompare != 0) {
                return xCompare;
            }
            return Integer.compare(((RedstoneDetector.ChunkCoordinate)a.getKey()).z(), ((RedstoneDetector.ChunkCoordinate)b.getKey()).z());
        });
        int totalPages = Math.max(1, (int)Math.ceil((double)filteredChunks.size() / 45.0));
        if (page < 0) {
            page = 0;
        }
        if (page >= totalPages) {
            page = totalPages > 0 ? totalPages - 1 : 0;
        }
        String title = this.plugin.getMessage("gui.chunk_list_title", "Chunks in {world} (Page {page}/{total})").replace("{world}", worldName).replace("{page}", String.valueOf(page + 1)).replace("{total}", String.valueOf(totalPages));
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)title);
        int start = page * 45;
        int end = Math.min(start + 45, filteredChunks.size());
        for (int i = start; i < end; ++i) {
            Map.Entry entry = (Map.Entry)filteredChunks.get(i);
            RedstoneDetector.ChunkCoordinate coord = (RedstoneDetector.ChunkCoordinate)entry.getKey();
            RedstoneDetector.ChunkData data = (RedstoneDetector.ChunkData)entry.getValue();
            ItemStack item = this.createChunkItem(coord, data);
            gui.setItem(i - start, item);
        }
        this.addNavigationButtons(gui, page, totalPages);
        PlayerGuiState state = new PlayerGuiState(GuiState.CHUNK_LIST);
        state.world = worldName;
        state.page = page;
        this.playerStates.put(player.getUniqueId(), state);
        player.openInventory(gui);
    }

    private ItemStack createChunkItem(RedstoneDetector.ChunkCoordinate coord, RedstoneDetector.ChunkData data) {
        ItemStack item = new ItemStack(Material.MAP);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            String chunkName = this.plugin.getMessage("gui.chunk_item_name", "Chunk {coord}").replace("{coord}", coord.toDisplayString());
            meta.setDisplayName(String.valueOf(ChatColor.YELLOW) + chunkName);
            ArrayList<Object> lore = new ArrayList<Object>();
            lore.add(String.valueOf(ChatColor.GRAY) + this.plugin.getMessage("gui.chunk_world", "World: {world}").replace("{world}", coord.world()));
            lore.add(String.valueOf(ChatColor.RED) + this.plugin.getMessage("gui.chunk_redstone", "Redstone: {count}").replace("{count}", String.valueOf(data.redstoneCount.get())));
            lore.add(String.valueOf(ChatColor.GREEN) + this.plugin.getMessage("gui.chunk_entities", "Entities: {count}").replace("{count}", String.valueOf(data.entityCount.get())));
            lore.add(String.valueOf(ChatColor.GRAY) + this.plugin.getMessage("gui.chunk_detected", "Detected: {time}").replace("{time}", this.formatTime(data.lastScanned)));
            lore.add("");
            lore.add(String.valueOf(ChatColor.GOLD) + this.plugin.getMessage("gui.chunk_lclick", "Left-click: Open actions"));
            lore.add(String.valueOf(ChatColor.GOLD) + this.plugin.getMessage("gui.chunk_shift_rclick", "Shift + Right-click: Remove redstone"));
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    private String formatTime(long timestamp) {
        long diff = System.currentTimeMillis() - timestamp;
        long minutes = diff / 60000L;
        long hours = diff / 3600000L;
        if (hours > 0L) {
            return hours + this.plugin.getMessage("gui.time_hours_ago", " hours ago");
        }
        if (minutes > 0L) {
            return minutes + this.plugin.getMessage("gui.time_minutes_ago", " minutes ago");
        }
        return this.plugin.getMessage("gui.time_just_now", "Just now");
    }

    private void addNavigationButtons(Inventory gui, int page, int totalPages) {
        ItemStack back;
        ItemMeta meta;
        if (page > 0) {
            ItemStack prev = new ItemStack(Material.ARROW);
            meta = prev.getItemMeta();
            if (meta != null) {
                String prevText = this.plugin.getMessage("gui.previous_page", "Previous Page");
                meta.setDisplayName(String.valueOf(ChatColor.YELLOW) + prevText);
                prev.setItemMeta(meta);
            }
            gui.setItem(45, prev);
        }
        if (page < totalPages - 1) {
            ItemStack next = new ItemStack(Material.ARROW);
            meta = next.getItemMeta();
            if (meta != null) {
                String nextText = this.plugin.getMessage("gui.next_page", "Next Page");
                meta.setDisplayName(String.valueOf(ChatColor.YELLOW) + nextText);
                next.setItemMeta(meta);
            }
            gui.setItem(53, next);
        }
        if ((meta = (back = new ItemStack(Material.BARRIER)).getItemMeta()) != null) {
            String backText = this.plugin.getMessage("gui.back_to_worlds", "Back to Worlds");
            meta.setDisplayName(String.valueOf(ChatColor.RED) + backText);
            back.setItemMeta(meta);
        }
        gui.setItem(49, back);
    }

    public void openChunkActionsMenu(Player player, RedstoneDetector.ChunkCoordinate coord) {
        String title = this.plugin.getMessage("gui.chunk_actions_title", "Chunk Actions");
        Inventory gui = Bukkit.createInventory(null, (int)27, (String)title);
        gui.setItem(10, this.createItem(Material.BOOK, String.valueOf(ChatColor.YELLOW) + this.plugin.getMessage("gui.chunk_info", "View Chunk Details")));
        gui.setItem(12, this.createItem(Material.ENDER_PEARL, String.valueOf(ChatColor.GREEN) + this.plugin.getMessage("gui.chunk_teleport", "Teleport to Chunk")));
        gui.setItem(14, this.createItem(Material.REDSTONE_BLOCK, String.valueOf(ChatColor.RED) + this.plugin.getMessage("gui.chunk_remove_redstone", "Remove Redstone")));
        gui.setItem(16, this.createItem(Material.EMERALD, String.valueOf(ChatColor.GREEN) + this.plugin.getMessage("gui.chunk_restore_redstone", "Restore Redstone")));
        gui.setItem(22, this.createItem(Material.ARROW, String.valueOf(ChatColor.GRAY) + this.plugin.getMessage("gui.back_to_chunks", "Back to Chunks")));
        PlayerGuiState state = new PlayerGuiState(GuiState.CHUNK_ACTIONS);
        if (this.playerStates.containsKey(player.getUniqueId())) {
            PlayerGuiState prevState = this.playerStates.get(player.getUniqueId());
            state.world = prevState.world;
            state.page = prevState.page;
        }
        state.chunkCoord = coord;
        this.playerStates.put(player.getUniqueId(), state);
        player.openInventory(gui);
    }

    private ItemStack createItem(Material material, String name) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            item.setItemMeta(meta);
        }
        return item;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        PlayerGuiState state = this.playerStates.get(player.getUniqueId());
        if (state == null) {
            return;
        }
        String title = event.getView().getTitle();
        ItemStack item = event.getCurrentItem();
        if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasDisplayName()) {
            return;
        }
        String displayName = ChatColor.stripColor((String)item.getItemMeta().getDisplayName());
        if (state.state == GuiState.WORLD_SELECTION) {
            this.handleWorldSelectionClick(player, displayName);
        } else if (state.state == GuiState.CHUNK_LIST) {
            this.handleChunkListClick(player, state, displayName, item, event.isShiftClick(), event.isRightClick());
        } else if (state.state == GuiState.CHUNK_ACTIONS) {
            this.handleChunkActionsClick(player, state, displayName);
        }
        event.setCancelled(true);
    }

    private void handleWorldSelectionClick(Player player, String displayName) {
        this.openChunksGUI(player, displayName, 0);
    }

    private void handleChunkListClick(Player player, PlayerGuiState state, String displayName, ItemStack item, boolean isShiftClick, boolean isRightClick) {
        String backToWorlds = ChatColor.stripColor((String)this.plugin.getMessage("gui.back_to_worlds", "Back to Worlds"));
        String previousPage = ChatColor.stripColor((String)this.plugin.getMessage("gui.previous_page", "Previous Page"));
        String nextPage = ChatColor.stripColor((String)this.plugin.getMessage("gui.next_page", "Next Page"));
        if (displayName.equals(backToWorlds)) {
            this.openWorldSelectionGUI(player);
        } else if (displayName.equals(previousPage)) {
            this.openChunksGUI(player, state.world, state.page - 1);
        } else if (displayName.equals(nextPage)) {
            this.openChunksGUI(player, state.world, state.page + 1);
        } else if (item != null && item.getType() == Material.MAP) {
            String chunkText = ChatColor.stripColor((String)this.plugin.getMessage("gui.chunk_item_name", "Chunk {coord}"));
            String chunkName = displayName.replace(chunkText.replace("{coord}", ""), "").trim();
            String[] parts = (chunkName = chunkName.replace("[", "").replace("]", "")).split(", ");
            if (parts.length == 2) {
                try {
                    int x = Integer.parseInt(parts[0]);
                    int z = Integer.parseInt(parts[1]);
                    RedstoneDetector.ChunkCoordinate coord = new RedstoneDetector.ChunkCoordinate(state.world, x, z);
                    if (isShiftClick && isRightClick) {
                        this.plugin.disableRedstoneInChunk(player, coord);
                        player.closeInventory();
                        this.openChunksGUI(player, state.world, state.page);
                    } else if (!isShiftClick && !isRightClick) {
                        this.openChunkActionsMenu(player, coord);
                    }
                }
                catch (NumberFormatException e) {
                    String errorMsg = this.plugin.getMessage("gui.error_chunk_processing", "Error processing chunk coordinates!");
                    player.sendMessage(String.valueOf(ChatColor.RED) + errorMsg);
                }
            }
        }
    }

    private void handleChunkActionsClick(Player player, PlayerGuiState state, String displayName) {
        String backToChunks = ChatColor.stripColor((String)this.plugin.getMessage("gui.back_to_chunks", "Back to Chunks"));
        String chunkInfo = ChatColor.stripColor((String)this.plugin.getMessage("gui.chunk_info", "View Chunk Details"));
        String chunkTeleport = ChatColor.stripColor((String)this.plugin.getMessage("gui.chunk_teleport", "Teleport to Chunk"));
        String removeRedstone = ChatColor.stripColor((String)this.plugin.getMessage("gui.chunk_remove_redstone", "Remove Redstone"));
        String restoreRedstone = ChatColor.stripColor((String)this.plugin.getMessage("gui.chunk_restore_redstone", "Restore Redstone"));
        if (displayName.equals(backToChunks)) {
            this.openChunksGUI(player, state.world, state.page);
        } else if (displayName.equals(chunkInfo)) {
            this.plugin.openChunkDetails(player, state.chunkCoord);
            player.closeInventory();
        } else if (displayName.equals(chunkTeleport)) {
            this.plugin.teleportToChunk(player, state.chunkCoord);
            player.closeInventory();
        } else if (displayName.equals(removeRedstone)) {
            this.plugin.disableRedstoneInChunk(player, state.chunkCoord);
            player.closeInventory();
        } else if (displayName.equals(restoreRedstone)) {
            this.plugin.restoreRedstoneInChunk(player, state.chunkCoord);
            player.closeInventory();
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.savePlayerStates();
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        this.savePlayerStates();
    }

    public void savePlayerStates() {
        try {
            File file = new File(this.plugin.getDataFolder(), "player_states.yml");
            YamlConfiguration config = new YamlConfiguration();
            for (Map.Entry<UUID, PlayerGuiState> entry : this.playerStates.entrySet()) {
                String path = "states." + String.valueOf(entry.getKey());
                PlayerGuiState state = entry.getValue();
                config.set(path + ".state", (Object)state.state.name());
                config.set(path + ".world", (Object)state.world);
                config.set(path + ".page", (Object)state.page);
                if (state.chunkCoord == null) continue;
                config.set(path + ".chunkCoord", (Object)state.chunkCoord.toString());
            }
            config.save(file);
        }
        catch (IOException e) {
            String errorMsg = this.plugin.getMessage("gui.error_saving_states", "Error saving player states: ");
            this.plugin.getLogger().severe(errorMsg + e.getMessage());
        }
    }

    public void loadPlayerStates() {
        try {
            File file = new File(this.plugin.getDataFolder(), "player_states.yml");
            if (!file.exists()) {
                return;
            }
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            if (!config.contains("states")) {
                return;
            }
            for (String key : config.getConfigurationSection("states").getKeys(false)) {
                UUID playerId = UUID.fromString(key);
                String path = "states." + key;
                PlayerGuiState state = new PlayerGuiState(GuiState.valueOf(config.getString(path + ".state")));
                state.world = config.getString(path + ".world");
                state.page = config.getInt(path + ".page");
                String coordStr = config.getString(path + ".chunkCoord");
                if (coordStr != null) {
                    state.chunkCoord = RedstoneDetector.ChunkCoordinate.fromString(coordStr);
                }
                this.playerStates.put(playerId, state);
            }
        }
        catch (Exception e) {
            String errorMsg = this.plugin.getMessage("gui.error_loading_states", "Error loading player states: ");
            this.plugin.getLogger().severe(errorMsg + e.getMessage());
        }
    }

    public void restorePlayerState(Player player) {
        PlayerGuiState state = this.playerStates.get(player.getUniqueId());
        if (state == null) {
            this.openWorldSelectionGUI(player);
            return;
        }
        switch (state.state.ordinal()) {
            case 0: {
                this.openWorldSelectionGUI(player);
                break;
            }
            case 1: {
                this.openChunksGUI(player, state.world, state.page);
                break;
            }
            case 2: {
                this.openChunkActionsMenu(player, state.chunkCoord);
                break;
            }
            default: {
                this.openWorldSelectionGUI(player);
            }
        }
    }

    public static class PlayerGuiState {
        public GuiState state;
        public String world;
        public int page;
        public RedstoneDetector.ChunkCoordinate chunkCoord;

        public PlayerGuiState(GuiState state) {
            this.state = state;
        }
    }

    public static enum GuiState {
        WORLD_SELECTION,
        CHUNK_LIST,
        CHUNK_ACTIONS;

    }
}

