/*
 * Decompiled with CFR 0.152.
 */
package ru.stepanyaa.redstoneDetector;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import ru.stepanyaa.redstoneDetector.GuiManager;
import ru.stepanyaa.redstoneDetector.bukkit.Metrics;

public class RedstoneDetector
extends JavaPlugin
implements Listener,
TabCompleter {
    private final Map<ChunkCoordinate, ChunkData> chunkMap = new ConcurrentHashMap<ChunkCoordinate, ChunkData>();
    private GuiManager guiManager;
    private boolean freezeRedstone = false;
    private long lastFreezeTime = 0L;
    private boolean monitoringEnabled = true;
    private double criticalTPS = 15.0;
    private int maxRedstone = 100;
    private int maxEntities = 100;
    private final Map<ChunkCoordinate, Map<Location, Material>> redstoneBackups = new ConcurrentHashMap<ChunkCoordinate, Map<Location, Material>>();
    private final Set<Material> redstoneMaterials = new HashSet<Material>();
    private int chunksPerTick = 3;
    private boolean firstCriticalState = true;
    private File chunkDataFile;
    private YamlConfiguration chunkDataConfig;
    private long lastTPSWarning = 0L;
    private final long TPS_WARNING_COOLDOWN = 10000L;
    private double lastReportedTPS = 20.0;
    private static final String CURRENT_VERSION = "1.0.0";
    private boolean isFirstEnable = true;
    private FileConfiguration messagesConfig;
    private File messagesFile;
    private String language;
    private static final String[] SUPPORTED_LANGUAGES = new String[]{"en", "ru"};
    private String latestVersion = null;

    public void onEnable() {
        this.loadMessages();
        this.getLogger().info(this.getMessage("plugin.startup", "======== RedstoneDetector STARTING ========"));
        this.saveDefaultConfig();
        this.reloadConfig();
        this.loadConfig();
        this.updateConfigFile();
        this.updateMessagesFiles();
        this.chunkDataFile = new File(this.getDataFolder(), "chunk-data.yml");
        this.loadChunkData();
        this.initializeRedstoneMaterials();
        this.guiManager = new GuiManager(this);
        this.guiManager.loadPlayerStates();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.guiManager, (Plugin)this);
        this.registerCommands();
        this.startOptimizedChunkScanTask();
        this.startAutoSaveTask();
        this.getLogger().info(this.getMessage("plugin.enabled", "Plugin successfully enabled!"));
        this.checkForUpdates();
        this.isFirstEnable = false;
        int pluginId = 27778;
        Metrics metrics = new Metrics(this, pluginId);
    }

    private void updateConfigFile() {
        File configFile = new File(this.getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            this.saveResource("config.yml", false);
            this.getLogger().info(this.getMessage("warning.config-file-create", "Created config file: config.yml"));
            return;
        }
        YamlConfiguration existingConfig = YamlConfiguration.loadConfiguration((File)configFile);
        String currentFileVersion = existingConfig.getString("config-version", "0.0.0");
        if (currentFileVersion.equals(CURRENT_VERSION)) {
            if (this.isFirstEnable) {
                this.getLogger().info(this.getMessage("warning.config-file-up-to-date", "Config file config.yml is up-to-date (version %version%).").replace("%version%", CURRENT_VERSION));
            }
            return;
        }
        if (this.getResource("config.yml") != null) {
            try {
                this.saveResource("config.yml", true);
                this.getLogger().info(this.getMessage("warning.config-file-updated", "Updated config.yml to version %version%.").replace("%version%", CURRENT_VERSION));
                YamlConfiguration newConfig = YamlConfiguration.loadConfiguration((File)configFile);
                newConfig.set("config-version", (Object)CURRENT_VERSION);
                newConfig.save(configFile);
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to update config.yml: " + e.getMessage());
            }
        } else {
            this.getLogger().warning(this.getMessage("warning.config-file-not-found", "Resource config.yml not found in plugin!"));
        }
    }

    private void updateMessagesFiles() {
        for (String lang : SUPPORTED_LANGUAGES) {
            YamlConfiguration existingConfig;
            String currentFileVersion;
            String fileName = "messages_" + lang + ".yml";
            File messageFile = new File(this.getDataFolder(), fileName);
            if (!messageFile.exists()) {
                if (this.getResource(fileName) != null) {
                    this.saveResource(fileName, false);
                    this.getLogger().info(this.getMessage("warning.messages-file-create", "Created messages file: %file%").replace("%file%", fileName));
                } else {
                    this.getLogger().warning(this.getMessage("warning.messages-file-not-found", "Messages file %file% not found in plugin!").replace("%file%", fileName));
                    continue;
                }
            }
            if ((currentFileVersion = (existingConfig = YamlConfiguration.loadConfiguration((File)messageFile)).getString("version", "0.0.0")).equals(CURRENT_VERSION)) {
                if (!this.isFirstEnable) continue;
                this.getLogger().info(this.getMessage("warning.messages-file-up-to-date", "Messages file %file% is up-to-date (version %version%).").replace("%file%", fileName).replace("%version%", CURRENT_VERSION));
                continue;
            }
            if (this.getResource(fileName) != null) {
                try {
                    this.saveResource(fileName, true);
                    this.getLogger().info(this.getMessage("warning.messages-file-updated", "Updated messages file %file% to version %version%.").replace("%file%", fileName).replace("%version%", CURRENT_VERSION));
                    YamlConfiguration newConfig = YamlConfiguration.loadConfiguration((File)messageFile);
                    newConfig.set("version", (Object)CURRENT_VERSION);
                    newConfig.save(messageFile);
                }
                catch (Exception e) {
                    this.getLogger().warning("Failed to update messages file " + fileName + ": " + e.getMessage());
                }
                continue;
            }
            this.getLogger().warning(this.getMessage("warning.messages-file-not-found", "Messages file %file% not found in plugin!").replace("%file%", fileName));
        }
    }

    private void loadMessages() {
        this.language = this.getConfig().getString("language", "en");
        if (!Arrays.asList(SUPPORTED_LANGUAGES).contains(this.language)) {
            this.getLogger().warning("Unsupported language '" + this.language + "' in config.yml, defaulting to 'en'");
            this.language = "en";
        }
        String messagesFileName = "messages_" + this.language + ".yml";
        this.messagesFile = new File(this.getDataFolder(), messagesFileName);
        this.messagesConfig = new YamlConfiguration();
        try {
            if (this.messagesFile.exists()) {
                this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
            } else {
                this.getLogger().warning("Messages file " + messagesFileName + " does not exist!");
            }
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to load messages file: " + e.getMessage());
        }
    }

    public String getMessage(String key, String defaultValue) {
        if (this.messagesConfig == null) {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)defaultValue);
        }
        String message = this.messagesConfig.getString(key, defaultValue);
        if (message == null || message.isEmpty()) {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)defaultValue);
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    private void initializeRedstoneMaterials() {
        Material[] materials = new Material[]{Material.REDSTONE_WIRE, Material.REPEATER, Material.COMPARATOR, Material.PISTON, Material.STICKY_PISTON, Material.OBSERVER, Material.DISPENSER, Material.DROPPER, Material.HOPPER, Material.REDSTONE_TORCH, Material.REDSTONE_BLOCK, Material.LEVER, Material.STONE_BUTTON, Material.OAK_BUTTON, Material.TRIPWIRE_HOOK, Material.TARGET};
        Collections.addAll(this.redstoneMaterials, materials);
    }

    private boolean isRedstoneComponent(Material material) {
        return this.redstoneMaterials.contains(material);
    }

    public void onDisable() {
        if (this.guiManager != null) {
            this.guiManager.savePlayerStates();
        }
        this.saveChunkData();
        this.getLogger().info(this.getMessage("plugin.shutdown", "GUI states and chunk data saved"));
    }

    private void registerCommands() {
        Objects.requireNonNull(this.getCommand("redstonedetector")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.getCommand("rd")).setExecutor((CommandExecutor)this);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        String command = cmd.getName().toLowerCase();
        if (command.equals("redstonedetector") || command.equals("rd")) {
            if (args.length == 0) {
                return this.openGuiCommand(sender);
            }
            return this.handleSubCommand(sender, args);
        }
        return false;
    }

    private boolean handleSubCommand(CommandSender sender, String[] args) {
        String subCommand;
        return switch (subCommand = args[0].toLowerCase()) {
            case "reload" -> this.reloadCommand(sender);
            case "gui" -> this.openGuiCommand(sender);
            case "redstone" -> this.redstoneCommand(sender, args);
            case "stopredstone" -> this.stopRedstoneCommand(sender);
            case "scan" -> this.scanCommand(sender);
            default -> {
                this.sendHelp(sender);
                yield true;
            }
        };
    }

    private boolean openGuiCommand(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + this.getMessage("command.player_only", "This command is for players only!"));
            return true;
        }
        Player player = (Player)sender;
        if (!sender.hasPermission("redstonedetector.gui")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + this.getMessage("command.no_permission_gui", "You do not have permission to use the GUI!"));
            return true;
        }
        this.guiManager.restorePlayerState(player);
        return true;
    }

    private boolean reloadCommand(CommandSender sender) {
        if (!sender.hasPermission("redstonedetector.reload")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + this.getMessage("command.no_permission_reload", "You do not have permission to reload the plugin!"));
            return true;
        }
        this.reloadConfig();
        this.loadConfig();
        this.loadMessages();
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + this.getMessage("command.reload_success", "Configuration reloaded!"));
        return true;
    }

    private boolean redstoneCommand(CommandSender sender, String[] args) {
        if (!sender.hasPermission("redstonedetector.redstone")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + this.getMessage("command.no_permission_redstone", "You do not have permission to manage redstone!"));
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + this.getMessage("command.redstone_usage", "Usage: /redstonedetector redstone [freeze|unfreeze|status]"));
            return true;
        }
        switch (args[1].toLowerCase()) {
            case "freeze": {
                this.setFreezeRedstone(true, sender.getName());
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + this.getMessage("command.redstone_frozen", "Redstone frozen!"));
                break;
            }
            case "unfreeze": {
                this.setFreezeRedstone(false, sender.getName());
                this.monitoringEnabled = true;
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + this.getMessage("command.redstone_unfrozen", "Redstone unfrozen!"));
                break;
            }
            case "status": {
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + this.getMessage("command.redstone_status", "Redstone status: {status}").replace("{status}", this.freezeRedstone ? String.valueOf(ChatColor.RED) + this.getMessage("command.redstone_status_frozen", "FROZEN") : String.valueOf(ChatColor.GREEN) + this.getMessage("command.redstone_status_active", "ACTIVE")));
                break;
            }
            default: {
                sender.sendMessage(String.valueOf(ChatColor.RED) + this.getMessage("command.redstone_usage", "Usage: /redstonedetector redstone [freeze|unfreeze|status]"));
            }
        }
        return true;
    }

    private boolean stopRedstoneCommand(CommandSender sender) {
        if (!sender.hasPermission("redstonedetector.redstone")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + this.getMessage("command.no_permission_redstone", "You do not have permission to manage redstone!"));
            return true;
        }
        this.setFreezeRedstone(true, sender.getName());
        this.monitoringEnabled = false;
        sender.sendMessage(String.valueOf(ChatColor.RED) + this.getMessage("command.redstone_stopped", "Redstone activity forcibly stopped!"));
        return true;
    }

    private boolean scanCommand(CommandSender sender) {
        if (!sender.hasPermission("redstonedetector.scan")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + this.getMessage("command.no_permission_scan", "You do not have permission to force a scan!"));
            return true;
        }
        this.forceFullRedstoneScan();
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + this.getMessage("command.scan_started", "Forced chunk scan started!"));
        return true;
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + this.getMessage("command.help_header", "=== RedstoneDetector Help ==="));
        if (sender.hasPermission("redstonedetector.gui")) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/redstonedetector gui" + String.valueOf(ChatColor.WHITE) + this.getMessage("command.help_gui", " - Open the interface"));
        }
        if (sender.hasPermission("redstonedetector.reload")) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/redstonedetector reload" + String.valueOf(ChatColor.WHITE) + this.getMessage("command.help_reload", " - Reload the configuration"));
        }
        if (sender.hasPermission("redstonedetector.redstone")) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/redstonedetector redstone freeze" + String.valueOf(ChatColor.WHITE) + this.getMessage("command.help_redstone_freeze", " - Freeze redstone"));
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/redstonedetector redstone unfreeze" + String.valueOf(ChatColor.WHITE) + this.getMessage("command.help_redstone_unfreeze", " - Unfreeze redstone"));
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/redstonedetector redstone status" + String.valueOf(ChatColor.WHITE) + this.getMessage("command.help_redstone_status", " - Redstone status"));
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/redstonedetector stopredstone" + String.valueOf(ChatColor.WHITE) + this.getMessage("command.help_stopredstone", " - Emergency stop"));
        }
        if (sender.hasPermission("redstonedetector.scan")) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/redstonedetector scan" + String.valueOf(ChatColor.WHITE) + this.getMessage("command.help_scan", " - Force chunk scan"));
        }
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + this.getMessage("command.help_aliases", "Aliases: ") + String.valueOf(ChatColor.YELLOW) + "/rd");
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args) {
        if (cmd.getName().equalsIgnoreCase("redstonedetector") || cmd.getName().equalsIgnoreCase("rd")) {
            if (args.length == 1) {
                ArrayList<String> completions = new ArrayList<String>();
                if (sender.hasPermission("redstonedetector.gui")) {
                    completions.add("gui");
                }
                if (sender.hasPermission("redstonedetector.reload")) {
                    completions.add("reload");
                }
                if (sender.hasPermission("redstonedetector.redstone")) {
                    completions.add("redstone");
                    completions.add("stopredstone");
                }
                if (sender.hasPermission("redstonedetector.scan")) {
                    completions.add("scan");
                }
                return completions;
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("redstone")) {
                return Arrays.asList("freeze", "unfreeze", "status");
            }
        }
        return Collections.emptyList();
    }

    private void loadConfig() {
        this.reloadConfig();
        FileConfiguration config = this.getConfig();
        this.criticalTPS = config.getDouble("critical-tps", 15.0);
        this.maxRedstone = config.getInt("max-redstone", 100);
        this.maxEntities = config.getInt("max-entities", 100);
        this.chunksPerTick = config.getInt("chunks-per-tick", 3);
    }

    private void loadChunkData() {
        try {
            if (!this.chunkDataFile.exists() && !this.chunkDataFile.createNewFile()) {
                this.getLogger().severe(this.getMessage("data.error_chunk_file", "Failed to create chunk data file"));
            }
        }
        catch (IOException e) {
            this.getLogger().severe(this.getMessage("data.error_chunk_create", "Error creating chunk data file: ") + e.getMessage());
        }
        this.chunkDataConfig = YamlConfiguration.loadConfiguration((File)this.chunkDataFile);
        this.chunkMap.clear();
        long currentTime = System.currentTimeMillis();
        boolean changed = false;
        for (String key : this.chunkDataConfig.getKeys(false)) {
            ConfigurationSection section = this.chunkDataConfig.getConfigurationSection(key);
            if (section == null) continue;
            ChunkCoordinate coord = ChunkCoordinate.fromString(key);
            ChunkData data = new ChunkData();
            data.redstoneCount.set(section.getInt("redstone"));
            data.entityCount.set(section.getInt("entities"));
            data.firstDetected = section.getLong("firstDetected");
            data.lastScanned = section.getLong("lastScanned");
            data.clearedByAdmin = section.getBoolean("cleared", false);
            data.clearedTime = section.getLong("clearedTime", 0L);
            if (data.clearedByAdmin) {
                if (currentTime - data.clearedTime > 600000L) {
                    this.chunkDataConfig.set(key, null);
                    changed = true;
                    continue;
                }
                Bukkit.getScheduler().runTaskLater((Plugin)this, () -> this.chunkMap.remove(coord), (600000L - (currentTime - data.clearedTime)) / 50L);
                continue;
            }
            if (currentTime - data.lastScanned > (long)this.getConfig().getInt("chunk-data-retention", 24) * 3600000L) {
                this.chunkDataConfig.set(key, null);
                changed = true;
                continue;
            }
            this.chunkMap.put(coord, data);
        }
        if (changed) {
            this.saveChunkData();
        }
    }

    public void saveChunkData() {
        try {
            for (String key : this.chunkDataConfig.getKeys(false)) {
                this.chunkDataConfig.set(key, null);
            }
            long retentionPeriod = (long)this.getConfig().getInt("chunk-data-retention", 24) * 3600000L;
            long currentTime = System.currentTimeMillis();
            for (Map.Entry<ChunkCoordinate, ChunkData> entry : this.chunkMap.entrySet()) {
                ChunkCoordinate coord = entry.getKey();
                ChunkData data = entry.getValue();
                if (currentTime - data.lastScanned > retentionPeriod) continue;
                ConfigurationSection section = this.chunkDataConfig.createSection(coord.toString());
                section.set("redstone", (Object)data.redstoneCount.get());
                section.set("entities", (Object)data.entityCount.get());
                section.set("firstDetected", (Object)data.firstDetected);
                section.set("lastScanned", (Object)data.lastScanned);
                section.set("cleared", (Object)data.clearedByAdmin);
                section.set("clearedTime", (Object)data.clearedTime);
            }
            this.chunkDataConfig.save(this.chunkDataFile);
        }
        catch (IOException e) {
            this.getLogger().severe(this.getMessage("data.error_chunk_save", "Error saving chunk data: ") + e.getMessage());
        }
    }

    private void startAutoSaveTask() {
        new BukkitRunnable(){

            public void run() {
                RedstoneDetector.this.saveChunkData();
                RedstoneDetector.this.getLogger().info(RedstoneDetector.this.getMessage("data.autosave", "Data automatically saved"));
            }
        }.runTaskTimer((Plugin)this, 6000L, 6000L);
    }

    private void startOptimizedChunkScanTask() {
        new BukkitRunnable(){
            private final Queue<Chunk> chunkQueue = new LinkedList<Chunk>();
            private boolean wasLowTPS = false;
            private long lastTPSCheck = 0L;
            private final long TPS_CHECK_INTERVAL = 1000L;

            public void run() {
                boolean criticalState;
                if (!RedstoneDetector.this.monitoringEnabled) {
                    return;
                }
                long currentTime = System.currentTimeMillis();
                if (currentTime - this.lastTPSCheck < 1000L) {
                    return;
                }
                this.lastTPSCheck = currentTime;
                double currentTPS = 20.0;
                try {
                    double[] recentTps = Bukkit.getTPS();
                    if (recentTps != null && recentTps.length > 0) {
                        currentTPS = recentTps[0];
                    }
                }
                catch (Exception e) {
                    RedstoneDetector.this.getLogger().warning(RedstoneDetector.this.getMessage("tps.error", "Error retrieving TPS: ") + e.getMessage());
                }
                boolean bl = criticalState = currentTPS < RedstoneDetector.this.criticalTPS;
                if (criticalState) {
                    if (RedstoneDetector.this.firstCriticalState) {
                        RedstoneDetector.this.firstCriticalState = false;
                        RedstoneDetector.this.forceFullRedstoneScan();
                    }
                    this.wasLowTPS = true;
                    if (Math.abs(currentTPS - RedstoneDetector.this.lastReportedTPS) > 1.0 && System.currentTimeMillis() - RedstoneDetector.this.lastTPSWarning > 10000L) {
                        RedstoneDetector.this.lastTPSWarning = System.currentTimeMillis();
                        RedstoneDetector.this.lastReportedTPS = currentTPS;
                        RedstoneDetector.this.getLogger().warning(RedstoneDetector.this.getMessage("tps.critical", "Critical TPS: ") + currentTPS);
                    }
                    if (!RedstoneDetector.this.freezeRedstone) {
                        RedstoneDetector.this.setFreezeRedstone(true, "System");
                    }
                    RedstoneDetector.this.lastFreezeTime = System.currentTimeMillis();
                    if (this.chunkQueue.isEmpty()) {
                        for (World world : RedstoneDetector.this.getServer().getWorlds()) {
                            for (Chunk chunk : world.getLoadedChunks()) {
                                if (!chunk.isLoaded()) continue;
                                this.chunkQueue.add(chunk);
                            }
                        }
                    }
                    for (int i = 0; i < RedstoneDetector.this.chunksPerTick && !this.chunkQueue.isEmpty(); ++i) {
                        Chunk chunk = this.chunkQueue.poll();
                        if (chunk == null || !chunk.isLoaded()) continue;
                        RedstoneDetector.this.scanChunk(chunk);
                    }
                } else if (this.wasLowTPS) {
                    this.wasLowTPS = false;
                    RedstoneDetector.this.firstCriticalState = true;
                    this.chunkQueue.clear();
                    long elapsed = currentTime - RedstoneDetector.this.lastFreezeTime;
                    long freezeDuration = (long)RedstoneDetector.this.getConfig().getInt("freeze-duration", 60) * 1000L;
                    if (RedstoneDetector.this.freezeRedstone && elapsed >= freezeDuration) {
                        RedstoneDetector.this.setFreezeRedstone(false, "System");
                        RedstoneDetector.this.getLogger().info(RedstoneDetector.this.getMessage("tps.recovered", "Auto-unfreeze: TPS restored to ") + currentTPS);
                    }
                }
            }
        }.runTaskTimer((Plugin)this, 100L, 1L);
    }

    private void forceFullRedstoneScan() {
        this.getLogger().info(this.getMessage("chunk.scan_forced", "Forced scanning of all chunks due to low TPS"));
        for (World world : this.getServer().getWorlds()) {
            for (Chunk chunk : world.getLoadedChunks()) {
                if (!chunk.isLoaded()) continue;
                this.scanChunk(chunk);
            }
        }
    }

    private void scanChunk(Chunk chunk) {
        if (chunk == null || !chunk.isLoaded()) {
            return;
        }
        World world = chunk.getWorld();
        ChunkCoordinate coord = new ChunkCoordinate(world.getName(), chunk.getX(), chunk.getZ());
        ChunkData data = this.chunkMap.computeIfAbsent(coord, k -> new ChunkData());
        if (data.clearedByAdmin) {
            return;
        }
        int redstoneCount = 0;
        int entityCount = 0;
        for (int y = world.getMinHeight(); y < world.getMaxHeight(); ++y) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    Block block = chunk.getBlock(x, y, z);
                    if (!this.isRedstoneComponent(block.getType())) continue;
                    ++redstoneCount;
                }
            }
        }
        entityCount = (int)Arrays.stream(chunk.getEntities()).filter(e -> !(e instanceof Player)).count();
        data.redstoneCount.set(redstoneCount);
        data.entityCount.set(entityCount);
        data.lastScanned = System.currentTimeMillis();
    }

    public void setFreezeRedstone(boolean freeze, String initiator) {
        boolean previousState = this.freezeRedstone;
        this.freezeRedstone = freeze;
        if (freeze && !previousState) {
            this.getLogger().warning(this.getMessage("redstone.frozen_log", "Redstone frozen!"));
            this.cancelActiveRedstone();
        } else if (!freeze && previousState) {
            this.getLogger().warning(this.getMessage("redstone.unfrozen_log", "Redstone unfrozen!"));
        }
    }

    private void cancelActiveRedstone() {
        for (World world : this.getServer().getWorlds()) {
            for (Chunk chunk : world.getLoadedChunks()) {
                for (BlockState state : chunk.getTileEntities()) {
                    if (!this.isRedstoneComponent(state.getType())) continue;
                    state.update(true, false);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockPhysics(BlockPhysicsEvent event) {
        if (this.freezeRedstone && this.isRedstoneComponent(event.getBlock().getType())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPistonExtend(BlockPistonExtendEvent event) {
        if (this.freezeRedstone) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPistonRetract(BlockPistonRetractEvent event) {
        if (this.freezeRedstone) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockRedstone(BlockRedstoneEvent event) {
        if (this.freezeRedstone) {
            event.setNewCurrent(0);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        if (this.freezeRedstone && this.isRedstoneComponent(event.getBlock().getType())) {
            event.setCancelled(true);
            event.getPlayer().sendMessage(String.valueOf(ChatColor.RED) + this.getMessage("redstone.break_blocked", "Redstone is frozen! You cannot break blocks."));
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (this.freezeRedstone && this.isRedstoneComponent(event.getBlock().getType())) {
            event.setCancelled(true);
            event.getPlayer().sendMessage(String.valueOf(ChatColor.RED) + this.getMessage("redstone.place_blocked", "Redstone is frozen! You cannot place blocks."));
        }
    }

    public Map<ChunkCoordinate, ChunkData> getChunkMap() {
        return this.chunkMap;
    }

    public int getMaxRedstone() {
        return this.maxRedstone;
    }

    public int getMaxEntities() {
        return this.maxEntities;
    }

    public int getNotificationCooldown() {
        return this.getConfig().getInt("notification-cooldown", 300);
    }

    public int getItemsPerPage() {
        return 45;
    }

    public void openChunkDetails(Player player, ChunkCoordinate coord) {
        ChunkData data = this.chunkMap.get(coord);
        if (data != null) {
            player.sendMessage(String.valueOf(ChatColor.GOLD) + this.getMessage("chunk.details.header", "Chunk Details {coord}").replace("{coord}", coord.toDisplayString()));
            player.sendMessage(String.valueOf(ChatColor.GRAY) + this.getMessage("chunk.details.world", "World: {world}").replace("{world}", coord.world));
            player.sendMessage(String.valueOf(ChatColor.RED) + this.getMessage("chunk.details.redstone", "Redstone: {count}").replace("{count}", String.valueOf(data.redstoneCount.get())));
            player.sendMessage(String.valueOf(ChatColor.GREEN) + this.getMessage("chunk.details.entities", "Entities: {count}").replace("{count}", String.valueOf(data.entityCount.get())));
        } else {
            player.sendMessage(String.valueOf(ChatColor.RED) + this.getMessage("chunk.details.not_found", "Chunk data not found!"));
        }
    }

    private void checkForUpdates() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            try {
                URL url = new URL("https://api.modrinth.com/v2/project/redstonedetector/version");
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setRequestProperty("User-Agent", "RedstoneDetector/1.0.0");
                conn.connect();
                if (conn.getResponseCode() == 200) {
                    JsonArray versions = JsonParser.parseReader(new InputStreamReader(conn.getInputStream())).getAsJsonArray();
                    String highestVersion = null;
                    for (JsonElement element : versions) {
                        String versionNumber = element.getAsJsonObject().get("version_number").getAsString();
                        String versionType = element.getAsJsonObject().get("version_type").getAsString();
                        if (versionNumber.contains("-SNAPSHOT") && !versionType.equals("release") || highestVersion != null && !this.isNewerVersion(versionNumber, highestVersion)) continue;
                        highestVersion = versionNumber;
                    }
                    if (highestVersion != null && this.isNewerVersion(highestVersion, CURRENT_VERSION)) {
                        String[] currentParts = CURRENT_VERSION.split("\\.");
                        String[] highestParts = highestVersion.split("\\.");
                        if (currentParts.length == 3 && highestParts.length == 3) {
                            int currentMajor = Integer.parseInt(currentParts[0]);
                            int currentMinor = Integer.parseInt(currentParts[1]);
                            int currentPatch = Integer.parseInt(currentParts[2]);
                            int highestMajor = Integer.parseInt(highestParts[0]);
                            int highestMinor = Integer.parseInt(highestParts[1]);
                            int highestPatch = Integer.parseInt(highestParts[2]);
                            if (currentMajor == highestMajor && currentMinor == highestMinor && highestPatch == currentPatch + 1) {
                                this.latestVersion = highestVersion;
                                this.getLogger().warning("*** UPDATE AVAILABLE *** A new version of RedstoneDetector (" + this.latestVersion + ") is available at:\nhttps://modrinth.com/plugin/redstonedetector/versions");
                            }
                        }
                    }
                }
                conn.disconnect();
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to check for updates: " + e.getMessage());
            }
        });
    }

    private boolean isNewerVersion(String version1, String version2) {
        String[] parts1 = version1.split("\\.");
        String[] parts2 = version2.split("\\.");
        for (int i = 0; i < Math.min(parts1.length, parts2.length); ++i) {
            int num2;
            int num1 = Integer.parseInt(parts1[i]);
            if (num1 > (num2 = Integer.parseInt(parts2[i]))) {
                return true;
            }
            if (num1 >= num2) continue;
            return false;
        }
        return parts1.length > parts2.length;
    }

    public void teleportToChunk(Player player, ChunkCoordinate coord) {
        World world = this.getServer().getWorld(coord.world);
        if (world != null) {
            Location loc = new Location(world, (double)(coord.x * 16 + 8), (double)(world.getHighestBlockYAt(coord.x * 16 + 8, coord.z * 16 + 8) + 1), (double)(coord.z * 16 + 8));
            player.teleport(loc);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + this.getMessage("chunk.teleport_success", "Teleported to chunk {coord}").replace("{coord}", coord.toDisplayString()));
        } else {
            player.sendMessage(String.valueOf(ChatColor.RED) + this.getMessage("chunk.world_not_found", "World '{world}' not found!").replace("{world}", coord.world));
        }
    }

    public void disableRedstoneInChunk(Player player, ChunkCoordinate coord) {
        this.disableRedstoneInChunk(coord, player.getName());
        player.sendMessage(String.valueOf(ChatColor.GREEN) + this.getMessage("chunk.redstone_removed", "Redstone removed in chunk {coord}").replace("{coord}", coord.toDisplayString()));
    }

    public void disableRedstoneInChunk(ChunkCoordinate coord, String initiator) {
        World world = this.getServer().getWorld(coord.world);
        if (world == null) {
            return;
        }
        Chunk chunk = world.getChunkAt(coord.x, coord.z);
        if (!chunk.isLoaded()) {
            return;
        }
        HashMap<Location, Material> backup = new HashMap<Location, Material>();
        int removed = 0;
        for (int y = world.getMinHeight(); y < world.getMaxHeight(); ++y) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    Block block = chunk.getBlock(x, y, z);
                    if (!this.isRedstoneComponent(block.getType())) continue;
                    backup.put(block.getLocation(), block.getType());
                    block.setType(Material.AIR);
                    ++removed;
                }
            }
        }
        if (removed > 0) {
            this.redstoneBackups.put(coord, backup);
            ChunkData data = this.chunkMap.get(coord);
            if (data != null) {
                data.clearedByAdmin = true;
                data.clearedTime = System.currentTimeMillis();
                Bukkit.getScheduler().runTaskLater((Plugin)this, () -> this.chunkMap.remove(coord), 12000L);
            }
            this.getLogger().info(this.getMessage("chunk.redstone_removed_log", "Removed {count} redstone blocks in chunk: {coord}").replace("{count}", String.valueOf(removed)).replace("{coord}", coord.toDisplayString()));
        }
    }

    public void restoreRedstoneInChunk(Player player, ChunkCoordinate coord) {
        this.restoreRedstoneInChunk(coord, player.getName());
        player.sendMessage(String.valueOf(ChatColor.GREEN) + this.getMessage("chunk.redstone_restored", "Redstone restored in chunk {coord}").replace("{coord}", coord.toDisplayString()));
    }

    public void restoreRedstoneInChunk(ChunkCoordinate coord, String initiator) {
        Map<Location, Material> backup = this.redstoneBackups.get(coord);
        if (backup == null || backup.isEmpty()) {
            return;
        }
        int restored = 0;
        for (Map.Entry<Location, Material> entry : backup.entrySet()) {
            Block block = entry.getKey().getBlock();
            if (!block.isEmpty()) continue;
            block.setType(entry.getValue());
            ++restored;
        }
        this.redstoneBackups.remove(coord);
        this.getLogger().info(this.getMessage("chunk.redstone_restored_log", "Redstone restored in chunk: {coord}").replace("{coord}", coord.toDisplayString()));
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
    }

    public record ChunkCoordinate(String world, int x, int z) {
        @Override
        public String toString() {
            return this.world + ";" + this.x + ";" + this.z;
        }

        public static ChunkCoordinate fromString(String s) {
            String[] parts = s.split(";");
            return new ChunkCoordinate(parts[0], Integer.parseInt(parts[1]), Integer.parseInt(parts[2]));
        }

        public String toDisplayString() {
            return "[" + this.x + ", " + this.z + "]";
        }
    }

    public static class ChunkData {
        public AtomicInteger redstoneCount = new AtomicInteger(0);
        public AtomicInteger entityCount = new AtomicInteger(0);
        public long firstDetected = System.currentTimeMillis();
        public long lastScanned = System.currentTimeMillis();
        public boolean clearedByAdmin = false;
        public long clearedTime = 0L;
    }
}

