/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.soulsarmory.init;

import net.mcreator.soulsarmory.entity.DummyEntity;
import net.mcreator.soulsarmory.entity.HotspotMobEntity;
import net.mcreator.soulsarmory.entity.WatcherEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class SoulsArmoryModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"souls_armory");
    public static final DeferredHolder<EntityType<?>, EntityType<WatcherEntity>> WATCHER = SoulsArmoryModEntities.register("watcher", EntityType.Builder.of(WatcherEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<HotspotMobEntity>> HOTSPOT_MOB = SoulsArmoryModEntities.register("hotspot_mob", EntityType.Builder.of(HotspotMobEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).ridingOffset(-0.6f).sized(1.0f, 1.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<DummyEntity>> DUMMY = SoulsArmoryModEntities.register("dummy", EntityType.Builder.of(DummyEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"souls_armory", (String)registryname))));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        WatcherEntity.init(event);
        HotspotMobEntity.init(event);
        DummyEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)WATCHER.get(), WatcherEntity.createAttributes().build());
        event.put((EntityType)HOTSPOT_MOB.get(), HotspotMobEntity.createAttributes().build());
        event.put((EntityType)DUMMY.get(), DummyEntity.createAttributes().build());
    }
}

