/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.soulsarmory.init;

import net.mcreator.soulsarmory.potion.DamageMobEffect;
import net.mcreator.soulsarmory.procedures.DamageEffectStartedappliedProcedure;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class SoulsArmoryModMobEffects {
    public static final DeferredRegister<MobEffect> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"souls_armory");
    public static final DeferredHolder<MobEffect, MobEffect> DAMAGE = REGISTRY.register("damage", () -> new DamageMobEffect());

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            SoulsArmoryModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            SoulsArmoryModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    private static void expireEffects(Entity entity, MobEffectInstance effectInstance) {
        if (effectInstance.getEffect().is(DAMAGE)) {
            DamageEffectStartedappliedProcedure.execute((LevelAccessor)entity.level(), entity);
        }
    }
}

