/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.soulsarmory.item;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.mcreator.soulsarmory.entity.WardenShotEntity;
import net.mcreator.soulsarmory.procedures.Bow3PlayerFinishesUsingItemProcedure;
import net.mcreator.soulsarmory.procedures.Bow3PropertyValueProviderProcedure;
import net.mcreator.soulsarmory.procedures.Bow3RightclickedProcedure;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.properties.numeric.RangeSelectItemModelProperty;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class Bow3Item
extends Item {
    public Bow3Item(Item.Properties properties) {
        super(properties);
    }

    public ItemUseAnimation getUseAnimation(ItemStack itemstack) {
        return ItemUseAnimation.BOW;
    }

    public int getUseDuration(ItemStack itemstack, LivingEntity livingEntity) {
        return 72000;
    }

    public InteractionResult use(Level world, Player entity, InteractionHand hand) {
        InteractionResult.Fail ar = InteractionResult.FAIL;
        if (entity.getAbilities().instabuild || this.findAmmo(entity) != ItemStack.EMPTY) {
            ar = InteractionResult.SUCCESS;
            entity.startUsingItem(hand);
        }
        return ar;
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        if (selected) {
            Bow3RightclickedProcedure.execute(entity);
        }
    }

    public boolean releaseUsing(ItemStack itemstack, Level world, LivingEntity entity, int time) {
        Bow3PlayerFinishesUsingItemProcedure.execute((Entity)entity);
        if (!world.isClientSide() && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            float pullingPower = BowItem.getPowerForTime((int)(this.getUseDuration(itemstack, (LivingEntity)player) - time));
            if ((double)pullingPower < 0.1) {
                return false;
            }
            ItemStack stack = this.findAmmo((Player)player);
            if (player.getAbilities().instabuild || stack != ItemStack.EMPTY) {
                WardenShotEntity projectile = WardenShotEntity.shoot(world, entity, world.getRandom(), pullingPower);
                if (player.getAbilities().instabuild) {
                    projectile.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                } else if (stack.isDamageableItem()) {
                    if (world instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)world;
                        stack.hurtAndBreak(1, serverLevel, player, _stkprov -> {});
                    }
                } else {
                    stack.shrink(1);
                }
            }
        }
        return super.releaseUsing(itemstack, world, entity, time);
    }

    private ItemStack findAmmo(Player player) {
        return new ItemStack((ItemLike)WardenShotEntity.PROJECTILE_ITEM.getItem());
    }

    public record ChargecheckProperty() implements RangeSelectItemModelProperty
    {
        public static final MapCodec<ChargecheckProperty> MAP_CODEC = MapCodec.unit((Object)new ChargecheckProperty());

        public float get(ItemStack itemStackToRender, @Nullable ClientLevel clientWorld, @Nullable LivingEntity entity, int seed) {
            return (float)Bow3PropertyValueProviderProcedure.execute((Entity)entity);
        }

        public MapCodec<ChargecheckProperty> type() {
            return MAP_CODEC;
        }
    }
}

