/*
 * Decompiled with CFR 0.152.
 */
package net.jadedmc.commandblocker;

import net.jadedmc.commandblocker.Metrics;
import net.jadedmc.commandblocker.SettingsManager;
import net.jadedmc.commandblocker.commands.CommandBlockerCMD;
import net.jadedmc.commandblocker.listeners.PlayerCommandPreprocessListener;
import net.jadedmc.commandblocker.listeners.PlayerCommandSendListener;
import net.jadedmc.commandblocker.shaded.adventure.adventure.platform.bukkit.BukkitAudiences;
import net.jadedmc.commandblocker.utils.ChatUtils;
import net.jadedmc.commandblocker.utils.VersionUtils;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class CommandBlocker
extends JavaPlugin {
    private BukkitAudiences adventure;
    private SettingsManager settingsManager;

    public void onEnable() {
        this.adventure = BukkitAudiences.create((Plugin)this);
        ChatUtils.setAdventure((BukkitAudiences)this.adventure);
        this.settingsManager = new SettingsManager((Plugin)this);
        this.getCommand("commandblocker").setExecutor((CommandExecutor)new CommandBlockerCMD(this));
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerCommandPreprocessListener(this), (Plugin)this);
        if (VersionUtils.getServerVersion() >= 13) {
            this.getServer().getPluginManager().registerEvents((Listener)new PlayerCommandSendListener(this), (Plugin)this);
        }
        new Metrics(this, 18230);
    }

    public void onDisable() {
        if (this.adventure != null) {
            this.adventure.close();
            this.adventure = null;
        }
    }

    public BukkitAudiences adventure() {
        if (this.adventure == null) {
            throw new IllegalStateException("Tried to access Adventure when the plugin was disabled!");
        }
        return this.adventure;
    }

    public SettingsManager getSettingsManager() {
        return this.settingsManager;
    }
}

