/*
 * Decompiled with CFR 0.152.
 */
package net.jadedmc.commandblocker;

import net.jadedmc.commandblocker.ConfigManager;
import net.jadedmc.commandblocker.HookManager;
import net.jadedmc.commandblocker.commands.CommandBlockerCMD;
import net.jadedmc.commandblocker.listeners.PlayerCommandPreprocessListener;
import net.jadedmc.commandblocker.listeners.PlayerCommandSendListener;
import net.jadedmc.commandblocker.listeners.ReloadListener;
import net.jadedmc.commandblocker.shaded.bstats.bukkit.Metrics;
import net.jadedmc.commandblocker.utils.ChatUtils;
import net.jadedmc.commandblocker.utils.VersionUtils;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class CommandBlockerPlugin
extends JavaPlugin {
    private HookManager hookManager;
    private ConfigManager configManager;

    public void onEnable() {
        ChatUtils.initialize(this);
        this.configManager = new ConfigManager((Plugin)this);
        this.hookManager = new HookManager((Plugin)this);
        this.getCommand("commandblocker").setExecutor((CommandExecutor)new CommandBlockerCMD(this));
        this.registerListeners();
        new Metrics(this, 18230);
    }

    public void onDisable() {
        ChatUtils.disable();
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public HookManager getHookManager() {
        return this.hookManager;
    }

    private void registerListeners() {
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerCommandPreprocessListener(this), (Plugin)this);
        if (VersionUtils.getServerVersion() >= 13) {
            this.getServer().getPluginManager().registerEvents((Listener)new PlayerCommandSendListener(this), (Plugin)this);
        }
        if (this.hookManager.useBetterReload()) {
            this.getServer().getPluginManager().registerEvents((Listener)new ReloadListener(this), (Plugin)this);
        }
    }

    public void reload() {
        this.configManager.reloadConfig();
    }
}

