/*
 * Decompiled with CFR 0.152.
 */
package net.jadedmc.commandblocker.commands;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.jadedmc.commandblocker.CommandBlockerPlugin;
import net.jadedmc.commandblocker.utils.ChatUtils;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.jetbrains.annotations.NotNull;

public class CommandBlockerCMD
implements CommandExecutor,
TabCompleter {
    private final CommandBlockerPlugin plugin;

    public CommandBlockerCMD(@NotNull CommandBlockerPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        String subCommand;
        if (!sender.hasPermission("commandblocker.admin")) {
            ChatUtils.chat(sender, this.plugin.getConfigManager().getConfig().getString("Message"));
            return true;
        }
        if (args.length == 0) {
            args = new String[]{"help"};
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "add": {
                if (args.length != 2) {
                    ChatUtils.chat(sender, "<red><bold>Usage</bold> <dark_gray>\u00bb <red>/cb add [command]");
                    return true;
                }
                String toBlock = args[1];
                if (!toBlock.startsWith("/")) {
                    toBlock = "/" + toBlock;
                }
                List commands = this.plugin.getConfigManager().getConfig().getStringList("Commands");
                commands.add(toBlock.toLowerCase());
                this.plugin.getConfigManager().getConfig().set("Commands", (Object)commands);
                this.plugin.getConfigManager().saveConfig();
                this.plugin.getConfigManager().reloadConfig();
                ChatUtils.chat(sender, "<green><bold>CommandBlocker</bold> <dark_gray>\u00bb <green>Added <white>" + toBlock.toLowerCase() + " <green>to the command list.");
                return true;
            }
            case "mode": {
                if (args.length != 2) {
                    ChatUtils.chat(sender, "<red><bold>Usage</bold> <dark_gray>\u00bb <red>/cb mode [mode]");
                    return true;
                }
                String mode = args[1].toUpperCase();
                List<String> validModes = Arrays.asList("BLACKLIST", "WHITELIST", "HIDE");
                if (!validModes.contains(mode)) {
                    ChatUtils.chat(sender, "<red><bold>Error</bold> <dark_gray>\u00bb <red>Mode must be either <white><hover:show_text:\"Click to select BLACKLIST\"><click:suggest_command:\"/cb mode BLACKLIST\">BLACKLIST</click></hover><red>, <white><hover:show_text:\"Click to select WHITELIST\"><click:suggest_command:\"/cb mode WHITELIST\">WHITELIST</click></hover><red>, or <white><hover:show_text:\"Click to select HIDE\"><click:suggest_command:\"/cb mode HIDE\">HIDE</click></hover><red>.");
                    return true;
                }
                this.plugin.getConfigManager().getConfig().set("Mode", (Object)mode);
                this.plugin.getConfigManager().saveConfig();
                this.plugin.getConfigManager().reloadConfig();
                ChatUtils.chat(sender, "<green><bold>CommandBlocker</bold> <dark_gray>\u00bb <green>Changed the current mode to <white>" + mode + " <green>.");
                return true;
            }
            case "reload": {
                this.plugin.reload();
                ChatUtils.chat(sender, "<green><bold>CommandBlocker</bold> <dark_gray>\u00bb <green>Configuration files reloaded successfully!");
                return true;
            }
            case "v": 
            case "version": {
                ChatUtils.chat(sender, "<green><bold>CommandBlocker</bold> <dark_gray>\u00bb <green>Current version: <white>" + this.plugin.getDescription().getVersion());
                return true;
            }
        }
        ChatUtils.chat(sender, "<green><bold>CommandBlocker Commands");
        ChatUtils.chat(sender, "<green><click:suggest_command:\"/cb add \">/cb add [command]</click> <dark_gray>\u00bb <white>Add a command to the command list.");
        ChatUtils.chat(sender, "<green><click:suggest_command:\"/cb mode \">/cb mode [mode]</click> <dark_gray>\u00bb <white>Change the mode the plugin is set to.");
        ChatUtils.chat(sender, "<green><click:suggest_command:\"/cb reload\">/cb reload</click> <dark_gray>\u00bb <white>Reloads all configuration files.");
        ChatUtils.chat(sender, "<green><click:suggest_command:\"/cb version\">/cb version</click> <dark_gray>\u00bb <white>Displays the plugin version.");
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, String[] args) {
        String subCommand;
        if (!sender.hasPermission("commandblocker.admin")) {
            return Collections.emptyList();
        }
        if (args.length < 2) {
            return Arrays.asList("add", "help", "mode", "reload", "version");
        }
        if (args.length == 2 && (subCommand = args[0].toLowerCase()).equals("mode")) {
            return Arrays.asList("BLACKLIST", "HIDE", "WHITELIST");
        }
        return Collections.emptyList();
    }
}

